/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.reactivestreams.client.gridfs.GridFSBucket;
import com.mongodb.reactivestreams.client.gridfs.GridFSDownloadPublisher;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.mongo.GridFsDownloadOptions;
import io.vertx.ext.mongo.GridFsUploadOptions;
import io.vertx.ext.mongo.MongoGridFsClient;
import io.vertx.ext.mongo.impl.CompletionSubscriber;
import io.vertx.ext.mongo.impl.GridFSReadStreamPublisher;
import io.vertx.ext.mongo.impl.JsonObjectBsonAdapter;
import io.vertx.ext.mongo.impl.MappingAndBufferingSubscriber;
import io.vertx.ext.mongo.impl.MappingStream;
import io.vertx.ext.mongo.impl.MongoClientImpl;
import io.vertx.ext.mongo.impl.PublisherAdapter;
import io.vertx.ext.mongo.impl.SingleResultSubscriber;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;

public class MongoGridFsClientImpl
implements MongoGridFsClient {
    private final GridFSBucket bucket;
    private final MongoClientImpl clientImpl;
    private final VertxInternal vertx;
    private final CodecRegistry codecRegistry;

    public MongoGridFsClientImpl(VertxInternal vertx, MongoClientImpl mongoClient, GridFSBucket gridFSBucket, CodecRegistry codecRegistry) {
        this.vertx = vertx;
        this.clientImpl = mongoClient;
        this.bucket = gridFSBucket;
        this.codecRegistry = codecRegistry;
    }

    @Override
    public Future<String> uploadByFileName(ReadStream<Buffer> stream, String fileName) {
        GridFSReadStreamPublisher publisher = new GridFSReadStreamPublisher(stream);
        PromiseInternal promise = this.vertx.promise();
        this.bucket.uploadFromPublisher(fileName, (Publisher)publisher).subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(ObjectId::toHexString);
    }

    @Override
    public Future<String> uploadByFileNameWithOptions(ReadStream<Buffer> stream, String fileName, GridFsUploadOptions options) {
        GridFSUploadOptions uploadOptions = new GridFSUploadOptions();
        uploadOptions.chunkSizeBytes(options.getChunkSizeBytes());
        if (options.getMetadata() != null) {
            uploadOptions.metadata(this.wrap(options.getMetadata()));
        }
        GridFSReadStreamPublisher publisher = new GridFSReadStreamPublisher(stream);
        PromiseInternal promise = this.vertx.promise();
        this.bucket.uploadFromPublisher(fileName, (Publisher)publisher, uploadOptions).subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(ObjectId::toHexString);
    }

    private Document wrap(JsonObject json) {
        Codec codec = this.codecRegistry.get(Document.class);
        BsonDocument bsonDocument = new JsonObjectBsonAdapter(json).toBsonDocument(BsonDocument.class, this.codecRegistry);
        return (Document)codec.decode(bsonDocument.asBsonReader(), DecoderContext.builder().build());
    }

    @Override
    public Future<String> uploadFile(String fileName) {
        Objects.requireNonNull(fileName, "fileName cannot be null");
        return this.uploadFileWithOptions(fileName, null);
    }

    @Override
    public Future<String> uploadFileWithOptions(String fileName, GridFsUploadOptions options) {
        Objects.requireNonNull(fileName, "fileName cannot be null");
        OpenOptions openOptions = new OpenOptions().setRead(true);
        return this.vertx.fileSystem().open(fileName, openOptions).flatMap(file -> {
            GridFSReadStreamPublisher publisher = new GridFSReadStreamPublisher((ReadStream<Buffer>)file);
            PromiseInternal promise = this.vertx.promise();
            if (options == null) {
                this.bucket.uploadFromPublisher(fileName, (Publisher)publisher).subscribe(new SingleResultSubscriber(promise));
            } else {
                GridFSUploadOptions uploadOptions = new GridFSUploadOptions();
                uploadOptions.chunkSizeBytes(options.getChunkSizeBytes());
                if (options.getMetadata() != null) {
                    uploadOptions.metadata(this.wrap(options.getMetadata()));
                }
                this.bucket.uploadFromPublisher(fileName, (Publisher)publisher, uploadOptions).subscribe(new SingleResultSubscriber(promise));
            }
            return promise.future().map(ObjectId::toHexString);
        });
    }

    @Override
    public void close() {
    }

    @Override
    public Future<Void> delete(String id) {
        Objects.requireNonNull(id, "id cannot be null");
        ObjectId objectId = new ObjectId(id);
        PromiseInternal promise = this.vertx.promise();
        this.bucket.delete(objectId).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public ReadStream<Buffer> readByFileName(String fileName) {
        GridFSDownloadPublisher publisher = this.bucket.downloadToPublisher(fileName);
        return this.handleRead(publisher);
    }

    @Override
    public ReadStream<Buffer> readByFileNameWithOptions(String fileName, GridFsDownloadOptions options) {
        GridFSDownloadOptions downloadOptions = new GridFSDownloadOptions();
        GridFSDownloadPublisher publisher = this.bucket.downloadToPublisher(fileName, downloadOptions);
        return this.handleRead(publisher);
    }

    @Override
    public ReadStream<Buffer> readById(String id) {
        ObjectId objectId = new ObjectId(id);
        GridFSDownloadPublisher publisher = this.bucket.downloadToPublisher(objectId);
        return this.handleRead(publisher);
    }

    @Override
    public Future<Long> downloadByFileName(WriteStream<Buffer> stream, String fileName) {
        GridFSDownloadPublisher publisher = this.bucket.downloadToPublisher(fileName);
        return this.handleDownload(publisher, stream);
    }

    @Override
    public Future<Long> downloadByFileNameWithOptions(WriteStream<Buffer> stream, String fileName, GridFsDownloadOptions options) {
        GridFSDownloadOptions downloadOptions = new GridFSDownloadOptions();
        GridFSDownloadPublisher publisher = this.bucket.downloadToPublisher(fileName, downloadOptions);
        return this.handleDownload(publisher, stream);
    }

    @Override
    public Future<Long> downloadById(WriteStream<Buffer> stream, String id) {
        ObjectId objectId = new ObjectId(id);
        GridFSDownloadPublisher publisher = this.bucket.downloadToPublisher(objectId);
        return this.handleDownload(publisher, stream);
    }

    @Override
    public Future<Long> downloadFile(String fileName) {
        Objects.requireNonNull(fileName, "fileName cannot be null");
        return this.downloadFileAs(fileName, fileName);
    }

    @Override
    public Future<Long> downloadFileAs(String fileName, String newFileName) {
        Objects.requireNonNull(fileName, "fileName cannot be null");
        Objects.requireNonNull(newFileName, "newFileName cannot be null");
        OpenOptions options = new OpenOptions().setWrite(true);
        return this.vertx.fileSystem().open(newFileName, options).flatMap(file -> {
            GridFSDownloadPublisher publisher = this.bucket.downloadToPublisher(fileName);
            return this.handleDownload(publisher, (WriteStream<Buffer>)file);
        });
    }

    @Override
    public Future<Long> downloadFileByID(String id, String fileName) {
        Objects.requireNonNull(fileName, "fileName cannot be null");
        OpenOptions options = new OpenOptions().setWrite(true);
        return this.vertx.fileSystem().open(fileName, options).flatMap(file -> {
            ObjectId objectId = new ObjectId(id);
            GridFSDownloadPublisher publisher = this.bucket.downloadToPublisher(objectId);
            return this.handleDownload(publisher, (WriteStream<Buffer>)file);
        });
    }

    @Override
    public Future<Void> drop() {
        PromiseInternal promise = this.vertx.promise();
        this.bucket.drop().subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public Future<List<String>> findAllIds() {
        PromiseInternal promise = this.vertx.promise();
        this.bucket.find().subscribe(new MappingAndBufferingSubscriber<GridFSFile, String>(gridFSFile -> gridFSFile.getObjectId().toHexString(), (Promise<List<String>>)promise));
        return promise.future();
    }

    @Override
    public Future<List<String>> findIds(JsonObject query) {
        Objects.requireNonNull(query, "query cannot be null");
        JsonObject encodedQuery = this.clientImpl.encodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.clientImpl.wrap(encodedQuery);
        PromiseInternal promise = this.vertx.promise();
        this.bucket.find((Bson)bquery).subscribe(new MappingAndBufferingSubscriber<GridFSFile, String>(gridFSFile -> gridFSFile.getObjectId().toHexString(), (Promise<List<String>>)promise));
        return promise.future();
    }

    private Future<Long> handleDownload(GridFSDownloadPublisher publisher, WriteStream<Buffer> stream) {
        PublisherAdapter adapter = new PublisherAdapter((Context)this.vertx.getOrCreateContext(), publisher, 16);
        MapAndCountBuffer mapper = new MapAndCountBuffer();
        MappingStream<ByteBuffer, Buffer> rs = new MappingStream<ByteBuffer, Buffer>(adapter, mapper);
        return rs.pipeTo(stream).map(v -> mapper.count);
    }

    private ReadStream<Buffer> handleRead(GridFSDownloadPublisher publisher) {
        PublisherAdapter adapter = new PublisherAdapter((Context)this.vertx.getOrCreateContext(), publisher, 16);
        MapBuffer mapper = new MapBuffer();
        return new MappingStream<ByteBuffer, Buffer>(adapter, mapper);
    }

    private static class MapBuffer
    implements Function<ByteBuffer, Buffer> {
        private MapBuffer() {
        }

        @Override
        public Buffer apply(ByteBuffer bb) {
            return BufferInternal.buffer((ByteBuf)Unpooled.copiedBuffer((ByteBuffer)bb));
        }
    }

    private static class MapAndCountBuffer
    implements Function<ByteBuffer, Buffer> {
        private long count = 0L;

        private MapAndCountBuffer() {
        }

        @Override
        public Buffer apply(ByteBuffer bb) {
            BufferInternal buffer = BufferInternal.buffer((ByteBuf)Unpooled.copiedBuffer((ByteBuffer)bb));
            this.count += (long)buffer.length();
            return buffer;
        }
    }
}

