/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.mqtt.MqttClientOptions;
import java.util.Map;

public class MqttClientOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, MqttClientOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "cleanSession": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setCleanSession((Boolean)member.getValue());
                    break;
                }
                case "willFlag": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setWillFlag((Boolean)member.getValue());
                    break;
                }
                case "willRetain": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setWillRetain((Boolean)member.getValue());
                    break;
                }
                case "willQoS": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setWillQoS(((Number)member.getValue()).intValue());
                    break;
                }
                case "keepAliveInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setKeepAliveInterval(((Number)member.getValue()).intValue());
                    break;
                }
                case "username": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUsername((String)member.getValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "clientId": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClientId((String)member.getValue());
                    break;
                }
                case "willTopic": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setWillTopic((String)member.getValue());
                    break;
                }
                case "willMessageBytes": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setWillMessageBytes(Buffer.fromJson((String)((String)member.getValue())));
                    break;
                }
                case "ackTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setAckTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxInflightQueue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxInflightQueue(((Number)member.getValue()).intValue());
                    break;
                }
                case "autoKeepAlive": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAutoKeepAlive((Boolean)member.getValue());
                    break;
                }
                case "autoGeneratedClientId": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAutoGeneratedClientId((Boolean)member.getValue());
                    break;
                }
                case "autoAck": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAutoAck((Boolean)member.getValue());
                    break;
                }
                case "maxMessageSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxMessageSize(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(MqttClientOptions obj, JsonObject json) {
        MqttClientOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(MqttClientOptions obj, Map<String, Object> json) {
        json.put("cleanSession", obj.isCleanSession());
        json.put("willFlag", obj.isWillFlag());
        json.put("willRetain", obj.isWillRetain());
        json.put("willQoS", obj.getWillQoS());
        json.put("keepAliveInterval", obj.getKeepAliveInterval());
        if (obj.getUsername() != null) {
            json.put("username", obj.getUsername());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getClientId() != null) {
            json.put("clientId", obj.getClientId());
        }
        if (obj.getWillTopic() != null) {
            json.put("willTopic", obj.getWillTopic());
        }
        if (obj.getWillMessageBytes() != null) {
            json.put("willMessageBytes", obj.getWillMessageBytes().toJson());
        }
        json.put("ackTimeout", obj.getAckTimeout());
        json.put("maxInflightQueue", obj.getMaxInflightQueue());
        json.put("autoKeepAlive", obj.isAutoKeepAlive());
        json.put("autoGeneratedClientId", obj.isAutoGeneratedClientId());
        json.put("autoAck", obj.isAutoAck());
        json.put("maxMessageSize", obj.getMaxMessageSize());
    }
}

