/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.messages.impl;

import io.netty.handler.codec.mqtt.MqttProperties;
import io.vertx.core.buffer.Buffer;
import io.vertx.mqtt.messages.MqttAuthenticationExchangeMessage;
import io.vertx.mqtt.messages.codes.MqttAuthenticateReasonCode;

public class MqttAuthenticationExchangeMessageImpl
implements MqttAuthenticationExchangeMessage {
    private final MqttAuthenticateReasonCode reasonCode;
    private final MqttProperties properties;

    public MqttAuthenticationExchangeMessageImpl(MqttAuthenticateReasonCode reasonCode, MqttProperties properties) {
        this.reasonCode = reasonCode;
        this.properties = properties;
    }

    @Override
    public MqttAuthenticateReasonCode reasonCode() {
        return this.reasonCode;
    }

    @Override
    public String authenticationMethod() {
        MqttProperties.MqttProperty prop = this.properties.getProperty(MqttProperties.MqttPropertyType.AUTHENTICATION_METHOD.value());
        return prop == null ? null : (String)((MqttProperties.StringProperty)prop).value();
    }

    @Override
    public Buffer authenticationData() {
        MqttProperties.MqttProperty prop = this.properties.getProperty(MqttProperties.MqttPropertyType.AUTHENTICATION_DATA.value());
        return prop == null ? null : Buffer.buffer((byte[])((byte[])((MqttProperties.BinaryProperty)prop).value()));
    }

    @Override
    public MqttProperties properties() {
        return this.properties;
    }
}

