/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.mysqlclient.MySQLAuthOptions;
import java.util.LinkedHashMap;
import java.util.Map;

public class MySQLAuthOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, MySQLAuthOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "user": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUser((String)member.getValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "database": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDatabase((String)member.getValue());
                    break;
                }
                case "properties": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setProperties(map);
                    break;
                }
                case "collation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCollation((String)member.getValue());
                    break;
                }
                case "charset": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCharset((String)member.getValue());
                    break;
                }
                case "serverRsaPublicKeyPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setServerRsaPublicKeyPath((String)member.getValue());
                    break;
                }
                case "serverRsaPublicKeyValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setServerRsaPublicKeyValue(Buffer.fromJson((String)((String)member.getValue())));
                }
            }
        }
    }

    static void toJson(MySQLAuthOptions obj, JsonObject json) {
        MySQLAuthOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(MySQLAuthOptions obj, Map<String, Object> json) {
        if (obj.getUser() != null) {
            json.put("user", obj.getUser());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getDatabase() != null) {
            json.put("database", obj.getDatabase());
        }
        if (obj.getProperties() != null) {
            JsonObject map = new JsonObject();
            obj.getProperties().forEach((key, value) -> map.put(key, value));
            json.put("properties", map);
        }
        if (obj.getCollation() != null) {
            json.put("collation", obj.getCollation());
        }
        if (obj.getCharset() != null) {
            json.put("charset", obj.getCharset());
        }
        if (obj.getServerRsaPublicKeyPath() != null) {
            json.put("serverRsaPublicKeyPath", obj.getServerRsaPublicKeyPath());
        }
        if (obj.getServerRsaPublicKeyValue() != null) {
            json.put("serverRsaPublicKeyValue", obj.getServerRsaPublicKeyValue().toJson());
        }
    }
}

