/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.vertx.core.Completable;
import io.vertx.mysqlclient.impl.MySQLSocketConnection;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLDecoder;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.sqlclient.ClosedConnectionException;
import io.vertx.sqlclient.internal.command.CommandBase;
import java.util.ArrayDeque;
import java.util.Iterator;

public class MySQLCodec
extends CombinedChannelDuplexHandler<MySQLDecoder, MySQLEncoder> {
    private final ArrayDeque<CommandCodec<?, ?>> inflight = new ArrayDeque();
    private ChannelHandlerContext chctx;
    private Throwable failure;

    public MySQLCodec(MySQLSocketConnection mySQLSocketConnection) {
        MySQLEncoder encoder = new MySQLEncoder(this, mySQLSocketConnection);
        MySQLDecoder decoder = new MySQLDecoder(this);
        this.init((ChannelInboundHandler)decoder, (ChannelOutboundHandler)encoder);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.chctx = ctx;
        super.handlerAdded(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.clearInflightCommands((Throwable)ClosedConnectionException.INSTANCE);
        super.channelInactive(ctx);
    }

    public boolean add(CommandCodec<?, ?> codec) {
        if (this.failure == null) {
            this.inflight.add(codec);
            return true;
        }
        this.fail(codec, this.failure);
        return false;
    }

    public CommandCodec<?, ?> poll() {
        return this.inflight.poll();
    }

    public CommandCodec<?, ?> peek() {
        return this.inflight.peek();
    }

    private void clearInflightCommands(Throwable cause) {
        Iterator<CommandCodec<?, ?>> it = this.inflight.iterator();
        while (it.hasNext()) {
            CommandCodec<?, ?> codec = it.next();
            it.remove();
            this.fail(codec, cause);
        }
    }

    private void fail(CommandCodec<?, ?> codec, Throwable cause) {
        if (this.failure == null) {
            this.failure = cause;
            Completable handler = ((CommandBase)codec.cmd).handler;
            if (handler != null) {
                handler.complete(null, cause);
            }
        }
    }

    void checkFireAndForgetCommands() {
        CommandCodec<?, ?> commandCodec;
        while ((commandCodec = this.inflight.peek()) != null && commandCodec.expectNoResponsePacket()) {
            commandCodec.decodePayload(null, 0);
        }
    }
}

