/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.openapi.contract.Location;
import java.util.Arrays;
import java.util.function.Predicate;

@VertxGen
public enum Style {
    MATRIX("matrix"),
    LABEL("label"),
    FORM("form"),
    SIMPLE("simple"),
    SPACE_DELIMITED("spaceDelimited"),
    PIPE_DELIMITED("pipeDelimited"),
    DEEP_OBJECT("deepObject");

    private final String openAPIValue;

    private Style(String openAPIValue) {
        this.openAPIValue = openAPIValue;
    }

    public static Style parse(String style) {
        Predicate eq = Predicate.isEqual(style);
        return style == null ? null : (Style)Arrays.stream(Style.values()).filter(l -> eq.test(l.toString())).findFirst().orElse(null);
    }

    public static Style defaultByLocation(Location in) {
        switch (in) {
            case COOKIE: 
            case QUERY: {
                return FORM;
            }
            case PATH: 
            case HEADER: {
                return SIMPLE;
            }
        }
        return null;
    }

    public String toString() {
        return this.openAPIValue;
    }
}

