/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.JsonSchema;
import io.vertx.openapi.contract.SecurityRequirement;
import io.vertx.openapi.impl.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SecurityRequirementImpl
implements SecurityRequirement {
    private final JsonObject securityRequirementModel;
    private final Set<String> names;
    private final Map<String, List<String>> scopes;

    public SecurityRequirementImpl(JsonObject securityRequirementModel) {
        this.securityRequirementModel = securityRequirementModel;
        if (securityRequirementModel.isEmpty()) {
            this.names = Collections.emptySet();
            this.scopes = Collections.emptyMap();
        } else {
            this.names = securityRequirementModel.fieldNames().stream().filter(JsonSchema.EXCLUDE_ANNOTATIONS).collect(Collectors.toUnmodifiableSet());
            this.scopes = Collections.unmodifiableMap(this.names.stream().collect(Collectors.toMap(Function.identity(), name -> SecurityRequirementImpl.extractScopes(securityRequirementModel, name))));
        }
    }

    private static List<String> extractScopes(JsonObject securityRequirementModel, String name) {
        return securityRequirementModel.getJsonArray(name, Utils.EMPTY_JSON_ARRAY).stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public JsonObject getOpenAPIModel() {
        return this.securityRequirementModel;
    }

    @Override
    public Set<String> getNames() {
        return this.names;
    }

    @Override
    public List<String> getScopes(String name) {
        if (this.scopes.containsKey(name)) {
            return this.scopes.get(name);
        }
        throw new IllegalArgumentException("No security requirement with name " + name);
    }

    @Override
    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    @Override
    public int size() {
        return this.names.size();
    }
}

