/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.openapi.contract.OpenAPIContractException;
import io.vertx.openapi.contract.Server;
import java.net.MalformedURLException;
import java.net.URL;

public class ServerImpl
implements Server {
    private static final String KEY_URL = "url";
    private final String basePath;
    private final String url;
    private final JsonObject serverModel;

    public ServerImpl(JsonObject serverModel) {
        this.serverModel = serverModel;
        this.url = serverModel.getString(KEY_URL);
        if (this.url.contains("{")) {
            throw OpenAPIContractException.createUnsupportedFeature("Server Variables");
        }
        try {
            this.basePath = new URL(this.url.endsWith("/") ? this.url.substring(0, this.url.length() - 1) : this.url).getPath();
        }
        catch (MalformedURLException e) {
            throw OpenAPIContractException.createInvalidContract("The specified URL is malformed: " + this.url, e);
        }
    }

    @Override
    public JsonObject getOpenAPIModel() {
        return this.serverModel;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }
}

