/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.transformer;

import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.common.dsl.SchemaType;
import io.vertx.openapi.contract.Parameter;
import io.vertx.openapi.impl.Utils;
import io.vertx.openapi.validation.ValidatorException;

public abstract class ParameterTransformer {
    public Object transform(Parameter parameter, String rawValue) {
        try {
            switch (parameter.getSchemaType()) {
                case OBJECT: {
                    return this.transformObject(parameter, rawValue);
                }
                case ARRAY: {
                    return this.transformArray(parameter, rawValue);
                }
            }
            return this.transformPrimitive(parameter, rawValue);
        }
        catch (DecodeException e) {
            throw ValidatorException.createCantDecodeValue(parameter);
        }
    }

    public Object transformPrimitive(Parameter parameter, String rawValue) {
        boolean isString = SchemaType.STRING.equals((Object)parameter.getSchemaType());
        if (isString && rawValue.matches("\\w+")) {
            return rawValue;
        }
        try {
            return Json.decodeValue((String)rawValue);
        }
        catch (DecodeException de) {
            if (rawValue.isEmpty()) {
                return rawValue;
            }
            if ('\"' == rawValue.charAt(0)) {
                throw de;
            }
            return this.transformPrimitive(parameter, "\"" + rawValue + "\"");
        }
    }

    protected abstract String[] getArrayValues(Parameter var1, String var2);

    public Object transformArray(Parameter parameter, String rawValue) {
        if (rawValue.isEmpty()) {
            return Utils.EMPTY_JSON_ARRAY;
        }
        JsonArray array = new JsonArray();
        for (String value : this.getArrayValues(parameter, rawValue)) {
            array.add(this.transformPrimitive(parameter, value));
        }
        return array;
    }

    protected abstract String[] getObjectKeysAndValues(Parameter var1, String var2);

    public Object transformObject(Parameter parameter, String rawValue) {
        if (rawValue.isEmpty()) {
            return Utils.EMPTY_JSON_OBJECT;
        }
        String[] keysAndValues = this.getObjectKeysAndValues(parameter, rawValue);
        if (keysAndValues.length % 2 != 0) {
            throw ValidatorException.createInvalidValueFormat(parameter);
        }
        JsonObject object = new JsonObject();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            object.put(keysAndValues[i], this.transformPrimitive(parameter, keysAndValues[i + 1]));
        }
        return object;
    }
}

