/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.ConnectOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.SslMode;
import io.vertx.pgclient.impl.PgConnectionImpl;
import io.vertx.pgclient.impl.PgSocketConnection;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import io.vertx.sqlclient.internal.Connection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;

public class PgConnectionFactory
extends ConnectionFactoryBase<PgConnectOptions> {
    public PgConnectionFactory(VertxInternal context) {
        super(context);
    }

    private void checkSslMode(PgConnectOptions options) {
        switch (options.getSslMode()) {
            case VERIFY_FULL: {
                String hostnameVerificationAlgorithm = options.getSslOptions().getHostnameVerificationAlgorithm();
                if (hostnameVerificationAlgorithm == null || hostnameVerificationAlgorithm.isEmpty()) {
                    throw new IllegalArgumentException("Host verification algorithm must be specified under verify-full sslmode");
                }
            }
            case VERIFY_CA: {
                TrustOptions trustOptions = options.getSslOptions().getTrustOptions();
                if (trustOptions != null) break;
                throw new IllegalArgumentException("Trust options must be specified under verify-full or verify-ca sslmode");
            }
        }
    }

    protected Future<Connection> doConnectInternal(PgConnectOptions options, ContextInternal context) {
        try {
            this.checkSslMode(options);
        }
        catch (Exception e) {
            return context.failedFuture((Throwable)e);
        }
        SocketAddress server = options.getSocketAddress();
        return this.connect(server, context, true, options);
    }

    public Future<Void> cancelRequest(PgConnectOptions options, int processId, int secretKey) {
        return this.connect(options.getSocketAddress(), this.vertx.createEventLoopContext(), false, options).compose(conn -> {
            PgSocketConnection socket = (PgSocketConnection)((Object)conn);
            return socket.sendCancelRequestMessage(processId, secretKey);
        });
    }

    private Future<Connection> connect(SocketAddress server, ContextInternal context, boolean sendStartupMessage, PgConnectOptions options) {
        Future connFuture;
        SslMode sslMode = options.isUsingDomainSocket() ? SslMode.DISABLE : options.getSslMode();
        ConnectOptions connectOptions = new ConnectOptions().setRemoteAddress(server);
        switch (sslMode) {
            case DISABLE: {
                connFuture = this.connect(connectOptions, context, false, sendStartupMessage, options);
                break;
            }
            case ALLOW: {
                connFuture = this.connect(connectOptions, context, false, sendStartupMessage, options).recover(err -> this.connect(connectOptions, context, true, sendStartupMessage, options));
                break;
            }
            case PREFER: {
                connFuture = this.connect(connectOptions, context, true, sendStartupMessage, options).recover(err -> this.connect(connectOptions, context, false, sendStartupMessage, options));
                break;
            }
            case VERIFY_FULL: 
            case VERIFY_CA: 
            case REQUIRE: {
                connFuture = this.connect(connectOptions, context, true, sendStartupMessage, options);
                break;
            }
            default: {
                return context.failedFuture((Throwable)new IllegalArgumentException("Unsupported SSL mode"));
            }
        }
        return connFuture;
    }

    private Future<Connection> connect(ConnectOptions connectOptions, ContextInternal context, boolean ssl, boolean sendStartupMessage, PgConnectOptions options) {
        Future<Connection> res = this.doConnect(connectOptions, context, ssl, options);
        if (sendStartupMessage) {
            return res.flatMap(conn -> {
                PgSocketConnection socket = (PgSocketConnection)((Object)conn);
                socket.init();
                String username = options.getUser();
                String password = options.getPassword();
                String database = options.getDatabase();
                Map<String, String> properties = options.getProperties() != null ? Collections.unmodifiableMap(options.getProperties()) : null;
                return socket.sendStartupMessage(username, password, database, properties);
            });
        }
        return res;
    }

    private Future<Connection> doConnect(ConnectOptions connectOptions, ContextInternal context, boolean ssl, PgConnectOptions options) {
        Future soFut;
        try {
            soFut = this.client.connect(connectOptions);
        }
        catch (Exception e) {
            return context.failedFuture((Throwable)e);
        }
        Future connFut = soFut.map(so -> this.newSocketConnection(context, (NetSocketInternal)so, options));
        if (ssl && !connectOptions.getRemoteAddress().isDomainSocket()) {
            connFut = connFut.flatMap(conn -> Future.future(p -> {
                PgSocketConnection socket = (PgSocketConnection)((Object)conn);
                ClientSSLOptions o = options.getSslOptions().copy();
                if (o.getHostnameVerificationAlgorithm() == null) {
                    o.setHostnameVerificationAlgorithm("");
                }
                socket.upgradeToSSLConnection(o, (Handler<AsyncResult<Void>>)((Handler)ar2 -> {
                    if (ar2.succeeded()) {
                        p.complete(conn);
                    } else {
                        p.fail(ar2.cause());
                    }
                }));
            }));
        }
        return connFut;
    }

    public Future<SqlConnection> connect(Context context, PgConnectOptions options) {
        ContextInternal contextInternal = (ContextInternal)context;
        if (options.isUsingDomainSocket() && !this.vertx.isNativeTransportEnabled()) {
            return contextInternal.failedFuture((Throwable)new IllegalArgumentException("The Vertx instance must use a native transport in order to connect to connect through domain sockets"));
        }
        PromiseInternal promise = contextInternal.promise();
        this.connect(PgConnectionFactory.asEventLoopContext((ContextInternal)contextInternal), options).map(conn -> {
            PgConnectionImpl pgConn = new PgConnectionImpl(this, contextInternal, (Connection)conn);
            conn.init((Connection.Holder)pgConn);
            return pgConn;
        }).onComplete((Completable)promise);
        return promise.future();
    }

    private PgSocketConnection newSocketConnection(ContextInternal context, NetSocketInternal socket, PgConnectOptions options) {
        boolean cachePreparedStatements = options.getCachePreparedStatements();
        int preparedStatementCacheMaxSize = options.getPreparedStatementCacheMaxSize();
        Predicate preparedStatementCacheSqlFilter = options.getPreparedStatementCacheSqlFilter();
        int pipeliningLimit = options.getPipeliningLimit();
        boolean useLayer7Proxy = options.getUseLayer7Proxy();
        VertxMetrics vertxMetrics = this.vertx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(options.getSocketAddress(), "sql", options.getMetricsName()) : null;
        PgSocketConnection conn = new PgSocketConnection(socket, metrics, options, cachePreparedStatements, preparedStatementCacheMaxSize, preparedStatementCacheSqlFilter, pipeliningLimit, useLayer7Proxy, context);
        return conn;
    }
}

