/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.vertx.pgclient.impl.codec.DataType;
import io.vertx.pgclient.impl.codec.Describe;
import io.vertx.pgclient.impl.codec.ErrorResponse;
import io.vertx.pgclient.impl.codec.PgColumnDesc;
import io.vertx.pgclient.impl.codec.PgCommandCodec;
import io.vertx.pgclient.impl.codec.PgEncoder;
import io.vertx.pgclient.impl.codec.PgParamDesc;
import io.vertx.pgclient.impl.codec.PgPreparedStatement;
import io.vertx.pgclient.impl.codec.PgRowDesc;
import io.vertx.sqlclient.internal.PreparedStatement;
import io.vertx.sqlclient.internal.command.PrepareStatementCommand;
import java.util.List;

class PrepareStatementCommandCodec
extends PgCommandCodec<PreparedStatement, PrepareStatementCommand> {
    private static final byte[] EMPTY_STRING = new byte[]{0};
    private PgParamDesc parameterDesc;
    private PgRowDesc rowDesc;
    private byte[] statement;

    PrepareStatementCommandCodec(PrepareStatementCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(PgEncoder encoder) {
        this.statement = ((PrepareStatementCommand)this.cmd).isManaged() ? encoder.nextStatementName() : EMPTY_STRING;
        List parameterTypes = ((PrepareStatementCommand)this.cmd).parameterTypes();
        DataType[] parameterTypes2 = parameterTypes != null ? this.build(parameterTypes) : null;
        encoder.writeParse(((PrepareStatementCommand)this.cmd).sql(), this.statement, parameterTypes2);
        encoder.writeDescribe(new Describe(this.statement, null));
        encoder.writeSync();
    }

    private DataType[] build(List<Class<?>> parameterTypes) {
        int len = parameterTypes.size();
        DataType[] dataType = new DataType[len];
        for (int i = 0; i < len; ++i) {
            DataType type = DataType.lookup(parameterTypes.get(i));
            if (type == null) {
                return null;
            }
            dataType[i] = type;
        }
        return dataType;
    }

    @Override
    public void handleParseComplete() {
    }

    @Override
    public void handleParameterDescription(PgParamDesc paramDesc) {
        this.parameterDesc = paramDesc;
    }

    @Override
    public void handleRowDescription(PgColumnDesc[] rowDesc) {
        this.rowDesc = PgRowDesc.createBinary(rowDesc);
    }

    @Override
    public void handleNoData() {
    }

    @Override
    public void handleErrorResponse(ErrorResponse errorResponse) {
        this.failure = errorResponse.toException();
    }

    @Override
    public void handleReadyForQuery() {
        this.result = new PgPreparedStatement(((PrepareStatementCommand)this.cmd).sql(), this.statement, this.parameterDesc, this.rowDesc, ((PrepareStatementCommand)this.cmd).isManaged());
        super.handleReadyForQuery();
    }
}

