/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.pgclient.impl.RowImpl;
import io.vertx.pgclient.impl.codec.DataFormat;
import io.vertx.pgclient.impl.codec.DataTypeCodec;
import io.vertx.pgclient.impl.codec.PgColumnDesc;
import io.vertx.pgclient.impl.codec.PgRowDesc;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.impl.RowDecoder;
import io.vertx.sqlclient.internal.RowInternal;
import java.util.stream.Collector;

class RowResultDecoder<C, R>
extends RowDecoder<C, R> {
    final PgRowDesc desc;

    RowResultDecoder(Collector<Row, C, R> collector, PgRowDesc desc) {
        super(collector);
        this.desc = desc;
    }

    protected RowInternal row() {
        return new RowImpl(this.desc);
    }

    protected boolean decodeRow(int len, ByteBuf in, Row row) {
        for (int c = 0; c < len; ++c) {
            int length = in.readInt();
            Object decoded = null;
            if (length != -1) {
                PgColumnDesc columnDesc = this.desc.columns[c];
                decoded = columnDesc.dataFormat == DataFormat.BINARY ? DataTypeCodec.decodeBinary(columnDesc.dataType, in.readerIndex(), length, in) : DataTypeCodec.decodeText(columnDesc.dataType, in.readerIndex(), length, in);
                in.skipBytes(length);
            }
            row.addValue(decoded);
        }
        return true;
    }
}

