/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.vertx.core.VertxException;
import io.vertx.pgclient.impl.codec.DataType;
import io.vertx.pgclient.impl.codec.ParamExtractor;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.ErrorMessageFactory;
import io.vertx.sqlclient.internal.ArrayTuple;
import io.vertx.sqlclient.internal.ParamDesc;
import io.vertx.sqlclient.internal.TupleInternal;
import java.util.Arrays;
import java.util.function.Function;

class PgParamDesc
extends ParamDesc {
    private final DataType[] paramDataTypes;

    PgParamDesc(DataType[] paramDataTypes) {
        this.paramDataTypes = paramDataTypes;
    }

    DataType[] paramDataTypes() {
        return this.paramDataTypes;
    }

    public TupleInternal prepare(TupleInternal values) {
        int numberOfParams = values.size();
        if (numberOfParams > 65535) {
            throw new VertxException("The number of parameters (" + numberOfParams + ") exceeds the maximum of 65535. Use arrays or split the query.", true);
        }
        int paramDescLength = this.paramDataTypes.length;
        if (numberOfParams != paramDescLength) {
            throw new VertxException(ErrorMessageFactory.buildWhenArgumentsLengthNotMatched((int)paramDescLength, (int)numberOfParams), true);
        }
        TupleInternal prepared = values;
        for (int i = 0; i < paramDescLength; ++i) {
            Function<Object, Object> preparator;
            Object val;
            DataType paramDataType = this.paramDataTypes[i];
            ParamExtractor<?> extractor = paramDataType.paramExtractor;
            try {
                val = extractor.get(values, i);
            }
            catch (Exception e) {
                throw new VertxException(ErrorMessageFactory.buildWhenArgumentsTypeNotMatched(paramDataType.decodingType, (int)i, (Object)values.getValue(i)), true);
            }
            if (val != null && (preparator = paramDataType.preEncoder) != null) {
                if (prepared == values) {
                    prepared = new ArrayTuple((Tuple)prepared);
                }
                if (paramDataType.array) {
                    Object[] array = (Object[])val;
                    Object[] tmp = new Object[array.length];
                    for (int j = 0; j < array.length; ++j) {
                        tmp[j] = preparator.apply(array[j]);
                    }
                    val = tmp;
                } else {
                    val = preparator.apply(val);
                }
            }
            prepared.setValue(i, val);
        }
        return prepared;
    }

    public String toString() {
        return "PgParamDesc{paramDataTypes=" + Arrays.toString((Object[])this.paramDataTypes) + "}";
    }
}

