/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonMessageHandler;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.impl.ProtonDeliveryImpl;
import io.vertx.proton.impl.ProtonLinkImpl;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.LinkError;
import org.apache.qpid.proton.amqp.transport.Source;
import org.apache.qpid.proton.codec.CompositeReadableBuffer;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;

public class ProtonReceiverImpl
extends ProtonLinkImpl<ProtonReceiver>
implements ProtonReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonReceiverImpl.class);
    private ProtonMessageHandler handler;
    private int prefetch = 1000;
    private Handler<AsyncResult<Void>> drainCompleteHandler;
    private Long drainTimeoutTaskId = null;
    private Session session;
    private int maxFrameSize;
    private long sessionIncomingCapacity;
    private long windowFullThreshhold;
    private Handler<ProtonReceiver> maxMessageSizeExceededHandler;
    private boolean maxMessageSizeExceeded;
    private boolean autoAccept = true;
    private CompositeReadableBuffer splitContent;

    public ProtonReceiverImpl(Receiver receiver) {
        super((Link)receiver);
        this.session = receiver.getSession();
        this.sessionIncomingCapacity = this.session.getIncomingCapacity();
        this.maxFrameSize = this.session.getConnection().getTransport().getMaxFrameSize();
        this.windowFullThreshhold = this.sessionIncomingCapacity - (long)this.maxFrameSize;
    }

    @Override
    protected ProtonReceiverImpl self() {
        return this;
    }

    private Receiver getReceiver() {
        return (Receiver)this.link;
    }

    public int recv(byte[] bytes, int offset, int size) {
        return this.getReceiver().recv(bytes, offset, size);
    }

    @Override
    public String getRemoteAddress() {
        Source remoteSource = this.getRemoteSource();
        return remoteSource == null ? null : remoteSource.getAddress();
    }

    @Override
    public ProtonReceiver drain(long timeout, Handler<AsyncResult<Void>> completionHandler) {
        if (this.prefetch > 0) {
            throw new IllegalStateException("Manual credit management not available while prefetch is non-zero");
        }
        if (completionHandler == null) {
            throw new IllegalArgumentException("A completion handler must be provided");
        }
        if (this.drainCompleteHandler != null) {
            throw new IllegalStateException("A previous drain operation has not yet completed");
        }
        if (this.getCredit() - this.getQueued() <= 0) {
            if (this.getQueued() == 0) {
                completionHandler.handle((Object)Future.succeededFuture());
            } else {
                this.setDrainHandlerAndTimeoutTask(timeout, completionHandler);
            }
        } else {
            this.setDrainHandlerAndTimeoutTask(timeout, completionHandler);
            this.getReceiver().drain(0);
            this.flushConnection();
        }
        return this;
    }

    private void setDrainHandlerAndTimeoutTask(long delay, Handler<AsyncResult<Void>> completionHandler) {
        this.drainCompleteHandler = completionHandler;
        if (delay > 0L) {
            Vertx vertx = Vertx.currentContext().owner();
            this.drainTimeoutTaskId = vertx.setTimer(delay, x -> {
                this.drainTimeoutTaskId = null;
                this.drainCompleteHandler = null;
                completionHandler.handle((Object)Future.failedFuture((String)"Drain attempt timed out"));
            });
        }
    }

    @Override
    public ProtonReceiver flow(int credits) throws IllegalStateException {
        this.flow(credits, true);
        return this;
    }

    private void flow(int credits, boolean checkPrefetch) throws IllegalStateException {
        if (checkPrefetch && this.prefetch > 0) {
            throw new IllegalStateException("Manual credit management not available while prefetch is non-zero");
        }
        if (this.drainCompleteHandler != null) {
            throw new IllegalStateException("A previous drain operation has not yet completed");
        }
        this.getReceiver().flow(credits);
        this.flushConnection();
    }

    public boolean draining() {
        return this.getReceiver().draining();
    }

    public ProtonReceiver setDrain(boolean drain) {
        this.getReceiver().setDrain(drain);
        return this;
    }

    @Override
    public ProtonReceiver handler(ProtonMessageHandler handler) {
        this.handler = handler;
        this.onDelivery();
        return this;
    }

    @Override
    public ProtonReceiver maxMessageSizeExceededHandler(Handler<ProtonReceiver> handler) {
        this.maxMessageSizeExceededHandler = handler;
        return this;
    }

    private void flushConnection() {
        this.getSession().getConnectionImpl().flush();
    }

    public void onDelivery() {
        if (this.handler == null) {
            return;
        }
        Receiver receiver = this.getReceiver();
        Delivery delivery = receiver.current();
        if (delivery != null) {
            if (delivery.isAborted()) {
                this.handleAborted(receiver, delivery);
                return;
            }
            UnsignedLong maxMessageSize = this.getMaxMessageSize();
            if (maxMessageSize != null && this.checkMaxMessageSize(maxMessageSize, delivery, receiver)) {
                return;
            }
            if (delivery.isPartial()) {
                this.handlePartial(receiver, delivery);
                return;
            }
            ReadableBuffer data = receiver.recv();
            if (this.splitContent != null) {
                data = this.completePartial(data);
            }
            receiver.advance();
            MessageImpl msg = (MessageImpl)Proton.message();
            ProtonDeliveryImpl delImpl = new ProtonDeliveryImpl(delivery);
            try {
                msg.decode(data);
            }
            catch (Throwable t) {
                LOG.debug((Object)"Unable to decode message, undeliverable", t);
                this.handleDecodeFailure(receiver, delImpl);
                return;
            }
            this.handler.handle(delImpl, (Message)msg);
            if (this.autoAccept && delivery.getLocalState() == null) {
                ProtonHelper.accepted(delImpl, true);
            }
            if (this.prefetch > 0) {
                this.flow(1, false);
            } else {
                this.processForDrainCompletion();
            }
        }
    }

    private boolean checkMaxMessageSize(UnsignedLong maxMessageSize, Delivery delivery, Receiver receiver) {
        long max;
        if (this.maxMessageSizeExceeded) {
            receiver.recv();
            return true;
        }
        long payloadLength = delivery.available();
        if (this.splitContent != null) {
            payloadLength += (long)this.splitContent.remaining();
        }
        if ((max = maxMessageSize.longValue()) > 0L && payloadLength > max) {
            this.maxMessageSizeExceeded = true;
            this.splitContent = null;
            receiver.recv();
            this.handleMaxMessageSizeExceeded(maxMessageSize, receiver);
            return true;
        }
        return false;
    }

    private void handleMaxMessageSizeExceeded(UnsignedLong maxMessageSize, Receiver receiver) {
        try {
            LOG.debug((Object)("delivery received exceeding max-message-size of " + String.valueOf(maxMessageSize) + " bytes"));
            if (this.maxMessageSizeExceededHandler != null) {
                this.maxMessageSizeExceededHandler.handle((Object)this);
            }
        }
        finally {
            if (!receiver.detached() && this.isOpen()) {
                LOG.debug((Object)("detaching link with error condition " + String.valueOf(LinkError.MESSAGE_SIZE_EXCEEDED)));
                this.setCondition(new ErrorCondition(LinkError.MESSAGE_SIZE_EXCEEDED, "exceeded max-message-size of " + String.valueOf(maxMessageSize) + " bytes "));
                this.detach();
            }
        }
    }

    private void handleDecodeFailure(Receiver receiver, ProtonDeliveryImpl delImpl) {
        Modified modified = new Modified();
        modified.setDeliveryFailed(Boolean.valueOf(true));
        modified.setUndeliverableHere(Boolean.valueOf(true));
        delImpl.disposition((DeliveryState)modified, true);
        if (!receiver.getDrain()) {
            this.flow(1, false);
        } else {
            this.processForDrainCompletion();
        }
    }

    private void handleAborted(Receiver receiver, Delivery delivery) {
        this.splitContent = null;
        receiver.advance();
        delivery.settle();
        if (!receiver.getDrain()) {
            this.flow(1, false);
        } else {
            this.processForDrainCompletion();
        }
    }

    private void handlePartial(Receiver receiver, Delivery delivery) {
        if (this.sessionIncomingCapacity > 0L && this.maxFrameSize > 0 && (long)this.session.getIncomingBytes() >= this.windowFullThreshhold && delivery.available() > 0) {
            ReadableBuffer buff = receiver.recv();
            if (this.splitContent == null && buff instanceof CompositeReadableBuffer) {
                this.splitContent = (CompositeReadableBuffer)buff;
            } else {
                int remaining = buff.remaining();
                if (remaining > 0) {
                    if (this.splitContent == null) {
                        this.splitContent = new CompositeReadableBuffer();
                    }
                    byte[] chunk = new byte[remaining];
                    buff.get(chunk);
                    this.splitContent.append(chunk);
                }
            }
        }
    }

    private ReadableBuffer completePartial(ReadableBuffer finalContent) {
        int pending = finalContent.remaining();
        if (pending > 0) {
            byte[] chunk = new byte[pending];
            finalContent.get(chunk);
            this.splitContent.append(chunk);
        }
        CompositeReadableBuffer data = this.splitContent;
        this.splitContent = null;
        return data;
    }

    @Override
    public boolean isAutoAccept() {
        return this.autoAccept;
    }

    @Override
    public ProtonReceiver setAutoAccept(boolean autoAccept) {
        this.autoAccept = autoAccept;
        return this;
    }

    @Override
    public ProtonReceiver setPrefetch(int messages) {
        if (messages < 0) {
            throw new IllegalArgumentException("Value must not be negative");
        }
        this.prefetch = messages;
        return this;
    }

    @Override
    public int getPrefetch() {
        return this.prefetch;
    }

    @Override
    public ProtonReceiver open() {
        super.open();
        if (this.prefetch > 0) {
            this.flow(this.prefetch, false);
        }
        return this;
    }

    @Override
    void handleLinkFlow() {
        this.processForDrainCompletion();
    }

    private void processForDrainCompletion() {
        Handler<AsyncResult<Void>> h = this.drainCompleteHandler;
        if (h != null && this.getCredit() <= 0 && this.getQueued() <= 0) {
            boolean timeoutTaskCleared = false;
            Long timerId = this.drainTimeoutTaskId;
            if (timerId != null) {
                Vertx vertx = Vertx.currentContext().owner();
                timeoutTaskCleared = vertx.cancelTimer(timerId.longValue());
            } else {
                timeoutTaskCleared = true;
            }
            this.drainTimeoutTaskId = null;
            this.drainCompleteHandler = null;
            if (timeoutTaskCleared) {
                h.handle((Object)Future.succeededFuture());
            }
        }
    }
}

