/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.netty.buffer.ByteBuf;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonTransportOptions;
import io.vertx.proton.impl.ProtonConnectionImpl;
import io.vertx.proton.impl.ProtonDeliveryImpl;
import io.vertx.proton.impl.ProtonLinkImpl;
import io.vertx.proton.impl.ProtonReceiverImpl;
import io.vertx.proton.impl.ProtonSessionImpl;
import io.vertx.proton.sasl.ProtonSaslAuthenticator;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;

class ProtonTransport
extends BaseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonTransport.class);
    private static final int DEFAULT_MAX_FRAME_SIZE = 32768;
    private final Connection connection;
    private final Vertx vertx;
    private final NetClient netClient;
    private final NetSocket socket;
    private final Transport transport = Proton.transport();
    private final Collector collector = Proton.collector();
    private ProtonSaslAuthenticator authenticator;
    private volatile Long idleTimeoutCheckTimerId;
    private boolean failed;

    ProtonTransport(Connection connection, Vertx vertx, NetClient netClient, NetSocket socket, ProtonSaslAuthenticator authenticator, ProtonTransportOptions options) {
        this.connection = connection;
        this.vertx = vertx;
        this.netClient = netClient;
        this.socket = socket;
        int maxFrameSize = options.getMaxFrameSize() == 0 ? 32768 : options.getMaxFrameSize();
        this.transport.setMaxFrameSize(maxFrameSize);
        this.transport.setOutboundFrameSizeLimit(maxFrameSize);
        this.transport.setEmitFlowEventOnSend(false);
        this.transport.setIdleTimeout(2 * options.getHeartbeat());
        ((TransportInternal)this.transport).setUseReadOnlyOutputBuffer(false);
        if (authenticator != null) {
            authenticator.init(this.socket, (ProtonConnection)this.connection.getContext(), this.transport);
        }
        this.authenticator = authenticator;
        this.transport.bind(connection);
        connection.collect(this.collector);
        socket.endHandler(this::handleSocketEnd);
        socket.handler(this::handleSocketBuffer);
    }

    private void handleSocketEnd(Void arg) {
        this.cancelIdleTimeoutCheck();
        this.transport.unbind();
        this.transport.close();
        if (this.netClient != null) {
            this.netClient.close();
        } else {
            this.socket.close();
        }
        ((ProtonConnectionImpl)this.connection.getContext()).fireDisconnect();
    }

    private void handleSocketBuffer(Buffer buff) {
        this.pumpInbound(buff);
        if (!this.failed) {
            this.processSaslAuthentication();
        }
        Event protonEvent = null;
        while ((protonEvent = this.collector.peek()) != null) {
            ProtonConnectionImpl conn = (ProtonConnectionImpl)protonEvent.getConnection().getContext();
            Event.Type eventType = protonEvent.getType();
            if (LOG.isTraceEnabled() && !eventType.equals((Object)Event.Type.TRANSPORT)) {
                LOG.trace((Object)("New Proton Event: " + String.valueOf(eventType)));
            }
            switch (eventType) {
                case CONNECTION_REMOTE_OPEN: {
                    conn.fireRemoteOpen();
                    this.initiateIdleTimeoutChecks();
                    break;
                }
                case CONNECTION_REMOTE_CLOSE: {
                    conn.fireRemoteClose();
                    break;
                }
                case SESSION_REMOTE_OPEN: {
                    ProtonSessionImpl session = (ProtonSessionImpl)protonEvent.getSession().getContext();
                    if (session == null) {
                        conn.fireRemoteSessionOpen(protonEvent.getSession());
                        break;
                    }
                    session.fireRemoteOpen();
                    break;
                }
                case SESSION_REMOTE_CLOSE: {
                    ProtonSessionImpl session = (ProtonSessionImpl)protonEvent.getSession().getContext();
                    session.fireRemoteClose();
                    break;
                }
                case LINK_REMOTE_OPEN: {
                    ProtonLinkImpl link = (ProtonLinkImpl)protonEvent.getLink().getContext();
                    if (link == null) {
                        conn.fireRemoteLinkOpen(protonEvent.getLink());
                        break;
                    }
                    link.fireRemoteOpen();
                    break;
                }
                case LINK_REMOTE_DETACH: {
                    ProtonLinkImpl link = (ProtonLinkImpl)protonEvent.getLink().getContext();
                    link.fireRemoteDetach();
                    break;
                }
                case LINK_REMOTE_CLOSE: {
                    ProtonLinkImpl link = (ProtonLinkImpl)protonEvent.getLink().getContext();
                    link.fireRemoteClose();
                    break;
                }
                case LINK_FLOW: {
                    ProtonLinkImpl link = (ProtonLinkImpl)protonEvent.getLink().getContext();
                    link.handleLinkFlow();
                    break;
                }
                case DELIVERY: {
                    ProtonDeliveryImpl delivery = (ProtonDeliveryImpl)protonEvent.getDelivery().getContext();
                    if (delivery != null) {
                        delivery.fireUpdate();
                        break;
                    }
                    ProtonReceiverImpl receiver = (ProtonReceiverImpl)protonEvent.getLink().getContext();
                    receiver.onDelivery();
                    break;
                }
                case TRANSPORT_ERROR: {
                    this.failed = true;
                    break;
                }
            }
            this.collector.pop();
        }
        this.flush();
        if (this.failed) {
            this.disconnect();
        }
    }

    private void processSaslAuthentication() {
        if (this.authenticator == null) {
            return;
        }
        this.socket.pause();
        this.authenticator.process((Handler<Boolean>)((Handler)complete -> {
            if (complete.booleanValue()) {
                this.authenticator = null;
            }
            this.socket.resume();
        }));
    }

    private void initiateIdleTimeoutChecks() {
        long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        long deadline = this.transport.tick(now);
        if (deadline != 0L) {
            long delay = Math.max(deadline - now, 1L);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("IdleTimeoutCheck being initiated, initial delay: " + delay));
            }
            this.idleTimeoutCheckTimerId = this.vertx.setTimer(delay, (Handler)new IdleTimeoutCheck());
        }
    }

    private void cancelIdleTimeoutCheck() {
        Long timerId = this.idleTimeoutCheckTimerId;
        if (timerId != null) {
            this.vertx.cancelTimer(timerId.longValue());
            this.idleTimeoutCheckTimerId = null;
            LOG.trace((Object)"IdleTimeoutCheck cancelled");
        }
    }

    private void pumpInbound(Buffer buffer) {
        if (this.failed) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Skipping processing of data following transport error: " + String.valueOf(buffer)));
            }
            return;
        }
        try {
            ByteBuf data = ((BufferInternal)buffer).getByteBuf();
            do {
                ByteBuffer transportBuffer = this.transport.tail();
                int amount = Math.min(transportBuffer.remaining(), data.readableBytes());
                transportBuffer.limit(transportBuffer.position() + amount);
                data.readBytes(transportBuffer);
                this.transport.process();
            } while (data.isReadable());
        }
        catch (Exception te) {
            this.failed = true;
            LOG.trace((Object)"Exception while processing transport input", (Throwable)te);
        }
    }

    void flush() {
        boolean done = false;
        while (!done) {
            ByteBuffer outputBuffer = this.transport.getOutputBuffer();
            if (outputBuffer != null && outputBuffer.hasRemaining()) {
                NetSocketInternal internal = (NetSocketInternal)this.socket;
                ByteBuf bb = internal.channelHandlerContext().alloc().directBuffer(outputBuffer.remaining());
                bb.writeBytes(outputBuffer);
                internal.writeMessage((Object)bb);
                this.transport.outputConsumed();
                continue;
            }
            done = true;
        }
    }

    public void disconnect() {
        if (this.netClient != null) {
            this.netClient.close();
        } else {
            this.socket.close();
        }
    }

    private final class IdleTimeoutCheck
    implements Handler<Long> {
        private IdleTimeoutCheck() {
        }

        public void handle(Long event) {
            boolean checkScheduled = false;
            if (ProtonTransport.this.connection.getLocalState() == EndpointState.ACTIVE) {
                long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                long deadline = ProtonTransport.this.transport.tick(now);
                try {
                    ProtonTransport.this.flush();
                }
                catch (IllegalStateException ex) {
                    deadline = 0L;
                }
                if (ProtonTransport.this.transport.isClosed()) {
                    LOG.info((Object)"IdleTimeoutCheck closed the transport due to the peer exceeding our requested idle-timeout.");
                    ProtonTransport.this.disconnect();
                } else if (deadline != 0L) {
                    long delay = Math.max(deadline - now, 1L);
                    checkScheduled = true;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("IdleTimeoutCheck rescheduling with delay: " + delay));
                    }
                    ProtonTransport.this.idleTimeoutCheckTimerId = ProtonTransport.this.vertx.setTimer(delay, (Handler)this);
                }
            } else {
                LOG.trace((Object)"IdleTimeoutCheck skipping check, connection is not active.");
            }
            if (!checkScheduled) {
                ProtonTransport.this.idleTimeoutCheckTimerId = null;
                LOG.trace((Object)"IdleTimeoutCheck exiting");
            }
        }
    }
}

