/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.PoolOptions;
import io.vertx.redis.client.ProtocolVersion;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisClusterTransactions;
import io.vertx.redis.client.RedisOptionsConverter;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.RedisTopology;
import io.vertx.redis.client.impl.RedisURI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class RedisOptions {
    public static final String DEFAULT_ENDPOINT = "redis://localhost:6379";
    private RedisClientType type = RedisClientType.STANDALONE;
    private NetClientOptions netClientOptions = new NetClientOptions().setTcpKeepAlive(true).setTcpNoDelay(true);
    private List<String> endpoints;
    private RedisTopology topology = RedisTopology.DISCOVER;
    private PoolOptions poolOptions = new PoolOptions();
    private int maxWaitingHandlers = 2048;
    private int maxNestedArrays = 32;
    private String masterName = "mymaster";
    private RedisRole role = RedisRole.MASTER;
    private RedisReplicas useReplicas = RedisReplicas.NEVER;
    private RedisClusterTransactions clusterTransactions = RedisClusterTransactions.DISABLED;
    private volatile String user;
    private volatile String password;
    private boolean protocolNegotiation = true;
    private ProtocolVersion preferredProtocolVersion;
    private long hashSlotCacheTTL = 1000L;
    private TracingPolicy tracingPolicy;
    private boolean autoFailover;

    public RedisOptions() {
    }

    public RedisOptions(RedisOptions other) {
        this();
        this.type = other.type;
        this.netClientOptions = other.netClientOptions;
        this.endpoints = other.endpoints;
        this.topology = other.topology;
        this.poolOptions = new PoolOptions(other.poolOptions);
        this.maxWaitingHandlers = other.maxWaitingHandlers;
        this.maxNestedArrays = other.maxNestedArrays;
        this.masterName = other.masterName;
        this.role = other.role;
        this.useReplicas = other.useReplicas;
        this.clusterTransactions = other.clusterTransactions;
        this.user = other.user;
        this.password = other.password;
        this.protocolNegotiation = other.protocolNegotiation;
        this.preferredProtocolVersion = other.preferredProtocolVersion;
        this.hashSlotCacheTTL = other.hashSlotCacheTTL;
        this.tracingPolicy = other.tracingPolicy;
        this.autoFailover = other.autoFailover;
    }

    public RedisOptions(JsonObject json) {
        this();
        RedisOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public RedisClientType getType() {
        return this.type;
    }

    public RedisOptions setType(RedisClientType type) {
        this.type = type;
        return this;
    }

    public NetClientOptions getNetClientOptions() {
        return this.netClientOptions;
    }

    public RedisOptions setNetClientOptions(NetClientOptions netClientOptions) {
        this.netClientOptions = netClientOptions;
        return this;
    }

    @GenIgnore
    public String getEndpoint() {
        if (this.endpoints == null || this.endpoints.isEmpty()) {
            return DEFAULT_ENDPOINT;
        }
        return this.endpoints.get(0);
    }

    @Deprecated
    @GenIgnore
    public RedisOptions addEndpoint(String connectionString) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        }
        this.endpoints.add(connectionString);
        return this;
    }

    @Deprecated
    @GenIgnore
    public RedisOptions setEndpoint(String connectionString) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        } else {
            this.endpoints.clear();
        }
        this.endpoints.add(connectionString);
        return this;
    }

    @GenIgnore
    public RedisOptions addConnectionString(String connectionString) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        }
        this.endpoints.add(connectionString);
        return this;
    }

    @GenIgnore
    public RedisOptions setConnectionString(String connectionString) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        } else {
            this.endpoints.clear();
        }
        this.endpoints.add(connectionString);
        return this;
    }

    public RedisTopology getTopology() {
        return this.topology;
    }

    public RedisOptions setTopology(RedisTopology topology) {
        this.topology = topology;
        return this;
    }

    public List<String> getEndpoints() {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
            this.endpoints.add(DEFAULT_ENDPOINT);
        }
        return this.endpoints;
    }

    public RedisOptions setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public int getMaxWaitingHandlers() {
        return this.maxWaitingHandlers;
    }

    public RedisOptions setMaxWaitingHandlers(int maxWaitingHandlers) {
        this.maxWaitingHandlers = maxWaitingHandlers;
        return this;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public RedisOptions setMasterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    public RedisRole getRole() {
        return this.role;
    }

    public RedisOptions setRole(RedisRole role) {
        this.role = role;
        return this;
    }

    public RedisReplicas getUseReplicas() {
        return this.useReplicas;
    }

    public RedisOptions setUseReplicas(RedisReplicas useReplicas) {
        this.useReplicas = useReplicas;
        return this;
    }

    public RedisClusterTransactions getClusterTransactions() {
        return this.clusterTransactions;
    }

    public RedisOptions setClusterTransactions(RedisClusterTransactions clusterTransactions) {
        this.clusterTransactions = clusterTransactions;
        return this;
    }

    public int getMaxNestedArrays() {
        return this.maxNestedArrays;
    }

    public RedisOptions setMaxNestedArrays(int maxNestedArrays) {
        this.maxNestedArrays = maxNestedArrays;
        return this;
    }

    public TracingPolicy getTracingPolicy() {
        return this.tracingPolicy;
    }

    public RedisOptions setTracingPolicy(TracingPolicy tracingPolicy) {
        this.tracingPolicy = tracingPolicy;
        return this;
    }

    @GenIgnore
    public PoolOptions getPoolOptions() {
        return this.poolOptions;
    }

    public int getPoolCleanerInterval() {
        return this.poolOptions.getCleanerInterval();
    }

    public RedisOptions setPoolCleanerInterval(int poolCleanerInterval) {
        this.poolOptions.setCleanerInterval(poolCleanerInterval);
        return this;
    }

    public int getMaxPoolSize() {
        return this.poolOptions.getMaxSize();
    }

    public RedisOptions setMaxPoolSize(int maxPoolSize) {
        this.poolOptions.setMaxSize(maxPoolSize);
        return this;
    }

    public int getMaxPoolWaiting() {
        return this.poolOptions.getMaxWaiting();
    }

    public RedisOptions setMaxPoolWaiting(int maxPoolWaiting) {
        this.poolOptions.setMaxWaiting(maxPoolWaiting);
        return this;
    }

    public int getPoolRecycleTimeout() {
        return this.poolOptions.getRecycleTimeout();
    }

    public RedisOptions setPoolRecycleTimeout(int poolRecycleTimeout) {
        this.poolOptions.setRecycleTimeout(poolRecycleTimeout);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUser() {
        if (this.user == null) {
            RedisOptions redisOptions = this;
            synchronized (redisOptions) {
                if (this.user == null) {
                    RedisURI uri = new RedisURI(this.getEndpoint());
                    this.user = uri.user();
                }
            }
        }
        return this.user;
    }

    public RedisOptions setUser(String user) {
        this.user = user;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPassword() {
        if (this.password == null) {
            RedisOptions redisOptions = this;
            synchronized (redisOptions) {
                if (this.password == null) {
                    RedisURI uri = new RedisURI(this.getEndpoint());
                    this.password = uri.password();
                }
            }
        }
        return this.password;
    }

    public RedisOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean isProtocolNegotiation() {
        return this.protocolNegotiation;
    }

    public RedisOptions setProtocolNegotiation(boolean protocolNegotiation) {
        this.protocolNegotiation = protocolNegotiation;
        return this;
    }

    public ProtocolVersion getPreferredProtocolVersion() {
        return this.preferredProtocolVersion;
    }

    public RedisOptions setPreferredProtocolVersion(ProtocolVersion preferredProtocolVersion) {
        this.preferredProtocolVersion = preferredProtocolVersion;
        return this;
    }

    public String getPoolName() {
        return this.poolOptions.getName();
    }

    public RedisOptions setPoolName(String poolName) {
        this.poolOptions.setName(poolName);
        return this;
    }

    public String getMetricsName() {
        return this.netClientOptions.getMetricsName();
    }

    public RedisOptions setMetricsName(String metricsName) {
        this.netClientOptions.setMetricsName(metricsName);
        return this;
    }

    public long getHashSlotCacheTTL() {
        return this.hashSlotCacheTTL;
    }

    public RedisOptions setHashSlotCacheTTL(long hashSlotCacheTTL) {
        this.hashSlotCacheTTL = hashSlotCacheTTL;
        return this;
    }

    public boolean isAutoFailover() {
        return this.autoFailover;
    }

    public RedisOptions setAutoFailover(boolean autoFailover) {
        this.autoFailover = autoFailover;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RedisOptionsConverter.toJson(this, json);
        return json;
    }
}

