/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.ProtocolVersion;
import io.vertx.redis.client.RedisConnectOptions;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.RedisSentinelConnectOptionsConverter;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class RedisSentinelConnectOptions
extends RedisConnectOptions {
    private RedisRole role;
    private String masterName;
    private boolean autoFailover;

    public RedisSentinelConnectOptions() {
        this.role = RedisRole.MASTER;
        this.masterName = "mymaster";
    }

    public RedisSentinelConnectOptions(RedisOptions options) {
        super(options);
        this.setRole(options.getRole());
        this.setMasterName(options.getMasterName());
        this.setAutoFailover(options.isAutoFailover());
    }

    public RedisSentinelConnectOptions(RedisSentinelConnectOptions other) {
        super(other);
        this.setRole(other.getRole());
        this.setMasterName(other.getMasterName());
        this.setAutoFailover(other.isAutoFailover());
    }

    public RedisSentinelConnectOptions(JsonObject json) {
        super(json);
        RedisSentinelConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public RedisRole getRole() {
        return this.role;
    }

    public RedisSentinelConnectOptions setRole(RedisRole role) {
        this.role = role;
        return this;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public RedisSentinelConnectOptions setMasterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    public boolean isAutoFailover() {
        return this.autoFailover;
    }

    public RedisSentinelConnectOptions setAutoFailover(boolean autoFailover) {
        this.autoFailover = autoFailover;
        return this;
    }

    @Override
    public RedisSentinelConnectOptions setMaxNestedArrays(int maxNestedArrays) {
        return (RedisSentinelConnectOptions)super.setMaxNestedArrays(maxNestedArrays);
    }

    @Override
    public RedisSentinelConnectOptions setProtocolNegotiation(boolean protocolNegotiation) {
        return (RedisSentinelConnectOptions)super.setProtocolNegotiation(protocolNegotiation);
    }

    @Override
    public RedisSentinelConnectOptions setPreferredProtocolVersion(ProtocolVersion preferredProtocolVersion) {
        return (RedisSentinelConnectOptions)super.setPreferredProtocolVersion(preferredProtocolVersion);
    }

    @Override
    public RedisSentinelConnectOptions setUser(String user) {
        return (RedisSentinelConnectOptions)super.setUser(user);
    }

    @Override
    public RedisSentinelConnectOptions setPassword(String password) {
        return (RedisSentinelConnectOptions)super.setPassword(password);
    }

    @Override
    public RedisSentinelConnectOptions setEndpoints(List<String> endpoints) {
        return (RedisSentinelConnectOptions)super.setEndpoints(endpoints);
    }

    @Override
    public RedisSentinelConnectOptions addConnectionString(String connectionString) {
        return (RedisSentinelConnectOptions)super.addConnectionString(connectionString);
    }

    @Override
    public RedisSentinelConnectOptions setConnectionString(String connectionString) {
        return (RedisSentinelConnectOptions)super.setConnectionString(connectionString);
    }

    @Override
    public RedisSentinelConnectOptions setMaxWaitingHandlers(int maxWaitingHandlers) {
        return (RedisSentinelConnectOptions)super.setMaxWaitingHandlers(maxWaitingHandlers);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        RedisSentinelConnectOptionsConverter.toJson(this, json);
        return json;
    }
}

