/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisURI;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;

class Slots {
    private static final Random RANDOM = new Random();
    private final long ts = System.currentTimeMillis();
    private final int size;
    private final Slot[] slots;
    private final String[] endpoints;
    private final String[] masterEndpoints;

    Slots(String connectionString, Response reply) {
        int i;
        this.size = reply.size();
        this.slots = new Slot[this.size];
        RedisURI uri = new RedisURI(connectionString);
        HashSet<CallSite> uniqueEndpoints = new HashSet<CallSite>();
        ArrayList<CallSite> masterEndpoints = new ArrayList<CallSite>();
        for (i = 0; i < reply.size(); ++i) {
            Response s = reply.get(i);
            this.slots[i] = new Slot(s.get(0).toInteger(), s.get(1).toInteger(), s.size() - 2);
            for (int j = 2; j < s.size(); ++j) {
                Response c = s.get(j);
                Response hostField = c.get(0);
                Response portField = c.get(1);
                Object host = hostField == null || "".equals(hostField.toString()) ? uri.socketAddress().host() : (hostField.toString().contains(":") ? "[" + hostField + "]" : hostField.toString());
                String endpoint = uri.protocol() + "://" + uri.userinfo() + (String)host + ":" + portField.toInteger();
                this.slots[i].endpoints[j - 2] = endpoint;
                uniqueEndpoints.add((CallSite)((Object)endpoint));
                if (j != 2) continue;
                masterEndpoints.add((CallSite)((Object)endpoint));
            }
        }
        this.endpoints = new String[uniqueEndpoints.size()];
        i = 0;
        for (String string : uniqueEndpoints) {
            this.endpoints[i++] = string;
        }
        this.masterEndpoints = masterEndpoints.toArray(new String[0]);
    }

    boolean contains(String endpoint) {
        for (String entry : this.endpoints) {
            if (!endpoint.equals(entry)) continue;
            return true;
        }
        return false;
    }

    int size() {
        return this.size;
    }

    String[] endpointsForSlot(int index) {
        return this.slots[index].endpoints;
    }

    @Nullable String[] endpointsForKey(int key) {
        for (Slot s : this.slots) {
            if (key < s.start || key > s.end) continue;
            return s.endpoints;
        }
        return null;
    }

    String randomEndPoint(boolean onlyMasterEndpoints) {
        if (onlyMasterEndpoints) {
            return this.masterEndpoints[RANDOM.nextInt(this.masterEndpoints.length)];
        }
        return this.endpoints[RANDOM.nextInt(this.endpoints.length)];
    }

    String[] endpoints() {
        return this.endpoints;
    }

    String[] masterEndpoints() {
        return this.masterEndpoints;
    }

    long timestamp() {
        return this.ts;
    }

    static class Slot {
        private final int start;
        private final int end;
        private final String[] endpoints;

        Slot(int start, int end, int size) {
            this.start = start;
            this.end = end;
            this.endpoints = new String[size];
        }
    }
}

