/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.redis.client.ConstantSupplier;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisClusterConnectOptions;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisReplicationConnectOptions;
import io.vertx.redis.client.RedisSentinelConnectOptions;
import io.vertx.redis.client.RedisStandaloneConnectOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisClient;
import io.vertx.redis.client.impl.RedisClusterClient;
import io.vertx.redis.client.impl.RedisReplicationClient;
import io.vertx.redis.client.impl.RedisSentinelClient;
import java.util.List;
import java.util.function.Supplier;

@VertxGen
public interface Redis {
    public static Redis createClient(Vertx vertx) {
        return Redis.createClient(vertx, new RedisOptions());
    }

    public static Redis createClient(Vertx vertx, String connectionString) {
        return Redis.createClient(vertx, new RedisOptions().setConnectionString(connectionString));
    }

    public static Redis createClient(Vertx vertx, RedisOptions options) {
        switch (options.getType()) {
            case STANDALONE: {
                return Redis.createStandaloneClient(vertx, options, new ConstantSupplier<Future<RedisStandaloneConnectOptions>>(Future.succeededFuture((Object)new RedisStandaloneConnectOptions(options))));
            }
            case SENTINEL: {
                return Redis.createSentinelClient(vertx, options, new ConstantSupplier<Future<RedisSentinelConnectOptions>>(Future.succeededFuture((Object)new RedisSentinelConnectOptions(options))));
            }
            case CLUSTER: {
                return Redis.createClusterClient(vertx, options, new ConstantSupplier<Future<RedisClusterConnectOptions>>(Future.succeededFuture((Object)new RedisClusterConnectOptions(options))));
            }
            case REPLICATION: {
                return Redis.createReplicationClient(vertx, options, new ConstantSupplier<Future<RedisReplicationConnectOptions>>(Future.succeededFuture((Object)new RedisReplicationConnectOptions(options))));
            }
        }
        throw new IllegalStateException("Unknown Redis Client type: " + String.valueOf((Object)options.getType()));
    }

    public static Redis createStandaloneClient(Vertx vertx, RedisOptions options, Supplier<Future<RedisStandaloneConnectOptions>> connectOptions) {
        if (options.getType() != RedisClientType.STANDALONE) {
            throw new IllegalArgumentException("RedisOptions.getType() != RedisClientType.STANDALONE");
        }
        return new RedisClient(vertx, options.getNetClientOptions(), options.getPoolOptions(), connectOptions, options.getTracingPolicy());
    }

    public static Redis createReplicationClient(Vertx vertx, RedisOptions options, Supplier<Future<RedisReplicationConnectOptions>> connectOptions) {
        if (options.getType() != RedisClientType.REPLICATION) {
            throw new IllegalArgumentException("RedisOptions.getType() != RedisClientType.REPLICATION");
        }
        return new RedisReplicationClient(vertx, options.getNetClientOptions(), options.getPoolOptions(), connectOptions, options.getTracingPolicy());
    }

    public static Redis createSentinelClient(Vertx vertx, RedisOptions options, Supplier<Future<RedisSentinelConnectOptions>> connectOptions) {
        if (options.getType() != RedisClientType.SENTINEL) {
            throw new IllegalArgumentException("RedisOptions.getType() != RedisClientType.SENTINEL");
        }
        return new RedisSentinelClient(vertx, options.getNetClientOptions(), options.getPoolOptions(), connectOptions, options.getTracingPolicy());
    }

    public static Redis createClusterClient(Vertx vertx, RedisOptions options, Supplier<Future<RedisClusterConnectOptions>> connectOptions) {
        if (options.getType() != RedisClientType.CLUSTER) {
            throw new IllegalArgumentException("RedisOptions.getType() != RedisClientType.CLUSTER");
        }
        return new RedisClusterClient(vertx, options.getNetClientOptions(), options.getPoolOptions(), connectOptions, options.getTracingPolicy());
    }

    public Future<RedisConnection> connect();

    public Future<Void> close();

    public Future<@Nullable Response> send(Request var1);

    public Future<List<@Nullable Response>> batch(List<Request> var1);
}

