/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.Future;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;

public class RedisAPIImpl
implements RedisAPI {
    private static final Logger LOG = LoggerFactory.getLogger(RedisAPIImpl.class);
    private final Redis redis;
    private final RedisConnection connection;

    public RedisAPIImpl(RedisConnection connection) {
        this.connection = connection;
        this.redis = null;
    }

    public RedisAPIImpl(Redis redis) {
        this.connection = null;
        this.redis = redis;
    }

    @Override
    public Future<Response> send(Command cmd, String ... args) {
        Request req = Request.cmd(cmd);
        if (args != null) {
            for (String o : args) {
                if (o == null) {
                    throw new IllegalArgumentException("Null argument not allowed");
                }
                req.arg(o);
            }
        }
        if (this.redis != null) {
            return this.redis.send(req);
        }
        if (this.connection != null) {
            return this.connection.send(req);
        }
        return Future.failedFuture((Throwable)new IllegalStateException("Invalid state: no pool or connection available"));
    }

    @Override
    public void close() {
        if (this.redis != null) {
            this.redis.close();
        } else if (this.connection != null) {
            this.connection.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
        }
    }
}

