/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.file;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.core.file.AsyncFileLock;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.function.Supplier;

@RxGen(value=io.vertx.core.file.AsyncFile.class)
public class AsyncFile
implements RxDelegate,
io.vertx.reactivex.core.streams.ReadStream<Buffer>,
io.vertx.reactivex.core.streams.WriteStream<Buffer> {
    public static final TypeArg<AsyncFile> __TYPE_ARG = new TypeArg(obj -> new AsyncFile((io.vertx.core.file.AsyncFile)obj), AsyncFile::getDelegate);
    private final io.vertx.core.file.AsyncFile delegate;
    private Observable<Buffer> observable;
    private Flowable<Buffer> flowable;
    private WriteStreamObserver<Buffer> observer;
    private WriteStreamSubscriber<Buffer> subscriber;
    private static final TypeArg<AsyncFileLock> TYPE_ARG_0 = new TypeArg(o1 -> AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)o1), o1 -> o1.getDelegate());
    private static final TypeArg<AsyncFileLock> TYPE_ARG_1 = new TypeArg(o1 -> AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncFile that = (AsyncFile)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AsyncFile(io.vertx.core.file.AsyncFile delegate) {
        this.delegate = delegate;
    }

    public AsyncFile(Object delegate) {
        this.delegate = (io.vertx.core.file.AsyncFile)delegate;
    }

    public io.vertx.core.file.AsyncFile getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Buffer> toObservable() {
        if (this.observable == null) {
            this.observable = ObservableHelper.toObservable((ReadStream)this.getDelegate());
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<Buffer> toFlowable() {
        if (this.flowable == null) {
            this.flowable = FlowableHelper.toFlowable((ReadStream)this.getDelegate());
        }
        return this.flowable;
    }

    @Override
    public synchronized WriteStreamObserver<Buffer> toObserver() {
        if (this.observer == null) {
            this.observer = RxHelper.toObserver((WriteStream)this.getDelegate());
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            this.subscriber = RxHelper.toSubscriber((WriteStream)this.getDelegate());
        }
        return this.subscriber;
    }

    @Override
    public Future<Void> write(Buffer data) {
        Future ret = this.delegate.write((Object)data).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWrite(Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(data).onComplete($handler));
    }

    @Override
    public Future<Void> end() {
        Future ret = this.delegate.end().map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable($handler -> this.end().onComplete($handler));
    }

    @Override
    public Future<Void> end(Buffer data) {
        Future ret = this.delegate.end((Object)data).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd(Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.end(data).onComplete($handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TypeArg.unknown());
        return ret;
    }

    @Override
    public Future<Void> pipeTo(io.vertx.reactivex.core.streams.WriteStream<Buffer> dst) {
        Future ret = this.delegate.pipeTo(dst.getDelegate()).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<Buffer> dst) {
        return AsyncResultCompletable.toCompletable($handler -> this.pipeTo(dst).onComplete($handler));
    }

    public AsyncFile handler(Handler<Buffer> handler) {
        this.delegate.handler(handler);
        return this;
    }

    public AsyncFile pause() {
        this.delegate.pause();
        return this;
    }

    public AsyncFile resume() {
        this.delegate.resume();
        return this;
    }

    public AsyncFile endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public AsyncFile setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public AsyncFile drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public AsyncFile exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public AsyncFile fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public Future<Void> write(Buffer buffer, long position) {
        Future ret = this.delegate.write(buffer, position).map(val -> val);
        return ret;
    }

    public Completable rxWrite(Buffer buffer, long position) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(buffer, position).onComplete($handler));
    }

    public Future<Buffer> read(Buffer buffer, int offset, long position, int length) {
        Future ret = this.delegate.read(buffer, offset, position, length).map(val -> val);
        return ret;
    }

    public Single<Buffer> rxRead(Buffer buffer, int offset, long position, int length) {
        return AsyncResultSingle.toSingle($handler -> this.read(buffer, offset, position, length).onComplete($handler));
    }

    public Future<Void> flush() {
        Future ret = this.delegate.flush().map(val -> val);
        return ret;
    }

    public Completable rxFlush() {
        return AsyncResultCompletable.toCompletable($handler -> this.flush().onComplete($handler));
    }

    public AsyncFile setReadPos(long readPos) {
        this.delegate.setReadPos(readPos);
        return this;
    }

    public AsyncFile setReadLength(long readLength) {
        this.delegate.setReadLength(readLength);
        return this;
    }

    public long getReadLength() {
        long ret = this.delegate.getReadLength();
        return ret;
    }

    public AsyncFile setWritePos(long writePos) {
        this.delegate.setWritePos(writePos);
        return this;
    }

    public long getWritePos() {
        long ret = this.delegate.getWritePos();
        return ret;
    }

    public AsyncFile setReadBufferSize(int readBufferSize) {
        this.delegate.setReadBufferSize(readBufferSize);
        return this;
    }

    public long sizeBlocking() {
        long ret = this.delegate.sizeBlocking();
        return ret;
    }

    public Future<Long> size() {
        Future ret = this.delegate.size().map(val -> val);
        return ret;
    }

    public Single<Long> rxSize() {
        return AsyncResultSingle.toSingle($handler -> this.size().onComplete($handler));
    }

    public AsyncFileLock tryLock() {
        AsyncFileLock ret = AsyncFileLock.newInstance(this.delegate.tryLock());
        return ret;
    }

    public AsyncFileLock tryLock(long position, long size, boolean shared) {
        AsyncFileLock ret = AsyncFileLock.newInstance(this.delegate.tryLock(position, size, shared));
        return ret;
    }

    public Future<AsyncFileLock> lock() {
        Future ret = this.delegate.lock().map(val -> AsyncFileLock.newInstance(val));
        return ret;
    }

    public Single<AsyncFileLock> rxLock() {
        return AsyncResultSingle.toSingle($handler -> this.lock().onComplete($handler));
    }

    public Future<AsyncFileLock> lock(long position, long size, boolean shared) {
        Future ret = this.delegate.lock(position, size, shared).map(val -> AsyncFileLock.newInstance(val));
        return ret;
    }

    public Single<AsyncFileLock> rxLock(long position, long size, boolean shared) {
        return AsyncResultSingle.toSingle($handler -> this.lock(position, size, shared).onComplete($handler));
    }

    public <T> Future<T> withLock(final Supplier<Future<T>> block) {
        Future ret = this.delegate.withLock(new Supplier<Future<T>>(){

            @Override
            public Future<T> get() {
                Future ret = (Future)block.get();
                return ret.map(val -> val);
            }
        }).map(val -> val);
        return ret;
    }

    public <T> Single<T> rxWithLock(Supplier<Future<T>> block) {
        return AsyncResultSingle.toSingle($handler -> this.withLock(block).onComplete($handler));
    }

    public <T> Future<T> withLock(long position, long size, boolean shared, final Supplier<Future<T>> block) {
        Future ret = this.delegate.withLock(position, size, shared, new Supplier<Future<T>>(){

            @Override
            public Future<T> get() {
                Future ret = (Future)block.get();
                return ret.map(val -> val);
            }
        }).map(val -> val);
        return ret;
    }

    public <T> Single<T> rxWithLock(long position, long size, boolean shared, Supplier<Future<T>> block) {
        return AsyncResultSingle.toSingle($handler -> this.withLock(position, size, shared, block).onComplete($handler));
    }

    public static AsyncFile newInstance(io.vertx.core.file.AsyncFile arg) {
        return arg != null ? new AsyncFile(arg) : null;
    }
}

