/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceresolver;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.endpoint.EndpointResolverInternal;
import io.vertx.core.net.AddressResolver;
import io.vertx.core.net.endpoint.Endpoint;
import io.vertx.core.net.endpoint.LoadBalancer;
import io.vertx.core.spi.endpoint.EndpointResolver;
import io.vertx.serviceresolver.ServiceAddress;
import io.vertx.serviceresolver.ServiceResolverOptions;
import io.vertx.serviceresolver.impl.ServiceResolverClientImpl;
import io.vertx.serviceresolver.kube.KubeResolver;
import io.vertx.serviceresolver.kube.KubeResolverOptions;
import io.vertx.serviceresolver.srv.SrvResolver;
import io.vertx.serviceresolver.srv.SrvResolverOptions;

@VertxGen
public interface ServiceResolverClient
extends io.vertx.core.net.endpoint.EndpointResolver {
    public static ServiceResolverClient create(Vertx vertx, ServiceResolverOptions options) {
        return ServiceResolverClient.create(vertx, LoadBalancer.ROUND_ROBIN, options);
    }

    @GenIgnore(value={"permitted-type"})
    public static ServiceResolverClient create(Vertx vertx, LoadBalancer loadBalancer, ServiceResolverOptions options) {
        AddressResolver addressResolver;
        if (options instanceof KubeResolverOptions) {
            addressResolver = KubeResolver.create((KubeResolverOptions)options);
        } else if (options instanceof SrvResolverOptions) {
            addressResolver = SrvResolver.create((SrvResolverOptions)options);
        } else {
            throw new IllegalArgumentException();
        }
        EndpointResolver resolver = addressResolver.endpointResolver(vertx);
        EndpointResolverInternal r = EndpointResolverInternal.create((VertxInternal)((VertxInternal)vertx), (EndpointResolver)resolver, (LoadBalancer)loadBalancer, (long)1000L);
        ServiceResolverClientImpl r2 = new ServiceResolverClientImpl(vertx, r);
        r2.init();
        return r2;
    }

    public Future<Endpoint> resolveEndpoint(ServiceAddress var1);

    public Future<Void> close();
}

