/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceresolver.kube;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.serviceresolver.ServiceResolverOptions;
import io.vertx.serviceresolver.kube.KubeResolverOptionsConverter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class KubeResolverOptions
extends ServiceResolverOptions {
    private static final String KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    private static final String KUBERNETES_SERVICE_PORT = "KUBERNETES_SERVICE_PORT";
    private static final String KUBERNETES_SERVICE_ACCOUNT_TOKEN = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private static final String KUBERNETES_SERVICE_ACCOUNT_CA = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    private static final String KUBERNETES_SERVICE_ACCOUNT_NAMESPACE = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    private static final SocketAddress DEFAULT_SERVER;
    private static final String DEFAULT_TOKEN;
    private static final String DEFAULT_NAMESPACE;
    private static final HttpClientOptions DEFAULT_HTTP_CLIENT_OPTIONS;
    private static final WebSocketClientOptions DEFAULT_WEB_SOCKET_OPTIONS;
    private SocketAddress server = DEFAULT_SERVER;
    private String namespace = DEFAULT_NAMESPACE;
    private String bearerToken = DEFAULT_TOKEN;
    private HttpClientOptions httpClientOptions = new HttpClientOptions(DEFAULT_HTTP_CLIENT_OPTIONS);
    private WebSocketClientOptions webSocketClientOptions = new WebSocketClientOptions(DEFAULT_WEB_SOCKET_OPTIONS);

    public KubeResolverOptions() {
        this.server = DEFAULT_SERVER;
        this.namespace = DEFAULT_NAMESPACE;
        this.bearerToken = DEFAULT_TOKEN;
        this.httpClientOptions = new HttpClientOptions(DEFAULT_HTTP_CLIENT_OPTIONS);
        this.webSocketClientOptions = new WebSocketClientOptions(DEFAULT_WEB_SOCKET_OPTIONS);
    }

    public KubeResolverOptions(KubeResolverOptions other) {
        this.server = other.server;
        this.namespace = other.namespace;
        this.bearerToken = other.bearerToken;
        this.httpClientOptions = other.httpClientOptions != null ? new HttpClientOptions(other.httpClientOptions) : new HttpClientOptions();
        this.webSocketClientOptions = other.webSocketClientOptions != null ? new WebSocketClientOptions(other.webSocketClientOptions) : new WebSocketClientOptions();
    }

    public KubeResolverOptions(JsonObject json) {
        KubeResolverOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public SocketAddress getServer() {
        return this.server;
    }

    public KubeResolverOptions setServer(SocketAddress server) {
        this.server = server;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public KubeResolverOptions setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public KubeResolverOptions setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        return this;
    }

    public HttpClientOptions getHttpClientOptions() {
        return this.httpClientOptions;
    }

    public KubeResolverOptions setHttpClientOptions(HttpClientOptions httpClientOptions) {
        this.httpClientOptions = httpClientOptions;
        return this;
    }

    public WebSocketClientOptions getWebSocketClientOptions() {
        return this.webSocketClientOptions;
    }

    public KubeResolverOptions setWebSocketClientOptions(WebSocketClientOptions webSocketClientOptions) {
        this.webSocketClientOptions = webSocketClientOptions;
        return this;
    }

    static {
        String host = System.getenv(KUBERNETES_SERVICE_HOST);
        Integer port = 443;
        String v = System.getenv(KUBERNETES_SERVICE_PORT);
        if (v != null) {
            try {
                port = Integer.parseInt(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        File tokenFile = new File(KUBERNETES_SERVICE_ACCOUNT_TOKEN);
        String token = null;
        if (tokenFile.exists()) {
            try {
                token = Buffer.buffer((byte[])Files.readAllBytes(tokenFile.toPath())).toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String namespace = "default";
        File namespaceFile = new File(KUBERNETES_SERVICE_ACCOUNT_NAMESPACE);
        if (namespaceFile.exists()) {
            try {
                namespace = Buffer.buffer((byte[])Files.readAllBytes(namespaceFile.toPath())).toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        HttpClientOptions httpClientOptions = new HttpClientOptions().setSsl(true);
        WebSocketClientOptions webSocketClientOptions = new WebSocketClientOptions().setSsl(true);
        File caFile = new File(KUBERNETES_SERVICE_ACCOUNT_CA);
        if (caFile.exists()) {
            PemTrustOptions pemTrustOptions = new PemTrustOptions().addCertPath(KUBERNETES_SERVICE_ACCOUNT_CA);
            httpClientOptions.setTrustOptions((TrustOptions)pemTrustOptions);
            webSocketClientOptions.setTrustOptions((TrustOptions)pemTrustOptions);
        }
        DEFAULT_SERVER = host != null ? SocketAddress.inetSocketAddress((int)port, (String)host) : null;
        DEFAULT_TOKEN = token;
        DEFAULT_NAMESPACE = namespace;
        DEFAULT_HTTP_CLIENT_OPTIONS = httpClientOptions;
        DEFAULT_WEB_SOCKET_OPTIONS = webSocketClientOptions;
    }
}

