/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.DefaultValue;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.file.FileProps;
import io.vertx.ext.shell.cli.Completion;
import io.vertx.ext.shell.command.AnnotatedCommand;
import io.vertx.ext.shell.command.CommandProcess;
import io.vertx.ext.shell.command.base.FsHelper;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

@Name(value="ls")
@Summary(value="List directory content")
public class FileSystemLs
extends AnnotatedCommand {
    private boolean ell;
    private String file;
    private boolean all;

    @Option(shortName="l", flag=true)
    @Description(value="list in long format")
    public void setEll(boolean ell) {
        this.ell = ell;
    }

    @Argument(index=0, argName="file", required=false)
    @Description(value="the file to list")
    @DefaultValue(value=".")
    public void setFile(String file) {
        this.file = file;
    }

    @Option(longName="all", shortName="a", required=false)
    @Description(value="include files that begins with .")
    public void setAll(boolean all) {
        this.all = all;
    }

    @Override
    public void process(CommandProcess process) {
        new FsHelper().ls(process.vertx(), (String)process.session().get("cwd"), this.file, (Handler<AsyncResult<Map<String, FileProps>>>)((Handler)ar -> {
            if (ar.succeeded()) {
                Map result = (Map)ar.result();
                if (result.size() > 0) {
                    Function<Map.Entry, String> formatter;
                    Stream<Object> entries = result.entrySet().stream();
                    entries = entries.map(entry -> new AbstractMap.SimpleEntry<String, FileProps>(((String)entry.getKey()).substring(((String)entry.getKey()).lastIndexOf(47) + 1), (FileProps)entry.getValue()));
                    if (!this.all) {
                        entries = entries.filter(entry -> !((String)entry.getKey()).startsWith("."));
                    }
                    if (this.ell) {
                        int width = result.values().stream().map(FileProps::size).max(Long::compare).get().toString().length();
                        String format = "%1$s %2$" + width + "s %3$tb %3$2te %3$tH:%3$tM %4$s";
                        formatter = entry -> {
                            FileProps props = (FileProps)entry.getValue();
                            String a = props.isDirectory() ? "d" : (props.isSymbolicLink() ? "l" : "-");
                            return String.format(format, a, props.size(), new Date(props.lastModifiedTime()), entry.getKey());
                        };
                    } else {
                        formatter = Map.Entry::getKey;
                    }
                    entries.map(formatter).forEach(file -> process.write(file + "\n"));
                } else {
                    process.write("ls:" + ar.cause().getMessage() + "\n");
                }
            } else {
                process.write("ls: " + ar.cause().getMessage() + "\n");
            }
            process.end();
        }));
    }

    @Override
    public void complete(Completion completion) {
        new FsHelper().completionHandler().handle((Object)completion);
    }
}

