/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import io.vertx.ext.shell.cli.Completion;
import java.io.File;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

class FsHelper {
    private final Path rootDir = new File(System.getProperty("vertx.cwd", ".")).getAbsoluteFile().toPath().normalize();

    FsHelper() {
    }

    String rootDir() {
        return this.rootDir.toString();
    }

    void cd(FileSystem fs, String currentPath, String pathArg, Handler<AsyncResult<String>> pathHandler) {
        Path base = currentPath != null ? new File(currentPath).toPath() : this.rootDir;
        String path = base.resolve(pathArg).toAbsolutePath().normalize().toString();
        fs.props(path).onComplete(ar -> {
            if (ar.succeeded() && ((FileProps)ar.result()).isDirectory()) {
                pathHandler.handle((Object)Future.succeededFuture((Object)path));
            } else {
                pathHandler.handle((Object)Future.failedFuture((Throwable)new NoSuchFileException(path)));
            }
        });
    }

    void ls(Vertx vertx, String currentFile, String pathArg, Handler<AsyncResult<Map<String, FileProps>>> filesHandler) {
        Path base = currentFile != null ? new File(currentFile).toPath() : this.rootDir;
        String path = base.resolve(pathArg).toAbsolutePath().normalize().toString();
        vertx.executeBlocking(() -> {
            FileSystem fs = vertx.fileSystem();
            if (fs.propsBlocking(path).isDirectory()) {
                LinkedHashMap<String, FileProps> result = new LinkedHashMap<String, FileProps>();
                for (String file : fs.readDirBlocking(path)) {
                    result.put(file, fs.propsBlocking(file));
                }
                return result;
            }
            throw new RuntimeException(path + ": No such file or directory");
        }).onComplete(filesHandler);
    }

    Handler<Completion> completionHandler() {
        return completion -> {
            int s = completion.lineTokens().size();
            String last = s > 0 && completion.lineTokens().get(s - 1).isText() ? completion.lineTokens().get(s - 1).value() : "";
            this.complete(completion.vertx(), (String)completion.session().get("path"), last, (Handler<AsyncResult<Map<String, Boolean>>>)((Handler)result -> {
                if (result.succeeded()) {
                    Map matches = (Map)result.result();
                    switch (matches.size()) {
                        case 0: {
                            completion.complete(Collections.emptyList());
                            break;
                        }
                        case 1: {
                            Map.Entry match = matches.entrySet().iterator().next();
                            completion.complete((String)match.getKey(), (Boolean)match.getValue());
                            break;
                        }
                        default: {
                            completion.complete(new ArrayList<String>(matches.keySet()));
                            break;
                        }
                    }
                } else {
                    completion.complete(Collections.emptyList());
                }
            }));
        };
    }

    void complete(Vertx vertx, String currentPath, String _prefix, Handler<AsyncResult<Map<String, Boolean>>> handler) {
        vertx.executeBlocking(() -> {
            String prefix;
            FileSystem fs = vertx.fileSystem();
            Path base = currentPath != null ? new File(currentPath).toPath() : this.rootDir;
            int index = _prefix.lastIndexOf(47);
            if (index == 0) {
                throw new VertxException("todo");
            }
            if (index > 0) {
                base = base.resolve(_prefix.substring(0, index));
                prefix = _prefix.substring(index + 1);
            } else {
                prefix = _prefix;
            }
            LinkedHashMap<Object, Boolean> matches = new LinkedHashMap<Object, Boolean>();
            for (String path : fs.readDirBlocking(base.toAbsolutePath().normalize().toString())) {
                String name = path.substring(path.lastIndexOf(47) + 1);
                if (!name.startsWith(prefix)) continue;
                FileProps props = fs.propsBlocking(path);
                matches.put(name.substring(prefix.length()) + (props.isDirectory() ? "/" : ""), props.isRegularFile());
            }
            if (matches.size() > 1) {
                String common = Completion.findLongestCommonPrefix(matches.keySet());
                if (common.length() > 0) {
                    matches.clear();
                    matches.put(common, false);
                } else {
                    LinkedHashMap tmp = new LinkedHashMap();
                    matches.forEach((suffix, terminal) -> tmp.put(prefix + suffix, terminal));
                    matches = tmp;
                }
            }
            return matches;
        }).onComplete(handler);
    }
}

