/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.vertx.core.Vertx;
import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.SharedData;
import io.vertx.ext.shell.command.AnnotatedCommand;
import io.vertx.ext.shell.command.CommandProcess;
import java.util.List;

@Name(value="local-map-get")
@Summary(value="Get values from a local map")
public class LocalMapGet
extends AnnotatedCommand {
    private String map;
    private List<String> keys;

    @Argument(index=0, argName="map")
    @Description(value="the name of the map to get from")
    public void setMap(String map) {
        this.map = map;
    }

    @Argument(index=1, argName="keys", required=false)
    @Description(value="the keys to get")
    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    @Override
    public void process(CommandProcess process) {
        Vertx vertx = process.vertx();
        SharedData sharedData = vertx.sharedData();
        LocalMap map = sharedData.getLocalMap(this.map);
        if (this.keys != null) {
            for (String key : this.keys) {
                Object value = map.get((Object)key);
                process.write(key + ": " + String.valueOf(value) + "\n");
            }
        }
        process.end();
    }
}

