/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.ext.shell.cli.CliToken;
import io.vertx.ext.shell.command.Command;
import io.vertx.ext.shell.command.CommandProcess;
import io.vertx.ext.shell.session.Session;
import io.vertx.ext.shell.system.ExecStatus;
import io.vertx.ext.shell.system.Process;
import io.vertx.ext.shell.term.Tty;
import java.util.List;
import java.util.stream.Collectors;

public class ProcessImpl
implements Process {
    private final Vertx vertx;
    private final Context context;
    private final Context processContext;
    private final Command commandContext;
    private final Handler<CommandProcess> handler;
    private final List<CliToken> args;
    private Tty tty;
    private Session session;
    private Handler<Void> interruptHandler;
    private Handler<Void> suspendHandler;
    private Handler<Void> resumeHandler;
    private Handler<Void> endHandler;
    private Handler<Void> backgroundHandler;
    private Handler<Void> foregroundHandler;
    private Handler<Integer> terminatedHandler;
    private boolean foreground;
    private ExecStatus processStatus;
    private boolean processForeground;
    private Handler<String> stdinHandler;
    private Handler<Void> resizeHandler;
    private Integer exitCode;

    public ProcessImpl(Vertx vertx, Context context, Command commandContext, List<CliToken> args, Handler<CommandProcess> handler) {
        this.vertx = vertx;
        this.context = context;
        this.commandContext = commandContext;
        this.handler = handler;
        this.args = args;
        this.processContext = vertx.getOrCreateContext();
        this.processStatus = ExecStatus.READY;
    }

    @Override
    public Integer exitCode() {
        return this.exitCode;
    }

    @Override
    public ExecStatus status() {
        return this.processStatus;
    }

    @Override
    public synchronized Process setTty(Tty tty) {
        this.tty = tty;
        return this;
    }

    @Override
    public synchronized Tty getTty() {
        return this.tty;
    }

    @Override
    public synchronized Process setSession(Session session) {
        this.session = session;
        return this;
    }

    @Override
    public synchronized Session getSession() {
        return this.session;
    }

    @Override
    public Process terminatedHandler(Handler<Integer> handler) {
        this.terminatedHandler = handler;
        return this;
    }

    @Override
    public boolean interrupt(Handler<Void> completionHandler) {
        if (this.processStatus == ExecStatus.RUNNING || this.processStatus == ExecStatus.STOPPED) {
            Handler<Void> handler = this.interruptHandler;
            this.processContext.runOnContext(v -> {
                try {
                    if (handler != null) {
                        handler.handle(null);
                    }
                }
                finally {
                    if (completionHandler != null) {
                        this.processContext.runOnContext(completionHandler);
                    }
                }
            });
            return handler != null;
        }
        throw new IllegalStateException("Cannot interrupt process in " + String.valueOf((Object)this.processStatus) + " state");
    }

    @Override
    public synchronized void resume(boolean fg, Handler<Void> completionHandler) {
        if (this.processStatus != ExecStatus.STOPPED) {
            throw new IllegalStateException("Cannot resume process in " + String.valueOf((Object)this.processStatus) + " state");
        }
        this.updateStatus(ExecStatus.RUNNING, null, fg, this.resumeHandler, this.terminatedHandler, completionHandler);
    }

    @Override
    public synchronized void suspend(Handler<Void> completionHandler) {
        if (this.processStatus != ExecStatus.RUNNING) {
            throw new IllegalStateException("Cannot suspend process in " + String.valueOf((Object)this.processStatus) + " state");
        }
        this.updateStatus(ExecStatus.STOPPED, null, false, this.suspendHandler, this.terminatedHandler, completionHandler);
    }

    @Override
    public void toBackground(Handler<Void> completionHandler) {
        if (this.processStatus == ExecStatus.RUNNING) {
            if (this.processForeground) {
                this.updateStatus(ExecStatus.RUNNING, null, false, this.backgroundHandler, this.terminatedHandler, completionHandler);
            }
        } else {
            throw new IllegalStateException("Cannot set to background a process in " + String.valueOf((Object)this.processStatus) + " state");
        }
    }

    @Override
    public void toForeground(Handler<Void> completionHandler) {
        if (this.processStatus == ExecStatus.RUNNING) {
            if (!this.processForeground) {
                this.updateStatus(ExecStatus.RUNNING, null, true, this.foregroundHandler, this.terminatedHandler, completionHandler);
            }
        } else {
            throw new IllegalStateException("Cannot set to foreground a process in " + String.valueOf((Object)this.processStatus) + " state");
        }
    }

    @Override
    public void terminate(Handler<Void> completionHandler) {
        if (!this.terminate(-10, completionHandler)) {
            throw new IllegalStateException("Cannot terminate terminated process");
        }
    }

    private synchronized boolean terminate(int exitCode, Handler<Void> completionHandler) {
        if (this.processStatus != ExecStatus.TERMINATED) {
            this.updateStatus(ExecStatus.TERMINATED, exitCode, false, this.endHandler, this.terminatedHandler, completionHandler);
            return true;
        }
        return false;
    }

    private void updateStatus(ExecStatus statusUpdate, Integer exitCodeUpdate, boolean foregroundUpdate, Handler<Void> handler, Handler<Integer> terminatedHandler, Handler<Void> completionHandler) {
        this.processStatus = statusUpdate;
        this.exitCode = exitCodeUpdate;
        if (!foregroundUpdate) {
            if (this.processForeground) {
                this.processForeground = false;
                if (this.stdinHandler != null) {
                    this.tty.stdinHandler(null);
                }
                if (this.resizeHandler != null) {
                    this.tty.resizehandler(null);
                }
            }
        } else if (!this.processForeground) {
            this.processForeground = true;
            if (this.stdinHandler != null) {
                this.tty.stdinHandler(this.stdinHandler);
            }
            if (this.resizeHandler != null) {
                this.tty.resizehandler(this.resizeHandler);
            }
        }
        this.context.runOnContext(v -> {
            this.foreground = foregroundUpdate;
            try {
                if (handler != null) {
                    handler.handle(null);
                }
            }
            finally {
                if (completionHandler != null) {
                    this.processContext.runOnContext(completionHandler);
                }
            }
        });
        if (terminatedHandler != null && statusUpdate == ExecStatus.TERMINATED) {
            this.processContext.runOnContext(v -> terminatedHandler.handle((Object)exitCodeUpdate));
        }
    }

    @Override
    public synchronized void run(boolean fg) {
        CommandLine cl;
        if (this.processStatus != ExecStatus.READY) {
            throw new IllegalStateException("Cannot run proces in " + String.valueOf((Object)this.processStatus) + " state");
        }
        this.processStatus = ExecStatus.RUNNING;
        this.processForeground = fg;
        this.foreground = fg;
        final Tty tty = this.tty;
        if (tty == null) {
            throw new IllegalStateException("Cannot execute process without a TTY set");
        }
        final List args2 = this.args.stream().filter(CliToken::isText).map(CliToken::value).collect(Collectors.toList());
        if (this.commandContext.cli() != null) {
            try {
                if (this.commandContext.cli().parse(args2, false).isAskingForHelp()) {
                    StringBuilder usage = new StringBuilder();
                    this.commandContext.cli().usage(usage);
                    usage.append('\n');
                    tty.write(usage.toString());
                    this.terminate();
                    return;
                }
                cl = this.commandContext.cli().parse(args2);
            }
            catch (CLIException e) {
                tty.write(e.getMessage() + "\n");
                this.terminate();
                return;
            }
        } else {
            cl = null;
        }
        CommandProcess process = new CommandProcess(){

            @Override
            public Vertx vertx() {
                return ProcessImpl.this.vertx;
            }

            @Override
            public String type() {
                return tty.type();
            }

            @Override
            public CommandLine commandLine() {
                return cl;
            }

            @Override
            public List<CliToken> argsTokens() {
                return ProcessImpl.this.args;
            }

            @Override
            public List<String> args() {
                return args2;
            }

            @Override
            public boolean isForeground() {
                return ProcessImpl.this.foreground;
            }

            @Override
            public Session session() {
                return ProcessImpl.this.session;
            }

            @Override
            public int width() {
                return tty.width();
            }

            @Override
            public int height() {
                return tty.height();
            }

            @Override
            public CommandProcess stdinHandler(Handler<String> handler) {
                ProcessImpl.this.stdinHandler = handler != null ? data -> ProcessImpl.this.context.runOnContext(v -> handler.handle(data)) : null;
                if (ProcessImpl.this.processForeground && ProcessImpl.this.stdinHandler != null) {
                    tty.stdinHandler(ProcessImpl.this.stdinHandler);
                }
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommandProcess write(String data) {
                ProcessImpl processImpl = ProcessImpl.this;
                synchronized (processImpl) {
                    if (ProcessImpl.this.processStatus != ExecStatus.RUNNING) {
                        throw new IllegalStateException("Cannot write to standard output when " + ProcessImpl.this.status().name().toLowerCase());
                    }
                }
                ProcessImpl.this.processContext.runOnContext(v -> tty.write(data));
                return this;
            }

            @Override
            public CommandProcess resizehandler(Handler<Void> handler) {
                ProcessImpl.this.resizeHandler = handler != null ? v -> ProcessImpl.this.context.runOnContext(arg_0 -> ((Handler)handler).handle(arg_0)) : null;
                tty.resizehandler(ProcessImpl.this.resizeHandler);
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommandProcess interruptHandler(Handler<Void> handler) {
                ProcessImpl processImpl = ProcessImpl.this;
                synchronized (processImpl) {
                    ProcessImpl.this.interruptHandler = handler;
                }
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommandProcess suspendHandler(Handler<Void> handler) {
                ProcessImpl processImpl = ProcessImpl.this;
                synchronized (processImpl) {
                    ProcessImpl.this.suspendHandler = handler;
                }
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommandProcess resumeHandler(Handler<Void> handler) {
                ProcessImpl processImpl = ProcessImpl.this;
                synchronized (processImpl) {
                    ProcessImpl.this.resumeHandler = handler;
                }
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommandProcess endHandler(Handler<Void> handler) {
                ProcessImpl processImpl = ProcessImpl.this;
                synchronized (processImpl) {
                    ProcessImpl.this.endHandler = handler;
                }
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommandProcess backgroundHandler(Handler<Void> handler) {
                ProcessImpl processImpl = ProcessImpl.this;
                synchronized (processImpl) {
                    ProcessImpl.this.backgroundHandler = handler;
                }
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommandProcess foregroundHandler(Handler<Void> handler) {
                ProcessImpl processImpl = ProcessImpl.this;
                synchronized (processImpl) {
                    ProcessImpl.this.foregroundHandler = handler;
                }
                return this;
            }

            @Override
            public void end() {
                this.end(0);
            }

            @Override
            public void end(int statusCode) {
                ProcessImpl.this.terminate(statusCode, null);
            }
        };
        this.context.runOnContext(v -> {
            try {
                this.handler.handle((Object)process);
            }
            catch (Throwable e) {
                this.terminate(1, null);
                throw e;
            }
        });
    }
}

