/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.shell.term.HttpTermOptions;
import io.vertx.ext.shell.term.SSHTermOptions;
import io.vertx.ext.shell.term.TelnetTermOptions;
import io.vertx.ext.shell.term.Term;
import io.vertx.ext.shell.term.impl.HttpTermServer;
import io.vertx.ext.shell.term.impl.SSHServer;
import io.vertx.ext.shell.term.impl.TelnetTermServer;
import io.vertx.ext.web.Router;

@VertxGen
public interface TermServer {
    public static TermServer createSSHTermServer(Vertx vertx) {
        return TermServer.createSSHTermServer(vertx, new SSHTermOptions());
    }

    public static TermServer createSSHTermServer(Vertx vertx, SSHTermOptions options) {
        return new SSHServer(vertx, options);
    }

    public static TermServer createTelnetTermServer(Vertx vertx) {
        return TermServer.createTelnetTermServer(vertx, new TelnetTermOptions());
    }

    public static TermServer createTelnetTermServer(Vertx vertx, TelnetTermOptions options) {
        return new TelnetTermServer(vertx, options);
    }

    public static TermServer createHttpTermServer(Vertx vertx) {
        return TermServer.createHttpTermServer(vertx, new HttpTermOptions());
    }

    public static TermServer createHttpTermServer(Vertx vertx, HttpTermOptions options) {
        return new HttpTermServer(vertx, options);
    }

    public static TermServer createHttpTermServer(Vertx vertx, Router router) {
        return TermServer.createHttpTermServer(vertx, router, new HttpTermOptions());
    }

    public static TermServer createHttpTermServer(Vertx vertx, Router router, HttpTermOptions options) {
        return new HttpTermServer(vertx, router, options);
    }

    @Fluent
    public TermServer termHandler(Handler<Term> var1);

    @Fluent
    public TermServer authenticationProvider(AuthenticationProvider var1);

    public Future<Void> listen();

    public int actualPort();

    public Future<Void> close();
}

