/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.TransactionPropagation;
import io.vertx.sqlclient.TransactionRollbackException;
import io.vertx.sqlclient.impl.TransactionPropagationLocal;
import io.vertx.sqlclient.impl.Utils;
import io.vertx.sqlclient.internal.pool.PoolImpl;
import io.vertx.sqlclient.spi.Driver;
import java.util.ArrayList;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Function;

@VertxGen
public interface Pool
extends SqlClient {
    public static Pool pool(SqlConnectOptions connectOptions) {
        return Pool.pool(connectOptions, new PoolOptions());
    }

    public static Pool pool(SqlConnectOptions database, PoolOptions options) {
        return Pool.pool(null, database, options);
    }

    public static Pool pool(Vertx vertx, SqlConnectOptions database, PoolOptions options) {
        ArrayList<Driver> candidates = new ArrayList<Driver>(1);
        for (Driver d : ServiceLoader.load(Driver.class)) {
            if (!d.acceptsOptions(database)) continue;
            candidates.add(d);
        }
        if (candidates.size() == 0) {
            throw new ServiceConfigurationError("No implementations of " + String.valueOf(Driver.class) + " found that accept connection options " + String.valueOf(database));
        }
        if (candidates.size() > 1) {
            throw new ServiceConfigurationError("Multiple implementations of " + String.valueOf(Driver.class) + " found: " + String.valueOf(candidates));
        }
        Driver driver = (Driver)candidates.get(0);
        return driver.createPool(vertx, Utils.singletonSupplier(driver.downcast(database)), options, new NetClientOptions(), null);
    }

    public Future<SqlConnection> getConnection();

    @Override
    public Query<RowSet<Row>> query(String var1);

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String var1);

    default public <T> Future<@Nullable T> withTransaction(Function<SqlConnection, Future<@Nullable T>> function) {
        return this.getConnection().flatMap(conn -> conn.begin().flatMap(tx -> ((Future)function.apply((SqlConnection)conn)).compose(res -> tx.commit().flatMap(v -> Future.succeededFuture((Object)res)), err -> {
            if (err instanceof TransactionRollbackException) {
                return Future.failedFuture((Throwable)err);
            }
            return tx.rollback().compose(v -> Future.failedFuture((Throwable)err), failure -> Future.failedFuture((Throwable)err));
        })).onComplete(ar -> conn.close()));
    }

    default public <T> Future<@Nullable T> withTransaction(TransactionPropagation txPropagation, Function<SqlConnection, Future<@Nullable T>> function) {
        if (txPropagation == TransactionPropagation.CONTEXT) {
            ContextInternal context = (ContextInternal)Vertx.currentContext();
            SqlConnection sqlConnection = (SqlConnection)context.getLocal(TransactionPropagationLocal.KEY);
            if (sqlConnection == null) {
                return PoolImpl.startPropagatableConnection(this, function);
            }
            return context.succeededFuture((Object)sqlConnection).flatMap(conn -> ((Future)function.apply((SqlConnection)conn)).onFailure(err -> {
                if (!(err instanceof TransactionRollbackException)) {
                    conn.transaction().rollback();
                }
            }));
        }
        return this.withTransaction(function);
    }

    default public <T> Future<@Nullable T> withConnection(Function<SqlConnection, Future<@Nullable T>> function) {
        return this.getConnection().flatMap(conn -> ((Future)function.apply((SqlConnection)conn)).onComplete(ar -> conn.close()));
    }

    public int size();
}

