/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.impl.SqlResultBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;

public class RowSetImpl<R>
extends SqlResultBase<RowSet<R>>
implements RowSet<R> {
    public static Collector<Row, RowSetImpl<Row>, RowSet<Row>> COLLECTOR = Collector.of(RowSetImpl::new, RowSetImpl::add, (set1, set2) -> null, set -> set, new Collector.Characteristics[0]);
    public static Function<RowSet<Row>, RowSetImpl<Row>> FACTORY = rs -> (RowSetImpl)rs;
    private List<R> rowAccumulator = Collections.emptyList();

    static <U> Collector<Row, RowSetImpl<U>, RowSet<U>> collector(Function<Row, U> mapper) {
        return Collector.of(RowSetImpl::new, (set, row) -> set.add(mapper.apply((Row)row)), (set1, set2) -> null, set -> set, new Collector.Characteristics[0]);
    }

    static <U> Function<RowSet<U>, RowSetImpl<U>> factory() {
        return rs -> (RowSetImpl)rs;
    }

    @Override
    public RowSet<R> value() {
        return this;
    }

    private void add(R row) {
        if (this.rowAccumulator.isEmpty()) {
            this.rowAccumulator = new ArrayList<R>();
        }
        this.rowAccumulator.add(row);
    }

    @Override
    public RowIterator<R> iterator() {
        final Iterator<R> iter = this.rowAccumulator.iterator();
        return new RowIterator<R>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public R next() {
                return iter.next();
            }
        };
    }

    @Override
    public RowSetImpl<R> next() {
        return (RowSetImpl)super.next();
    }
}

