/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor;

import io.vertx.codegen.processor.PropertyKind;
import io.vertx.codegen.processor.doc.Doc;
import io.vertx.codegen.processor.doc.Text;
import io.vertx.codegen.processor.type.AnnotationValueInfo;
import io.vertx.codegen.processor.type.TypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyInfo {
    final PropertyKind kind;
    final boolean declared;
    final String name;
    final Doc doc;
    final TypeInfo type;
    final String setterMethod;
    final String adderMethod;
    final String getterMethod;
    final boolean jsonifiable;
    final boolean deprecated;
    final Text deprecatedDesc;
    final Map<String, AnnotationValueInfo> annotations;

    public PropertyInfo(boolean declared, String name, Doc doc, TypeInfo type, String setterMethod, String adderMethod, String getterMethod, List<AnnotationValueInfo> annotations, PropertyKind kind, boolean jsonifiable, boolean deprecated, Text deprecatedDesc) {
        this.kind = kind;
        this.declared = declared;
        this.name = name;
        this.doc = doc;
        this.type = type;
        this.annotations = annotations.stream().collect(HashMap::new, (m, a) -> m.put(a.getName(), a), HashMap::putAll);
        this.adderMethod = adderMethod;
        this.setterMethod = setterMethod;
        this.getterMethod = getterMethod;
        this.jsonifiable = jsonifiable;
        this.deprecated = deprecated;
        this.deprecatedDesc = deprecatedDesc;
    }

    public boolean isDeclared() {
        return this.declared;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public PropertyKind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public String getGetterMethod() {
        return this.getterMethod;
    }

    public String getSetterMethod() {
        return this.setterMethod;
    }

    public String getAdderMethod() {
        return this.adderMethod;
    }

    public List<AnnotationValueInfo> getAnnotations() {
        return new ArrayList<AnnotationValueInfo>(this.annotations.values());
    }

    public AnnotationValueInfo getAnnotation(String annotationName) {
        return this.annotations.get(annotationName);
    }

    public boolean isValue() {
        return this.kind == PropertyKind.VALUE;
    }

    public boolean isList() {
        return this.kind == PropertyKind.LIST;
    }

    public boolean isSet() {
        return this.kind == PropertyKind.SET;
    }

    public boolean isMap() {
        return this.kind == PropertyKind.MAP;
    }

    public boolean isSetter() {
        return this.setterMethod != null;
    }

    public boolean isAdder() {
        return this.adderMethod != null;
    }

    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    public boolean isJsonifiable() {
        return this.jsonifiable;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public Text getDeprecatedDesc() {
        return this.deprecatedDesc;
    }

    public String toString() {
        return "PropertyInfo(name=" + this.name + ")";
    }
}

