/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.mvel.impl;

import io.netty.util.internal.PlatformDependent;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.common.template.CachedTemplate;
import io.vertx.ext.web.common.template.CachingTemplateEngine;
import io.vertx.ext.web.templ.mvel.MVELTemplateEngine;
import java.nio.charset.Charset;
import java.util.Map;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.mvel2.util.StringAppender;

public class MVELTemplateEngineImpl
extends CachingTemplateEngine<CompiledTemplate>
implements MVELTemplateEngine {
    private final Vertx vertx;

    public MVELTemplateEngineImpl(Vertx vertx, String extension) {
        super(vertx, extension);
        this.vertx = vertx;
    }

    public Future<Buffer> render(Map<String, Object> context, String templateFile) {
        try {
            String baseDir;
            String src = this.adjustLocation(templateFile);
            CachedTemplate template = this.getTemplate(src);
            if (template == null) {
                int idx = MVELTemplateEngineImpl.findLastFileSeparator(src);
                baseDir = "";
                if (idx != -1) {
                    baseDir = src.substring(0, idx);
                }
                if (!this.vertx.fileSystem().existsBlocking(src)) {
                    return Future.failedFuture((String)("Cannot find template " + src));
                }
                template = new CachedTemplate((Object)TemplateCompiler.compileTemplate(this.vertx.fileSystem().readFileBlocking(src).toString(Charset.defaultCharset())), baseDir);
                this.putTemplate(src, template);
            }
            CompiledTemplate mvel = (CompiledTemplate)template.template();
            baseDir = template.baseDir();
            return Future.succeededFuture((Object)Buffer.buffer((String)((String)new TemplateRuntime(mvel.getTemplate(), null, mvel.getRoot(), baseDir).execute(new StringAppender(), context, (VariableResolverFactory)new MapVariableResolverFactory()))));
        }
        catch (Exception ex) {
            return Future.failedFuture((Throwable)ex);
        }
    }

    private static int findLastFileSeparator(String src) {
        if (PlatformDependent.isWindows()) {
            return Math.max(src.lastIndexOf(47), src.lastIndexOf(92));
        }
        return src.lastIndexOf(47);
    }
}

