/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.runtime;

import com.fizzed.rocker.RockerStringify;
import com.fizzed.rocker.Version;
import com.fizzed.rocker.runtime.DefaultHtmlStringify;
import com.fizzed.rocker.runtime.DefaultRockerBootstrap;
import com.fizzed.rocker.runtime.RockerBootstrap;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RockerRuntime {
    private static final Logger log = LoggerFactory.getLogger((String)RockerRuntime.class.getName());
    public static final String KEY_RELOADING = "rocker.reloading";
    public static final String CONF_RESOURCE_NAME = "/rocker-compiler.conf";
    private Boolean reloading;
    private RockerBootstrap bootstrap;

    private RockerRuntime() {
        log.info("Rocker version {}", (Object)Version.getVersion());
        String reloadingProperty = System.getProperty(KEY_RELOADING, "false");
        if (reloadingProperty.equalsIgnoreCase("true")) {
            this.setReloading(true);
        } else if (reloadingProperty.equalsIgnoreCase("false")) {
            this.setReloading(false);
        } else {
            throw new IllegalArgumentException("Illegal value [" + reloadingProperty + "] for rocker.reloading sytem property");
        }
    }

    public static RockerRuntime getInstance() {
        return Holder.INSTANCE;
    }

    public boolean isReloading() {
        return this.reloading;
    }

    public final void setReloading(boolean reloading) {
        if (this.reloading != null && this.reloading == reloading) {
            return;
        }
        if (reloading) {
            this.bootstrap = this.buildReloadingRockerBootstrap();
            log.info("Rocker template reloading activated");
        } else {
            this.bootstrap = new DefaultRockerBootstrap();
            log.info("Rocker template reloading not activated");
        }
        this.reloading = reloading;
    }

    public RockerBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public boolean isReloadingPossible() {
        try {
            this.buildReloadingRockerBootstrap();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private RockerBootstrap buildReloadingRockerBootstrap() {
        if (ToolProvider.getSystemJavaCompiler() == null) {
            throw new RuntimeException("Unable to activate Rocker template reloading. No system java compiler available. Are you running with a JRE instead of a JDK?");
        }
        if (this.getClass().getResource(CONF_RESOURCE_NAME) == null) {
            throw new RuntimeException("Unable to activate Rocker template reloading. Unable to find /rocker-compiler.conf on classpath. Did one get generated during the build?");
        }
        try {
            Class<?> bootstrapType = Class.forName("com.fizzed.rocker.reload.ReloadingRockerBootstrap");
            return (RockerBootstrap)bootstrapType.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to activate Rocker template reloading. Did you forget to include 'rocker-compiler' as an optional/provided dependency?");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to activate Rocker template reloading. Unable to create ReloadingRockerBootstrap instance", e);
        }
    }

    public static RockerStringify createDefaultHtmlStringify() {
        try {
            Class<?> cls = Class.forName("com.fizzed.rocker.runtime.GuavaHtmlStringify");
            return (RockerStringify)cls.newInstance();
        }
        catch (Throwable t) {
            return new DefaultHtmlStringify();
        }
    }

    private static class Holder {
        static final RockerRuntime INSTANCE = new RockerRuntime();

        private Holder() {
        }
    }
}

