/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.LanguageHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.common.template.TemplateEngine;
import io.vertx.ext.web.handler.TemplateHandler;
import io.vertx.ext.web.impl.Utils;
import java.util.Locale;

public class TemplateHandlerImpl
implements TemplateHandler {
    private final TemplateEngine engine;
    private final String templateDirectory;
    private final String contentType;
    private String indexTemplate;

    public TemplateHandlerImpl(TemplateEngine engine, String templateDirectory, String contentType) {
        this.engine = engine;
        this.templateDirectory = templateDirectory == null || templateDirectory.isEmpty() ? "." : templateDirectory;
        this.contentType = contentType;
        this.indexTemplate = "index";
    }

    public void handle(RoutingContext context) {
        Object file = Utils.pathOffset(context.normalizedPath(), context);
        if (((String)file).endsWith("/") && null != this.indexTemplate) {
            file = (String)file + this.indexTemplate;
        }
        if (this.templateDirectory == null || "".equals(this.templateDirectory)) {
            file = ((String)file).substring(1);
        }
        if (!context.data().containsKey("lang")) {
            for (LanguageHeader acceptableLocale : context.acceptableLanguages()) {
                try {
                    Locale.forLanguageTag(acceptableLocale.value());
                }
                catch (RuntimeException e) {
                    continue;
                }
                context.data().put("lang", acceptableLocale.value());
                break;
            }
        }
        if (!context.request().isEnded()) {
            context.request().pause();
        }
        this.engine.render(context.data(), this.templateDirectory + (String)file).onSuccess(data -> {
            if (!context.request().isEnded()) {
                context.request().resume();
            }
            context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)this.contentType).end(data);
        }).onFailure(err -> {
            if (!context.request().isEnded()) {
                context.request().resume();
            }
            context.fail((Throwable)err);
        });
    }

    @Override
    public TemplateHandler setIndexTemplate(String indexTemplate) {
        this.indexTemplate = indexTemplate;
        return this;
    }
}

