/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Group;
import javax.media.j3d.Light;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Color3f;

public abstract class LightState
extends LeafState {
    private int boundingLeaf = 0;
    private int[] scope;

    public LightState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        this.scope = new int[((Light)this.node).numScopes()];
        int n = 0;
        while (n < ((Light)this.node).numScopes()) {
            this.scope[n] = this.control.getSymbolTable().addReference((SceneGraphObject)((Light)this.node).getScope(n));
            ++n;
        }
        this.boundingLeaf = this.control.getSymbolTable().addReference((SceneGraphObject)((Light)this.node).getInfluencingBoundingLeaf());
        Color3f color3f = new Color3f();
        ((Light)this.node).getColor(color3f);
        this.control.writeColor3f(dataOutput, color3f);
        dataOutput.writeBoolean(((Light)this.node).getEnable());
        dataOutput.writeInt(this.boundingLeaf);
        this.control.writeBounds(dataOutput, ((Light)this.node).getInfluencingBounds());
        dataOutput.writeInt(this.scope.length);
        int n2 = 0;
        while (n2 < this.scope.length) {
            dataOutput.writeInt(this.scope[n2]);
            ++n2;
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        ((Light)this.node).setColor(this.control.readColor3f(dataInput));
        ((Light)this.node).setEnable(dataInput.readBoolean());
        this.boundingLeaf = dataInput.readInt();
        ((Light)this.node).setInfluencingBounds(this.control.readBounds(dataInput));
        this.scope = new int[dataInput.readInt()];
        int n = 0;
        while (n < this.scope.length) {
            this.scope[n] = dataInput.readInt();
            ++n;
        }
    }

    public void buildGraph() {
        ((Light)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        int n = 0;
        while (n < this.scope.length) {
            ((Light)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scope[n]));
            ++n;
        }
        super.buildGraph();
    }
}

