/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.FreeListManager;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryLock;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

abstract class GeometryRetained
extends NodeComponentRetained {
    static final int GEO_TYPE_NONE = -1;
    static final int GEO_TYPE_QUAD_SET = 1;
    static final int GEO_TYPE_TRI_SET = 2;
    static final int GEO_TYPE_POINT_SET = 3;
    static final int GEO_TYPE_LINE_SET = 4;
    static final int GEO_TYPE_TRI_STRIP_SET = 5;
    static final int GEO_TYPE_TRI_FAN_SET = 6;
    static final int GEO_TYPE_LINE_STRIP_SET = 7;
    static final int GEO_TYPE_INDEXED_QUAD_SET = 8;
    static final int GEO_TYPE_INDEXED_TRI_SET = 9;
    static final int GEO_TYPE_INDEXED_POINT_SET = 10;
    static final int GEO_TYPE_INDEXED_LINE_SET = 11;
    static final int GEO_TYPE_INDEXED_TRI_STRIP_SET = 12;
    static final int GEO_TYPE_INDEXED_TRI_FAN_SET = 13;
    static final int GEO_TYPE_INDEXED_LINE_STRIP_SET = 14;
    static final int GEO_TYPE_RASTER = 15;
    static final int GEO_TYPE_TEXT3D = 16;
    static final int GEO_TYPE_COMPRESSED = 17;
    static final int GEO_TYPE_TOTAL = 17;
    static final int GEO_TYPE_GEOMETRYARRAY = 14;
    BoundingBox geoBounds = new BoundingBox();
    boolean boundsDirty = true;
    int computeGeoBounds = 0;
    int geoType = -1;
    int nativeId = -1;
    int isDirty = 65535;
    GeometryLock geomLock = new GeometryLock();
    Object liveStateLock = new Object();
    GeometryRetained mirrorGeometry = null;
    boolean isEditable = true;
    ArrayList universeList = new ArrayList();
    ArrayList userLists = new ArrayList();
    boolean noAlpha = false;
    static final double EPSILON = 1.0E-6;
    Point3d centroid = new Point3d();
    boolean recompCentroid = true;
    int cachedChangedFrequent = 0;
    static final int POINT_TYPE = 1;
    static final int LINE_TYPE = 2;
    static final int TRIANGLE_TYPE = 3;
    static final int QUAD_TYPE = 4;
    static final int RASTER_TYPE = 5;
    static final int TEXT3D_TYPE = 6;
    static final int COMPRESS_TYPE = 7;

    GeometryRetained() {
    }

    abstract void update();

    boolean isEquivalenceClass(GeometryRetained geometryRetained) {
        int n = this.getClassType();
        int n2 = geometryRetained.getClassType();
        if (n == 4) {
            n = 3;
        }
        if (n2 == 4) {
            n2 = 3;
        }
        return n == n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrComputeGeoBounds() {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            ++this.computeGeoBounds;
            if (this.computeGeoBounds == 1 && this.source.isLive()) {
                this.computeBoundingBox();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrComputeGeoBounds() {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            --this.computeGeoBounds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUser(Shape3DRetained shape3DRetained) {
        if (shape3DRetained.sourceNode.boundsAutoCompute) {
            this.incrComputeGeoBounds();
        }
        if (this instanceof GeometryArrayRetained && ((GeometryArrayRetained)this).isWriteStatic()) {
            return;
        }
        ArrayList arrayList = this.universeList;
        synchronized (arrayList) {
            if (this.universeList.contains(shape3DRetained.universe)) {
                int n = this.universeList.indexOf(shape3DRetained.universe);
                ArrayList arrayList2 = (ArrayList)this.userLists.get(n);
                arrayList2.add(shape3DRetained);
            } else {
                this.universeList.add(shape3DRetained.universe);
                ArrayList<Shape3DRetained> arrayList3 = new ArrayList<Shape3DRetained>();
                arrayList3.add(shape3DRetained);
                this.userLists.add(arrayList3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUser(Shape3DRetained shape3DRetained) {
        if (shape3DRetained.sourceNode.boundsAutoCompute) {
            this.decrComputeGeoBounds();
        }
        if (this instanceof GeometryArrayRetained && ((GeometryArrayRetained)this).isWriteStatic()) {
            return;
        }
        ArrayList arrayList = this.universeList;
        synchronized (arrayList) {
            int n = this.universeList.indexOf(shape3DRetained.universe);
            ArrayList arrayList2 = (ArrayList)this.userLists.get(n);
            arrayList2.remove(arrayList2.indexOf(shape3DRetained));
            if (arrayList2.size() == 0) {
                this.userLists.remove(n);
                this.universeList.remove(n);
            }
        }
    }

    public void updateObject() {
        this.update();
    }

    abstract void computeBoundingBox();

    void setLive(boolean bl, int n) {
        this.doSetLive(bl, n);
        super.markAsLive();
    }

    void doSetLive(boolean bl, int n) {
        super.doSetLive(bl, n);
        this.update();
        this.computeBoundingBox();
    }

    abstract void execute(Canvas3D var1, RenderAtom var2, boolean var3, boolean var4, float var5, boolean var6, int var7, boolean var8, int var9);

    int getVertexFormat() {
        return 0;
    }

    abstract boolean intersect(PickShape var1, double[] var2, Point3d var3);

    abstract boolean intersect(Bounds var1);

    abstract boolean intersect(Point3d[] var1);

    abstract boolean intersect(Transform3D var1, GeometryRetained var2);

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        Transform3D transform3D3 = VirtualUniverse.mc.getTransform3D(null);
        transform3D3.invert(transform3D2);
        transform3D3.mul(transform3D);
        FreeListManager.freeObject(2, transform3D3);
        return this.intersect(transform3D3, geometryRetained);
    }

    boolean intersect(Transform3D transform3D, Bounds bounds) {
        Bounds bounds2 = (Bounds)bounds.clone();
        Transform3D transform3D2 = VirtualUniverse.mc.getTransform3D(null);
        transform3D2.invert(transform3D);
        bounds2.transform(transform3D2);
        FreeListManager.freeObject(2, transform3D2);
        return this.intersect(bounds2);
    }

    boolean canBeInDisplayList(boolean bl) {
        return !(!VirtualUniverse.mc.isDisplayList || this.isEditable || !(this instanceof GeometryArrayRetained) && bl || bl && (((GeometryArrayRetained)this).vertexFormat & 4) != 0 || (((GeometryArrayRetained)this).vertexFormat & 0x80) != 0 && !VirtualUniverse.mc.buildDisplayListIfPossible);
    }

    void computeCentroid() {
        this.centroid.set((Tuple3d)this.geoBounds.getCenter());
    }

    abstract int getClassType();
}

