/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.eastwood;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategorySeriesLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialRange;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.eastwood.DataUtilities;
import org.jfree.eastwood.GCategoryAxis;
import org.jfree.eastwood.GCategoryAxis3D;
import org.jfree.eastwood.GCategoryPlot;
import org.jfree.eastwood.GLabelledAxis;
import org.jfree.eastwood.GPieSectionLabelGenerator;
import org.jfree.eastwood.GSeriesLabelGenerator;
import org.jfree.eastwood.GValueAxis;
import org.jfree.eastwood.GValueAxis3D;
import org.jfree.eastwood.GXYPlot;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.util.SortOrder;

public class ChartEngine {
    public static JFreeChart buildChart(Map params) {
        return ChartEngine.buildChart(params, new Font("Dialog", 0, 12));
    }

    public static JFreeChart buildChart(Map params, Font font) {
        String[] pieRotation;
        String[] fillStr;
        String[] gridStr;
        String[] lineStr;
        XYDataset dataset;
        PiePlot plot;
        String[] chds;
        String[] titleStr;
        String[] axisStyleStr;
        String[] axisPositionStr;
        GLabelledAxis axis;
        String[] axisLabelStr;
        String[] axisRangeStr;
        String[] axisLabelOrientationStr;
        XYPlot plot2;
        if (params == null) {
            throw new IllegalArgumentException("Null 'params' argument.");
        }
        JFreeChart chart = null;
        String[] chartType = (String[])params.get("cht");
        int dataType = -1;
        if (chartType[0].equals("p")) {
            chart = ChartEngine.createPieChart();
            dataType = 0;
        } else if (chartType[0].equals("p3")) {
            chart = ChartEngine.createPieChart3D();
            dataType = 0;
        } else if (chartType[0].equals("lc")) {
            chart = ChartEngine.createLineChart();
            dataType = 1;
        } else if (chartType[0].equals("ls")) {
            chart = ChartEngine.createSparklineChart();
            dataType = 1;
        } else if (chartType[0].equals("lxy")) {
            chart = ChartEngine.createLineChart();
            dataType = 3;
        } else if (chartType[0].equals("bhs")) {
            chart = ChartEngine.createStackedBarChart(PlotOrientation.HORIZONTAL);
            dataType = 2;
        } else if (chartType[0].equals("bhg")) {
            chart = ChartEngine.createBarChart(PlotOrientation.HORIZONTAL);
            dataType = 2;
        } else if (chartType[0].equals("bvs")) {
            chart = ChartEngine.createStackedBarChart(PlotOrientation.VERTICAL);
            dataType = 2;
        } else if (chartType[0].equals("bvg")) {
            chart = ChartEngine.createBarChart(PlotOrientation.VERTICAL);
            dataType = 2;
        } else if (chartType[0].equals("bhs3")) {
            chart = ChartEngine.createStackedBarChart3D(PlotOrientation.HORIZONTAL);
            dataType = 2;
        } else if (chartType[0].equals("bhg3")) {
            chart = ChartEngine.createBarChart3D(PlotOrientation.HORIZONTAL);
            dataType = 2;
        } else if (chartType[0].equals("bvs3")) {
            chart = ChartEngine.createStackedBarChart3D(PlotOrientation.VERTICAL);
            dataType = 2;
        } else if (chartType[0].equals("bvg3")) {
            chart = ChartEngine.createBarChart3D(PlotOrientation.VERTICAL);
            dataType = 2;
        } else if (chartType[0].equals("s")) {
            chart = ChartEngine.createScatterChart();
            dataType = 4;
        } else if (chartType[0].equals("dial")) {
            chart = ChartEngine.createDialChart();
            dataType = 5;
        } else {
            if (chartType[0].equals("v")) {
                throw new RuntimeException("Venn diagrams not implemented.");
            }
            throw new RuntimeException("Unknown chart type: " + chartType[0]);
        }
        chart.getPlot().setOutlineVisible(false);
        if (chart.getPlot() instanceof XYPlot) {
            plot2 = (XYPlot)chart.getPlot();
            plot2.getDomainAxis().setLabelFont(font);
            plot2.getDomainAxis().setTickLabelFont(font);
            plot2.getRangeAxis().setLabelFont(font);
            plot2.getRangeAxis().setTickLabelFont(font);
        } else if (chart.getPlot() instanceof CategoryPlot) {
            plot2 = (CategoryPlot)chart.getPlot();
            plot2.getDomainAxis().setLabelFont(font);
            plot2.getDomainAxis().setTickLabelFont(font);
            plot2.getRangeAxis().setLabelFont(font);
            plot2.getRangeAxis().setTickLabelFont(font);
        }
        ArrayList axes = new ArrayList();
        String[] axisStr = (String[])params.get("chxt");
        if (axisStr != null) {
            XYPlot plot3;
            if (chart.getPlot() instanceof XYPlot) {
                plot3 = (XYPlot)chart.getPlot();
                ChartEngine.processAxisStr(plot3, axisStr[0], axes);
            } else if (chart.getPlot() instanceof CategoryPlot) {
                plot3 = (CategoryPlot)chart.getPlot();
                if (plot3.getOrientation() == PlotOrientation.VERTICAL) {
                    ChartEngine.processAxisStrV((CategoryPlot)plot3, axisStr[0], axes);
                } else {
                    ChartEngine.processAxisStrH((CategoryPlot)plot3, axisStr[0], axes);
                }
            }
        }
        if ((axisLabelOrientationStr = (String[])params.get("ewlo")) != null) {
            String[] orientations = ChartEngine.breakString(axisLabelOrientationStr[0], '|');
            for (int i = 0; i < orientations.length; ++i) {
                int comma = orientations[i].indexOf(44);
                int axisIndex = Integer.parseInt(orientations[i].substring(0, comma));
                String orientation = orientations[i].substring(comma + 1);
                Axis axis2 = (Axis)axes.get(axisIndex);
                if (!(axis2 instanceof GCategoryAxis)) continue;
                GCategoryAxis gaxis = (GCategoryAxis)axis2;
                gaxis.setCategoryLabelPositions(ChartEngine.getCategoryLabelPositions(orientation));
            }
        }
        if ((axisRangeStr = (String[])params.get("chxr")) != null) {
            String[] ranges = ChartEngine.breakString(axisRangeStr[0], '|');
            for (int i = 0; i < ranges.length; ++i) {
                int comma1 = ranges[i].indexOf(44);
                int comma2 = ranges[i].indexOf(44, comma1 + 1);
                int axisIndex = Integer.parseInt(ranges[i].substring(0, comma1));
                float lowerBound = Float.parseFloat(ranges[i].substring(comma1 + 1, comma2));
                float upperBound = Float.parseFloat(ranges[i].substring(comma2 + 1));
                Axis axis3 = (Axis)axes.get(axisIndex);
                if (axis3 instanceof GValueAxis) {
                    GValueAxis gaxis = (GValueAxis)axis3;
                    gaxis.setLabelAxisStart(lowerBound);
                    gaxis.setLabelAxisEnd(upperBound);
                    continue;
                }
                if (!(axis3 instanceof GValueAxis3D)) continue;
                GValueAxis3D gaxis3 = (GValueAxis3D)axis3;
                gaxis3.setLabelAxisStart(lowerBound);
                gaxis3.setLabelAxisEnd(upperBound);
            }
        }
        if ((axisLabelStr = (String[])params.get("chxl")) != null) {
            Pattern p = Pattern.compile("\\d+:\\|");
            Matcher m = p.matcher(axisLabelStr[0]);
            if (m.find()) {
                String[] labels;
                int keyStart = m.start();
                int labelStart = m.end();
                while (m.find(labelStart)) {
                    String keyStr = axisLabelStr[0].substring(keyStart, labelStart - 2);
                    int axisIndex = Integer.parseInt(keyStr);
                    keyStart = m.start();
                    String labelStr = axisLabelStr[0].substring(labelStart, keyStart - 1);
                    labels = ChartEngine.breakString(labelStr, '|');
                    axis = (GLabelledAxis)axes.get(axisIndex);
                    axis.setTickLabels(Arrays.asList(labels));
                    labelStart = m.end();
                }
                String keyStr = axisLabelStr[0].substring(keyStart, labelStart - 2);
                String labelStr = axisLabelStr[0].substring(labelStart);
                int axisIndex = Integer.parseInt(keyStr);
                if (labelStr.endsWith("|")) {
                    labelStr = labelStr.substring(0, labelStr.length() - 1);
                }
                labels = ChartEngine.breakString(labelStr, '|');
                axis = (GLabelledAxis)axes.get(axisIndex);
                axis.setTickLabels(Arrays.asList(labels));
            } else {
                throw new RuntimeException("No matching pattern!");
            }
        }
        if ((axisPositionStr = (String[])params.get("chxp")) != null) {
            String[] positions = ChartEngine.breakString(axisPositionStr[0], '|');
            for (int i = 0; i < positions.length; ++i) {
                int c1 = positions[i].indexOf(44);
                int axisIndex = Integer.parseInt(positions[i].substring(0, c1));
                String remainingStr = positions[i].substring(c1 + 1);
                String[] valueStr = ChartEngine.breakString(remainingStr, ',');
                ArrayList<Float> tickValues = new ArrayList<Float>(valueStr.length);
                axis = (Axis)axes.get(axisIndex);
                if (!(axis instanceof GValueAxis)) continue;
                GValueAxis gaxis = (GValueAxis)axes.get(axisIndex);
                for (int j = 0; j < valueStr.length; ++j) {
                    float pos = Float.parseFloat(valueStr[j]);
                    tickValues.add(new Float(pos));
                }
                gaxis.setTickLabelPositions(tickValues);
            }
        }
        if ((axisStyleStr = (String[])params.get("chxs")) != null) {
            String[] styles = ChartEngine.breakString(axisStyleStr[0], '|');
            for (int i = 0; i < styles.length; ++i) {
                String[] styleSpec = ChartEngine.breakString(styles[i], ',');
                int axisIndex = Integer.parseInt(styleSpec[0]);
                Axis axis4 = (Axis)axes.get(axisIndex);
                Color axisColor = ChartEngine.parseColor(styleSpec[1]);
                axis4.setTickLabelPaint((Paint)axisColor);
                if (styleSpec.length > 2) {
                    int fontSize = Integer.parseInt(styleSpec[2]);
                    if (fontSize > 0) {
                        Font oldFont = axis4.getTickLabelFont();
                        Font newFont = oldFont.deriveFont((float)fontSize);
                        axis4.setTickLabelFont(newFont);
                    } else {
                        axis4.setTickLabelsVisible(false);
                    }
                }
                if (styleSpec.length > 3) {
                    // empty if block
                }
                if (styleSpec.length > 4) {
                    String drawingControl = styleSpec[4];
                    if ("l".equals(drawingControl)) {
                        axis4.setTickMarksVisible(false);
                    } else if ("t".equals(drawingControl)) {
                        axis4.setAxisLineVisible(false);
                    } else if ("_".equals(drawingControl)) {
                        axis4.setVisible(false);
                    } else if (!"lt".equals(drawingControl)) {
                        throw new RuntimeException("Unknown drawing control " + drawingControl);
                    }
                }
                if (styleSpec.length <= 5) continue;
                Color tickColor = ChartEngine.parseColor(styleSpec[5]);
                axis4.setTickMarkPaint((Paint)tickColor);
            }
        }
        if ((titleStr = (String[])params.get("chtt")) != null) {
            String[] s = ChartEngine.breakString(titleStr[0], '|');
            for (int i = 0; i < s.length; ++i) {
                TextTitle t = new TextTitle(s[i].replace('+', ' '));
                t.setPaint((Paint)Color.gray);
                t.setFont(font.deriveFont(font.getSize2D() * 14.0f / 12.0f));
                chart.addSubtitle((Title)t);
            }
            String[] fontStr = (String[])params.get("chts");
            if (fontStr != null) {
                int c1 = fontStr[0].indexOf(44);
                String colorStr = null;
                String fontSizeStr = null;
                if (c1 != -1) {
                    colorStr = fontStr[0].substring(0, c1);
                    fontSizeStr = fontStr[0].substring(c1 + 1);
                } else {
                    colorStr = fontStr[0];
                }
                Color color = ChartEngine.parseColor(colorStr);
                int size = 12;
                if (fontSizeStr != null) {
                    size = Integer.parseInt(fontSizeStr);
                }
                for (int i = 0; i < chart.getSubtitleCount(); ++i) {
                    Title t = chart.getSubtitle(i);
                    if (!(t instanceof TextTitle)) continue;
                    TextTitle tt = (TextTitle)t;
                    tt.setPaint((Paint)color);
                    tt.setFont(font.deriveFont((float)size));
                }
            }
        }
        String[] dataStr = (String[])params.get("chd");
        String scalingStr = null;
        if (dataStr.length > 0 && dataStr[0].startsWith("t:") && (chds = (String[])params.get("chds")) != null && chds.length > 0) {
            scalingStr = chds[0];
        }
        String[] d2Str = (String[])params.get("ewd2");
        if (dataType == 0) {
            PieDataset dataset2 = DataUtilities.parsePieDataset(dataStr[0], scalingStr);
            plot = (PiePlot)chart.getPlot();
            plot.setDataset(dataset2);
        } else if (dataType == 1) {
            XYPlot plot4 = (XYPlot)chart.getPlot();
            dataset = DataUtilities.parseXYDataset(dataStr[0], scalingStr);
            plot4.setDataset(dataset);
            if (d2Str != null) {
                XYDataset d2 = DataUtilities.parseXYDataset(d2Str[0], scalingStr);
                plot4.setDataset(1, d2);
            }
        } else if (dataType == 2) {
            CategoryPlot plot5 = (CategoryPlot)chart.getPlot();
            dataset = DataUtilities.parseCategoryDataset(dataStr[0], scalingStr);
            plot5.setDataset((CategoryDataset)dataset);
            if (d2Str != null) {
                DefaultCategoryDataset d2 = DataUtilities.parseCategoryDataset(d2Str[0], scalingStr);
                plot5.setDataset(1, (CategoryDataset)d2);
            }
        } else if (dataType == 3) {
            XYPlot plot6 = (XYPlot)chart.getPlot();
            dataset = DataUtilities.parseXYDataset2(dataStr[0], scalingStr);
            plot6.setDataset(dataset);
            if (d2Str != null) {
                XYDataset d2 = DataUtilities.parseXYDataset2(d2Str[0], scalingStr);
                plot6.setDataset(1, d2);
            }
        } else if (dataType == 4) {
            XYPlot plot7 = (XYPlot)chart.getPlot();
            dataset = DataUtilities.parseScatterDataset(dataStr[0], scalingStr);
            if (dataset.getSeriesCount() > 1) {
                dataset.removeSeries(1);
            }
            plot7.setDataset(dataset);
            if (d2Str != null) {
                XYDataset d2 = DataUtilities.parseXYDataset2(d2Str[0], scalingStr);
                plot7.setDataset(1, d2);
            }
        } else if (dataType == 5) {
            DialPlot plot8 = (DialPlot)chart.getPlot();
            String[] data = dataStr[0].substring(dataStr[0].indexOf(":") + 1).split(",");
            if (data.length == 0) {
                throw new RuntimeException("Dial chart needs data points");
            }
            float value = Float.parseFloat(data[0]);
            plot8.setDataset((ValueDataset)new DefaultValueDataset((double)value));
            double lowerBound = 0.0;
            double upperBound = 100.0;
            double majorTickIncrement = 10.0;
            int minorTickIncrement = 4;
            if (data.length > 1) {
                for (int i = 1; i < data.length; ++i) {
                    if (data[i].indexOf("dr=") == 0) {
                        String[] rd = data[i].substring(3).split(":");
                        if (rd.length != 3) continue;
                        StandardDialRange range = new StandardDialRange((double)Float.parseFloat(rd[0]), (double)Float.parseFloat(rd[1]), (Paint)new Color(Integer.parseInt(rd[2], 16)));
                        range.setInnerRadius(0.52);
                        range.setOuterRadius(0.55);
                        plot8.addLayer((DialLayer)range);
                        continue;
                    }
                    if (data[i].indexOf("lb=") == 0) {
                        lowerBound = Double.parseDouble(data[i].substring(3));
                        continue;
                    }
                    if (data[i].indexOf("ub=") == 0) {
                        upperBound = Double.parseDouble(data[i].substring(3));
                        continue;
                    }
                    if (data[i].indexOf("mt=") == 0) {
                        minorTickIncrement = Integer.parseInt(data[i].substring(3));
                        continue;
                    }
                    if (data[i].indexOf("mjt=") != 0) continue;
                    majorTickIncrement = Double.parseDouble(data[i].substring(4));
                }
            }
            StandardDialScale scale = new StandardDialScale(lowerBound, upperBound, -120.0, -300.0, majorTickIncrement, minorTickIncrement);
            scale.setTickRadius(0.9);
            scale.setTickLabelOffset(0.17);
            scale.setTickLabelFont(font);
            plot8.addScale(0, (DialScale)scale);
            plot8.removePointer(0);
            DialPointer.Pointer p = new DialPointer.Pointer();
            p.setFillPaint((Paint)Color.gray);
            plot8.addPointer((DialPointer)p);
        }
        String[] colorStr = (String[])params.get("chco");
        if (colorStr != null) {
            Color[] colors = ChartEngine.parseColors(colorStr[0]);
            if (dataType == 0) {
                PiePlot plot9 = (PiePlot)chart.getPlot();
                ChartEngine.applyColorsToPiePlot(plot9, colors);
            } else {
                AbstractRenderer renderer = null;
                if (chart.getPlot() instanceof CategoryPlot) {
                    CategoryPlot plot10 = (CategoryPlot)chart.getPlot();
                    renderer = (AbstractRenderer)plot10.getRenderer();
                    renderer.setBasePaint((Paint)colors[0]);
                } else if (chart.getPlot() instanceof XYPlot) {
                    XYPlot plot11 = (XYPlot)chart.getPlot();
                    renderer = (AbstractRenderer)plot11.getRenderer();
                    renderer.setBasePaint((Paint)colors[colors.length - 1]);
                }
                for (int i = 0; i < colors.length; ++i) {
                    renderer.setSeriesPaint(i, (Paint)colors[i]);
                }
            }
        } else {
            plot = chart.getPlot();
            if (plot instanceof PiePlot) {
                ChartEngine.applyColorsToPiePlot((PiePlot)chart.getPlot(), new Color[]{new Color(255, 153, 0)});
            }
        }
        if ((lineStr = (String[])params.get("chls")) != null && chart.getPlot() instanceof XYPlot) {
            Stroke[] strokes = ChartEngine.parseLineStyles(lineStr[0]);
            XYPlot plot12 = (XYPlot)chart.getPlot();
            XYItemRenderer renderer = plot12.getRenderer();
            for (int i = 0; i < strokes.length; ++i) {
                renderer.setSeriesStroke(i, strokes[i]);
            }
            renderer.setBaseStroke(strokes[strokes.length - 1]);
        }
        if (dataType != 0 && (gridStr = (String[])params.get("chg")) != null) {
            ChartEngine.processGridLinesSpec(gridStr[0], chart);
        }
        if (dataType == 0) {
            String[] labelStr = (String[])params.get("chl");
            if (labelStr != null) {
                String[] s = ChartEngine.breakString(labelStr[0], '|');
                List<String> labels = Arrays.asList(s);
                PiePlot plot13 = (PiePlot)chart.getPlot();
                if (labels.size() > 0) {
                    plot13.setLabelGenerator((PieSectionLabelGenerator)new GPieSectionLabelGenerator(labels));
                    plot13.setLabelFont(font);
                    plot13.setLabelPaint((Paint)Color.gray);
                }
            }
        } else if (dataType == 5) {
            DialPlot plot14 = (DialPlot)chart.getPlot();
            String[] labelStr = (String[])params.get("chl");
            if (labelStr != null) {
                DialTextAnnotation annotation1 = new DialTextAnnotation(labelStr[0]);
                annotation1.setFont(font);
                annotation1.setRadius(0.7);
                plot14.addLayer((DialLayer)annotation1);
            }
        } else {
            String[] s;
            List<String> labels;
            String[] legendStr = (String[])params.get("chdl");
            if (legendStr != null && (labels = Arrays.asList(s = ChartEngine.breakString(legendStr[0], '|'))).size() > 0) {
                int i;
                CategoryPlot plot15;
                Plot p = chart.getPlot();
                if (p instanceof CategoryPlot) {
                    plot15 = (CategoryPlot)chart.getPlot();
                    BarRenderer renderer = (BarRenderer)plot15.getRenderer();
                    renderer.setLegendItemLabelGenerator((CategorySeriesLabelGenerator)new GSeriesLabelGenerator(labels));
                    renderer.setBaseSeriesVisibleInLegend(false);
                    for (i = 0; i < labels.size(); ++i) {
                        renderer.setSeriesVisibleInLegend(i, Boolean.TRUE);
                    }
                } else if (p instanceof XYPlot) {
                    plot15 = (XYPlot)chart.getPlot();
                    XYItemRenderer renderer = plot15.getRenderer();
                    renderer.setLegendItemLabelGenerator((XYSeriesLabelGenerator)new GSeriesLabelGenerator(labels));
                    renderer.setBaseSeriesVisibleInLegend(false);
                    for (i = 0; i < labels.size(); ++i) {
                        renderer.setSeriesVisibleInLegend(i, Boolean.TRUE);
                    }
                }
                LegendTitle legend = new LegendTitle((LegendItemSource)chart.getPlot());
                RectangleEdge pos = RectangleEdge.RIGHT;
                String[] chdlp = (String[])params.get("chdlp");
                if (chdlp != null) {
                    if ("b".equals(chdlp[0])) {
                        pos = RectangleEdge.BOTTOM;
                    } else if ("t".equals(chdlp[0])) {
                        pos = RectangleEdge.TOP;
                    } else if ("l".equals(chdlp[0])) {
                        pos = RectangleEdge.LEFT;
                    }
                }
                legend.setPosition(pos);
                legend.setItemFont(font);
                legend.setItemPaint((Paint)Color.gray);
                chart.addSubtitle((Title)legend);
            }
        }
        String[] markerStr = (String[])params.get("chm");
        if (markerStr != null) {
            String[] markers = ChartEngine.breakString(markerStr[0], '|');
            for (int i = 0; i < markers.length; ++i) {
                ChartEngine.addMarker(markers[i], chart);
            }
        }
        if ((fillStr = (String[])params.get("chf")) != null) {
            int i = fillStr[0].indexOf(124);
            if (i == -1) {
                ChartEngine.processFillSpec(fillStr[0], chart);
            } else {
                String fs1 = fillStr[0].substring(0, i);
                String fs2 = fillStr[0].substring(i + 1);
                ChartEngine.processFillSpec(fs1, chart);
                ChartEngine.processFillSpec(fs2, chart);
            }
        }
        if ((pieRotation = (String[])params.get("chp")) != null) {
            double rotation = -Math.toDegrees(Double.parseDouble(pieRotation[0]));
            Plot plot16 = chart.getPlot();
            if (plot16 instanceof PiePlot) {
                ((PiePlot)plot16).setStartAngle(rotation);
            } else if (plot16 instanceof PiePlot3D) {
                ((PiePlot3D)plot16).setStartAngle(rotation);
            }
        }
        ChartEngine.processEWTR(params, chart);
        return chart;
    }

    public static void processEWTR(Map params, JFreeChart chart) {
        String[] ewtrStr = (String[])params.get("ewtr");
        if (ewtrStr != null) {
            XYPlot xp;
            String[] atts = ewtrStr[0].split(",");
            int series = Integer.parseInt(atts[0]);
            Color color = ChartEngine.parseColor(atts[1]);
            float lineWidth = Float.parseFloat(atts[2]);
            Plot plot = chart.getPlot();
            if (plot instanceof CategoryPlot) {
                CategoryPlot cp = (CategoryPlot)plot;
                if (cp.getDataset(1) != null) {
                    LineAndShapeRenderer r = new LineAndShapeRenderer(true, false);
                    r.setBaseSeriesVisible(false);
                    r.setSeriesVisible(series, Boolean.TRUE);
                    r.setSeriesPaint(series, (Paint)color);
                    r.setSeriesStroke(series, (Stroke)new BasicStroke(lineWidth));
                    cp.setRenderer(1, (CategoryItemRenderer)r);
                    cp.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
                }
            } else if (plot instanceof XYPlot && (xp = (XYPlot)plot).getDataset(1) != null) {
                XYLineAndShapeRenderer r = new XYLineAndShapeRenderer(true, false);
                r.setBaseSeriesVisible(false);
                r.setSeriesVisible(series, Boolean.TRUE);
                r.setSeriesPaint(series, (Paint)color);
                r.setSeriesStroke(series, (Stroke)new BasicStroke(lineWidth));
                xp.setRenderer(1, (XYItemRenderer)r);
                xp.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
            }
        }
    }

    private static JFreeChart createDialChart() {
        DialPlot plot = new DialPlot();
        plot.setDialFrame((DialFrame)new StandardDialFrame());
        GradientPaint gp = new GradientPaint(new Point(), new Color(255, 255, 255), new Point(), new Color(170, 170, 220));
        DialBackground db = new DialBackground((Paint)gp);
        db.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL));
        plot.setBackground((DialLayer)db);
        plot.addPointer((DialPointer)new DialPointer.Pin());
        DialCap cap = new DialCap();
        plot.setCap((DialLayer)cap);
        return new JFreeChart((Plot)plot);
    }

    private static JFreeChart createPieChart() {
        JFreeChart chart = ChartFactory.createPieChart(null, null, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setBackgroundPaint(null);
        plot.setInsets(RectangleInsets.ZERO_INSETS);
        plot.setInteriorGap(0.06);
        plot.setStartAngle(0.0);
        plot.setLabelGenerator(null);
        plot.setBaseSectionOutlinePaint((Paint)Color.white);
        plot.setBaseSectionOutlineStroke((Stroke)new BasicStroke(1.2f, 1, 1));
        plot.setOutlineVisible(false);
        plot.setLabelBackgroundPaint(null);
        plot.setLabelOutlinePaint(null);
        plot.setLabelShadowPaint(null);
        plot.setLabelPadding(RectangleInsets.ZERO_INSETS);
        plot.setLabelFont(new Font("Dialog", 0, 12));
        plot.setLabelPaint((Paint)Color.gray);
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator("{2}"));
        return chart;
    }

    private static JFreeChart createPieChart3D() {
        JFreeChart chart = ChartFactory.createPieChart3D(null, null, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderPaint((Paint)Color.white);
        PiePlot3D plot = (PiePlot3D)chart.getPlot();
        plot.setBackgroundPaint(null);
        plot.setInsets(RectangleInsets.ZERO_INSETS);
        plot.setDarkerSides(true);
        plot.setBaseSectionOutlinePaint((Paint)new Color(0, 0, 0, 0));
        plot.setStartAngle(0.0);
        plot.setInteriorGap(0.1);
        plot.setLabelGenerator(null);
        plot.setOutlineVisible(false);
        plot.setLabelBackgroundPaint((Paint)Color.white);
        plot.setLabelOutlinePaint(null);
        plot.setLabelShadowPaint(null);
        plot.setLabelPadding(RectangleInsets.ZERO_INSETS);
        plot.setLabelFont(new Font("Dialog", 0, 12));
        plot.setLabelPaint((Paint)Color.gray);
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator("{2}"));
        return chart;
    }

    private static JFreeChart createLineChart() {
        GXYPlot plot = new GXYPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setBaseShapesVisible(false);
        plot.setRenderer((XYItemRenderer)renderer);
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.removeLegend();
        chart.setBackgroundPaint((Paint)Color.white);
        renderer.setBasePaint((Paint)new Color(0xFF9900));
        renderer.setBaseStroke((Stroke)new BasicStroke(1.5f, 1, 1));
        renderer.setAutoPopulateSeriesPaint(false);
        GValueAxis xAxis = new GValueAxis();
        xAxis.setTickLabelsVisible(false);
        xAxis.setTickMarksVisible(false);
        plot.setDomainAxis((ValueAxis)xAxis);
        GValueAxis yAxis = new GValueAxis();
        yAxis.setTickLabelsVisible(false);
        yAxis.setTickMarksVisible(false);
        plot.setRangeAxis((ValueAxis)yAxis);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        return chart;
    }

    private static JFreeChart createSparklineChart() {
        GXYPlot plot = new GXYPlot();
        plot.setInsets(RectangleInsets.ZERO_INSETS);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setBaseShapesVisible(false);
        plot.setRenderer((XYItemRenderer)renderer);
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.setPadding(RectangleInsets.ZERO_INSETS);
        chart.removeLegend();
        chart.setBackgroundPaint((Paint)Color.white);
        renderer.setBasePaint((Paint)new Color(0xFF9900));
        renderer.setBaseStroke((Stroke)new BasicStroke(1.5f, 1, 1));
        renderer.setAutoPopulateSeriesPaint(false);
        GValueAxis xAxis = new GValueAxis();
        xAxis.setVisible(false);
        plot.setDomainAxis((ValueAxis)xAxis);
        GValueAxis yAxis = new GValueAxis();
        yAxis.setVisible(false);
        plot.setRangeAxis((ValueAxis)yAxis);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        return chart;
    }

    private static JFreeChart createBarChart(PlotOrientation orientation, BarRenderer renderer) {
        GCategoryPlot plot = new GCategoryPlot();
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        chart.setBackgroundPaint((Paint)Color.white);
        plot.setBackgroundPaint(null);
        plot.setRenderer((CategoryItemRenderer)renderer);
        renderer.setBasePaint((Paint)new Color(0xFFCC33));
        renderer.setAutoPopulateSeriesPaint(false);
        GCategoryAxis xAxis = new GCategoryAxis();
        xAxis.setAxisLineVisible(true);
        xAxis.setTickLabelsVisible(false);
        xAxis.setMaximumCategoryLabelLines(5);
        plot.setDomainAxis(xAxis);
        GValueAxis yAxis = new GValueAxis();
        yAxis.setAxisLineVisible(true);
        yAxis.setTickLabelsVisible(false);
        yAxis.setTickMarksVisible(false);
        plot.setRangeAxis((ValueAxis)yAxis);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        return chart;
    }

    private static JFreeChart createBarChart(PlotOrientation orientation) {
        return ChartEngine.createBarChart(orientation, new BarRenderer());
    }

    private static JFreeChart createStackedBarChart(PlotOrientation orientation) {
        return ChartEngine.createBarChart(orientation, (BarRenderer)new StackedBarRenderer());
    }

    private static JFreeChart createBarChart3D(PlotOrientation orientation, BarRenderer renderer) {
        GCategoryPlot plot = new GCategoryPlot();
        plot.setOrientation(orientation);
        if (orientation.equals((Object)PlotOrientation.HORIZONTAL)) {
            plot.setColumnRenderingOrder(SortOrder.DESCENDING);
        }
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        chart.setBackgroundPaint((Paint)Color.white);
        plot.setBackgroundPaint(null);
        plot.setRenderer((CategoryItemRenderer)renderer);
        renderer.setBasePaint((Paint)new Color(0xFFCC33));
        renderer.setAutoPopulateSeriesPaint(false);
        GCategoryAxis3D xAxis = new GCategoryAxis3D();
        xAxis.setAxisLineVisible(true);
        xAxis.setTickLabelsVisible(false);
        xAxis.setMaximumCategoryLabelLines(5);
        plot.setDomainAxis((CategoryAxis)xAxis);
        GValueAxis3D yAxis = new GValueAxis3D();
        yAxis.setAxisLineVisible(true);
        yAxis.setTickLabelsVisible(false);
        yAxis.setTickMarksVisible(false);
        plot.setRangeAxis((ValueAxis)yAxis);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        return chart;
    }

    private static JFreeChart createBarChart3D(PlotOrientation orientation) {
        return ChartEngine.createBarChart3D(orientation, (BarRenderer)new BarRenderer3D());
    }

    private static JFreeChart createStackedBarChart3D(PlotOrientation orientation) {
        return ChartEngine.createBarChart3D(orientation, (BarRenderer)new StackedBarRenderer3D());
    }

    private static JFreeChart createScatterChart() {
        GXYPlot plot = new GXYPlot();
        plot.setBackgroundPaint(null);
        plot.setOutlinePaint(null);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(false, true);
        renderer.setBasePaint((Paint)new Color(7775483));
        renderer.setAutoPopulateSeriesPaint(false);
        plot.setRenderer((XYItemRenderer)renderer);
        GValueAxis xAxis = new GValueAxis();
        xAxis.setTickLabelsVisible(false);
        xAxis.setTickMarksVisible(false);
        plot.setDomainAxis((ValueAxis)xAxis);
        GValueAxis yAxis = new GValueAxis();
        yAxis.setTickLabelsVisible(false);
        yAxis.setTickMarksVisible(false);
        plot.setRangeAxis((ValueAxis)yAxis);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.removeLegend();
        return chart;
    }

    private static void processAxisStr(XYPlot plot, String axisStr, List axes) {
        int xAxisCount = 0;
        int yAxisCount = 0;
        for (int i = 0; i < axisStr.length(); ++i) {
            GValueAxis axis;
            char c = axisStr.charAt(i);
            if (c == 'x') {
                if (xAxisCount == 0) {
                    ValueAxis xAxis = plot.getDomainAxis();
                    xAxis.setTickMarksVisible(true);
                    xAxis.setTickLabelsVisible(true);
                    axes.add(xAxis);
                    ++xAxisCount;
                    continue;
                }
                axis = new GValueAxis();
                axis.setAxisLineVisible(false);
                plot.setDomainAxis(xAxisCount, (ValueAxis)axis);
                plot.setDomainAxisLocation(xAxisCount, AxisLocation.BOTTOM_OR_LEFT);
                axes.add(axis);
                ++xAxisCount;
                continue;
            }
            if (c == 'y') {
                if (yAxisCount == 0) {
                    ValueAxis yAxis = plot.getRangeAxis();
                    yAxis.setTickMarksVisible(true);
                    yAxis.setTickLabelsVisible(true);
                    axes.add(yAxis);
                    ++yAxisCount;
                    continue;
                }
                axis = new GValueAxis();
                axis.setAxisLineVisible(false);
                plot.setRangeAxis(yAxisCount, (ValueAxis)axis);
                plot.setRangeAxisLocation(yAxisCount, AxisLocation.BOTTOM_OR_LEFT);
                axes.add(axis);
                ++yAxisCount;
                continue;
            }
            if (c == 'r') {
                axis = new GValueAxis();
                plot.setRangeAxis(yAxisCount, (ValueAxis)axis);
                plot.setRangeAxisLocation(yAxisCount, AxisLocation.BOTTOM_OR_RIGHT);
                axes.add(axis);
                ++yAxisCount;
                continue;
            }
            if (c == 't') {
                axis = new GValueAxis();
                plot.setDomainAxis(xAxisCount, (ValueAxis)axis);
                plot.setDomainAxisLocation(xAxisCount, AxisLocation.TOP_OR_LEFT);
                axes.add(axis);
                ++xAxisCount;
                continue;
            }
            if (c == ',') continue;
            throw new RuntimeException("Bad character " + c);
        }
    }

    private static void processAxisStrV(CategoryPlot plot, String axisStr, List axes) {
        int xAxisCount = 0;
        int yAxisCount = 0;
        for (int i = 0; i < axisStr.length(); ++i) {
            GLabelledAxis axis;
            char c = axisStr.charAt(i);
            if (c == 'x') {
                if (xAxisCount == 0) {
                    CategoryAxis xAxis = plot.getDomainAxis();
                    xAxis.setTickLabelsVisible(true);
                    axes.add(xAxis);
                    ++xAxisCount;
                    continue;
                }
                axis = new GCategoryAxis();
                axis.setAxisLineVisible(false);
                plot.setDomainAxis(xAxisCount, (CategoryAxis)axis);
                plot.setDomainAxisLocation(xAxisCount, AxisLocation.BOTTOM_OR_LEFT);
                axes.add(axis);
                ++xAxisCount;
                continue;
            }
            if (c == 'y') {
                if (yAxisCount == 0) {
                    ValueAxis yAxis = plot.getRangeAxis();
                    yAxis.setTickLabelsVisible(true);
                    yAxis.setTickMarksVisible(true);
                    axes.add(yAxis);
                    ++yAxisCount;
                    continue;
                }
                axis = new GValueAxis();
                axis.setAxisLineVisible(false);
                plot.setRangeAxis(yAxisCount, (ValueAxis)axis);
                plot.setRangeAxisLocation(yAxisCount, AxisLocation.BOTTOM_OR_LEFT);
                axes.add(axis);
                ++yAxisCount;
                continue;
            }
            if (c == 'r') {
                axis = new GValueAxis();
                plot.setRangeAxis(yAxisCount, (ValueAxis)axis);
                plot.setRangeAxisLocation(yAxisCount, AxisLocation.BOTTOM_OR_RIGHT);
                axes.add(axis);
                ++yAxisCount;
                continue;
            }
            if (c == 't') {
                axis = new GCategoryAxis();
                axis.setAxisLineVisible(false);
                plot.setDomainAxis(xAxisCount, (CategoryAxis)axis);
                plot.setDomainAxisLocation(xAxisCount, AxisLocation.TOP_OR_LEFT);
                axes.add(axis);
                ++xAxisCount;
                continue;
            }
            if (c == ',') continue;
            throw new RuntimeException("Bad character " + c);
        }
    }

    private static void processAxisStrH(CategoryPlot plot, String axisStr, List axes) {
        int xAxisCount = 0;
        int yAxisCount = 0;
        for (int i = 0; i < axisStr.length(); ++i) {
            Object axis;
            char c = axisStr.charAt(i);
            if (c == 'y') {
                if (yAxisCount == 0) {
                    axis = plot.getDomainAxis();
                    axis.setTickLabelsVisible(true);
                    axes.add(axis);
                    ++yAxisCount;
                    continue;
                }
                axis = new GCategoryAxis();
                axis.setAxisLineVisible(false);
                plot.setDomainAxis(yAxisCount, axis);
                plot.setDomainAxisLocation(xAxisCount, AxisLocation.BOTTOM_OR_LEFT);
                axes.add(axis);
                ++yAxisCount;
                continue;
            }
            if (c == 'x') {
                if (xAxisCount == 0) {
                    axis = plot.getRangeAxis();
                    axis.setTickLabelsVisible(true);
                    axis.setTickMarksVisible(true);
                    axes.add(axis);
                    ++xAxisCount;
                    continue;
                }
                axis = new GValueAxis();
                axis.setAxisLineVisible(false);
                plot.setRangeAxis(xAxisCount, (ValueAxis)axis);
                plot.setRangeAxisLocation(xAxisCount, AxisLocation.BOTTOM_OR_LEFT);
                axes.add(axis);
                ++xAxisCount;
                continue;
            }
            if (c == 't') {
                axis = new GValueAxis();
                plot.setRangeAxis(xAxisCount, (ValueAxis)axis);
                plot.setRangeAxisLocation(yAxisCount, AxisLocation.TOP_OR_LEFT);
                axes.add(axis);
                ++xAxisCount;
                continue;
            }
            if (c == 'r') {
                axis = new GCategoryAxis();
                plot.setDomainAxis(yAxisCount, axis);
                plot.setDomainAxisLocation(xAxisCount, AxisLocation.BOTTOM_OR_RIGHT);
                axes.add(axis);
                ++yAxisCount;
                continue;
            }
            if (c == ',') continue;
            throw new RuntimeException("Bad character " + c);
        }
    }

    private static String[] breakString(String text, char separator) {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        ArrayList<String> temp = new ArrayList<String>();
        String current = text;
        int i = current.indexOf(separator);
        while (i != -1) {
            String line = current.substring(0, i);
            temp.add(line);
            current = current.substring(i + 1);
            i = current.indexOf(separator);
        }
        temp.add(current);
        String[] result = new String[temp.size()];
        for (int j = 0; j < temp.size(); ++j) {
            result[j] = (String)temp.get(j);
        }
        return result;
    }

    private static Color parseColor(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument (in parseColor(String)).");
        }
        if (text.length() != 6 && text.length() != 8) {
            throw new IllegalArgumentException("Invalid color representation " + text + ", it should be RRGGBB or RRGGBBAA");
        }
        if (text.length() == 6) {
            return Color.decode("0x" + text);
        }
        int r = Integer.parseInt(text.substring(0, 2), 16);
        int g = Integer.parseInt(text.substring(2, 4), 16);
        int b = Integer.parseInt(text.substring(4, 6), 16);
        int a = Integer.parseInt(text.substring(6, 8), 16);
        return new Color(r, g, b, a);
    }

    private static Color[] parseColors(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument (in parseColors(String)).");
        }
        String[] codes = ChartEngine.breakString(text, ',');
        Color[] result = new Color[codes.length];
        for (int i = 0; i < codes.length; ++i) {
            if (codes[i].length() > 0) {
                String code = ChartEngine.breakString(codes[i], '|')[0];
                result[i] = Color.decode("0x" + code);
                continue;
            }
            result[i] = Color.black;
        }
        return result;
    }

    private static void applyColorsToPiePlot(PiePlot plot, Color[] colors) {
        PieDataset dataset;
        int sectionCount;
        if (colors.length == 1) {
            Color c = colors[0];
            colors = new Color[]{c, new Color(255 - (255 - c.getRed()) / 5, 255 - (255 - c.getGreen()) / 5, 255 - (255 - c.getBlue()) / 5)};
        }
        if (colors.length < (sectionCount = (dataset = plot.getDataset()).getItemCount())) {
            for (int i = 0; i < colors.length - 1; ++i) {
                Color c1 = colors[i];
                Color c2 = colors[i + 1];
                int s1 = ChartEngine.sectionIndexForColor(i, colors.length, sectionCount);
                int s2 = ChartEngine.sectionIndexForColor(i + 1, colors.length, sectionCount);
                for (int s = s1; s <= s2; ++s) {
                    Color c = ChartEngine.interpolatedColor(c1, c2, s - s1, s2 - s1);
                    plot.setSectionPaint(dataset.getKey(s), (Paint)c);
                }
            }
        } else {
            for (int i = 0; i < sectionCount; ++i) {
                plot.setSectionPaint(dataset.getKey(i), (Paint)colors[i]);
            }
        }
    }

    private static int sectionIndexForColor(int item, int itemCount, int sectionCount) {
        return (int)Math.min((double)(sectionCount - 1), (double)(item * sectionCount) / ((double)itemCount - 1.0));
    }

    private static Color interpolatedColor(Color c1, Color c2, int index, int range) {
        if (index == 0) {
            return c1;
        }
        if (index == range) {
            return c2;
        }
        double fraction = ((double)index + 0.0) / (double)range;
        int r1 = c1.getRed();
        int g1 = c1.getGreen();
        int b1 = c1.getBlue();
        int r2 = c2.getRed();
        int g2 = c2.getGreen();
        int b2 = c2.getBlue();
        return new Color((int)((double)r1 + fraction * (double)(r2 - r1)), (int)((double)g1 + fraction * (double)(g2 - g1)), (int)((double)b1 + fraction * (double)(b2 - b1)));
    }

    private static Stroke[] parseLineStyles(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument (in parseStrokes(String)).");
        }
        String[] codes = ChartEngine.breakString(text, '|');
        Stroke[] result = new BasicStroke[codes.length];
        for (int i = 0; i < codes.length; ++i) {
            float width = 1.0f;
            float lineRun = 1.0f;
            float gapRun = 0.0f;
            int pos = codes[i].indexOf(44);
            if (pos == -1) {
                width = Float.parseFloat(codes[i]);
            } else {
                String widthStr = codes[i].substring(0, pos);
                width = Float.parseFloat(widthStr);
                String remaining = codes[i].substring(pos + 1);
                if ((pos = remaining.indexOf(44)) == -1) {
                    gapRun = lineRun = Float.parseFloat(remaining);
                } else {
                    String s1 = remaining.substring(0, pos);
                    lineRun = Float.parseFloat(s1);
                    String s2 = remaining.substring(pos + 1);
                    gapRun = Float.parseFloat(s2);
                }
            }
            result[i] = gapRun <= 0.0f ? new BasicStroke(width, 1, 1) : new BasicStroke(width, 0, 1, 5.0f, new float[]{lineRun, gapRun}, 0.0f);
        }
        return result;
    }

    private static void addMarker(String markerStr, JFreeChart chart) {
        String[] args = ChartEngine.breakString(markerStr, ',');
        Plot p = chart.getPlot();
        Color c = ChartEngine.parseColor(args[1]);
        if ("r".equals(args[0])) {
            float f0 = Float.parseFloat(args[3]);
            float f1 = Float.parseFloat(args[4]);
            if (p instanceof CategoryPlot) {
                CategoryPlot cp = (CategoryPlot)p;
                Range yRange = cp.getRangeAxis().getRange();
                double r0 = yRange.getLowerBound();
                double rl = yRange.getLength();
                IntervalMarker m = new IntervalMarker(r0 + (double)Math.min(f0, f1) * rl, r0 + (double)Math.max(f0, f1) * rl);
                m.setPaint((Paint)c);
                cp.addRangeMarker((Marker)m, Layer.BACKGROUND);
            } else if (p instanceof XYPlot) {
                XYPlot cp = (XYPlot)p;
                Range yRange = cp.getRangeAxis().getRange();
                double r0 = yRange.getLowerBound();
                double rl = yRange.getLength();
                IntervalMarker m = new IntervalMarker(r0 + (double)Math.min(f0, f1) * rl, r0 + (double)Math.max(f0, f1) * rl);
                m.setPaint((Paint)c);
                cp.addRangeMarker((Marker)m, Layer.BACKGROUND);
            }
        } else if ("R".equals(args[0])) {
            float f0 = Float.parseFloat(args[3]);
            float f1 = Float.parseFloat(args[4]);
            if (p instanceof XYPlot) {
                XYPlot xyp = (XYPlot)p;
                Range yRange = xyp.getRangeAxis().getRange();
                double r0 = yRange.getLowerBound();
                double rl = yRange.getLength();
                IntervalMarker m = new IntervalMarker(r0 + (double)Math.min(f0, f1) * rl, r0 + (double)Math.max(f0, f1) * rl);
                m.setPaint((Paint)c);
                xyp.addDomainMarker((Marker)m, Layer.BACKGROUND);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processFillSpec(String spec, JFreeChart chart) {
        if (spec.startsWith("bg")) {
            if ((spec = spec.substring(3)).startsWith("s")) {
                spec = spec.substring(2);
                Color c = ChartEngine.parseColor(spec);
                chart.setBackgroundPaint((Paint)c);
                return;
            } else {
                if (!spec.startsWith("lg")) return;
                spec = spec.substring(3);
                String[] args = ChartEngine.breakString(spec, ',');
                int angle = Integer.parseInt(args[0]);
                Color c0 = ChartEngine.parseColor(args[1]);
                float f0 = Float.parseFloat(args[2]);
                Color c1 = ChartEngine.parseColor(args[3]);
                float f1 = Float.parseFloat(args[4]);
                if (chart.getPlot() instanceof GXYPlot) {
                    GXYPlot gxyplot = (GXYPlot)chart.getPlot();
                    gxyplot.setF0(f0);
                    gxyplot.setF1(f1);
                    gxyplot.setAngle(Math.PI / 180 * (double)angle);
                    gxyplot.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, c0, 0.0f, 0.0f, c1));
                    return;
                } else {
                    if (!(chart.getPlot() instanceof GCategoryPlot)) return;
                    GCategoryPlot gcplot = (GCategoryPlot)chart.getPlot();
                    gcplot.setF0(f0);
                    gcplot.setF1(f1);
                    gcplot.setAngle(Math.PI / 180 * (double)angle);
                    gcplot.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, c0, 0.0f, 0.0f, c1));
                }
            }
            return;
        } else {
            if (!spec.startsWith("c")) throw new RuntimeException("Bad fill specification: " + spec);
            if ((spec = spec.substring(2)).startsWith("s")) {
                spec = spec.substring(2);
                Color c = ChartEngine.parseColor(spec);
                chart.getPlot().setBackgroundPaint((Paint)c);
                return;
            } else {
                if (!spec.startsWith("lg")) throw new RuntimeException("'c' background fill not implemented yet.");
                spec = spec.substring(3);
                String[] args = ChartEngine.breakString(spec, ',');
                int angle = Integer.parseInt(args[0]);
                Color c0 = ChartEngine.parseColor(args[1]);
                float f0 = Float.parseFloat(args[2]);
                Color c1 = ChartEngine.parseColor(args[3]);
                float f1 = Float.parseFloat(args[4]);
                if (chart.getPlot() instanceof GXYPlot) {
                    GXYPlot gxyplot = (GXYPlot)chart.getPlot();
                    gxyplot.setF0(f0);
                    gxyplot.setF1(f1);
                    gxyplot.setAngle(Math.PI / 180 * (double)angle);
                    gxyplot.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, c0, 0.0f, 0.0f, c1));
                    return;
                } else {
                    if (!(chart.getPlot() instanceof GCategoryPlot)) return;
                    GCategoryPlot gcplot = (GCategoryPlot)chart.getPlot();
                    gcplot.setF0(f0);
                    gcplot.setF1(f1);
                    gcplot.setAngle(Math.PI / 180 * (double)angle);
                    gcplot.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, c0, 0.0f, 0.0f, c1));
                }
            }
        }
    }

    private static void processGridLinesSpec(String spec, JFreeChart chart) {
        String[] parts = ChartEngine.breakString(spec, ',');
        double xAxisStepSize = 0.0;
        double yAxisStepSize = 0.0;
        float lineSegLength = 3.0f;
        float blankSegLength = 6.0f;
        if (parts.length > 0) {
            try {
                xAxisStepSize = Double.parseDouble(parts[0]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (parts.length > 1) {
            try {
                yAxisStepSize = Double.parseDouble(parts[1]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (parts.length > 2) {
            try {
                lineSegLength = Float.parseFloat(parts[2]) * 0.85f;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (parts.length > 3) {
            try {
                blankSegLength = Float.parseFloat(parts[3]) * 0.85f;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (lineSegLength == 0.0f && blankSegLength == 0.0f) {
            lineSegLength = 1.0f;
        }
        if (lineSegLength > 0.0f) {
            BasicStroke stroke = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{lineSegLength, blankSegLength}, 0.0f);
            Plot p = chart.getPlot();
            if (p instanceof CategoryPlot) {
                GCategoryPlot plot = (GCategoryPlot)p;
                plot.setDomainGridlinesVisible(true);
                plot.setRangeGridlinesVisible(true);
                plot.setDomainGridlineStroke(stroke);
                plot.setRangeGridlineStroke(stroke);
                plot.setXAxisStepSize(xAxisStepSize / 100.0);
                plot.setYAxisStepSize(yAxisStepSize / 100.0);
            } else if (p instanceof XYPlot) {
                GXYPlot plot = (GXYPlot)p;
                plot.setDomainGridlinesVisible(true);
                plot.setRangeGridlinesVisible(true);
                plot.setDomainGridlineStroke(stroke);
                plot.setRangeGridlineStroke(stroke);
                plot.setXAxisStepSize(xAxisStepSize / 100.0);
                plot.setYAxisStepSize(yAxisStepSize / 100.0);
            }
        }
    }

    public static Dimension parseDimensions(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument (in parseChartDimensions(String)).");
        }
        int splitIndex = text.indexOf(120);
        String xStr = text.substring(0, splitIndex);
        String yStr = text.substring(splitIndex + 1);
        int x = Integer.parseInt(xStr);
        int y = Integer.parseInt(yStr);
        return new Dimension(x, y);
    }

    private static CategoryLabelPositions getCategoryLabelPositions(String orientation) {
        if (orientation.equals("s")) {
            return CategoryLabelPositions.STANDARD;
        }
        if (orientation.equals("u")) {
            return CategoryLabelPositions.UP_90;
        }
        if (orientation.equals("d")) {
            return CategoryLabelPositions.DOWN_90;
        }
        throw new IllegalArgumentException("Axis label orientation '" + orientation + "' not supported.");
    }
}

