/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.eastwood;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;

class GXYPlot
extends XYPlot {
    private double angle = 0.0;
    private double f0 = 0.0;
    private double f1 = 1.0;
    private double xAxisStepSize = 0.0;
    private double yAxisStepSize = 0.0;

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public void setF0(double f0) {
        this.f0 = f0;
    }

    public void setF1(double f1) {
        this.f1 = f1;
    }

    public void setXAxisStepSize(double axisStepSize) {
        this.xAxisStepSize = axisStepSize;
    }

    public void setYAxisStepSize(double axisStepSize) {
        this.yAxisStepSize = axisStepSize;
    }

    public void drawBackground(Graphics2D g2, Rectangle2D area) {
        Paint p = this.getBackgroundPaint();
        if (p instanceof GradientPaint) {
            double y0;
            double x0;
            GradientPaint gp = (GradientPaint)p;
            double x1 = x0 = area.getMinX();
            double y1 = y0 = area.getMaxY();
            double w = area.getWidth();
            double h = area.getHeight();
            if (this.angle <= 0.0) {
                x0 += this.f0 * w;
                x1 += this.f1 * w;
            } else if (this.angle >= 1.5707963267948966) {
                y0 -= this.f0 * h;
                y1 -= this.f1 * h;
            } else {
                double r = Math.sqrt(w * w + h * h);
                x0 += Math.cos(this.angle) * r * this.f0;
                y0 -= Math.sin(this.angle) * r * this.f0;
                x1 += Math.cos(this.angle) * r * this.f1;
                y1 -= Math.sin(this.angle) * r * this.f1;
            }
            Point2D.Double p0 = new Point2D.Double(x0, y0);
            Point2D.Double p1 = new Point2D.Double(x1, y1);
            p = new GradientPaint(p0, gp.getColor1(), p1, gp.getColor2());
        }
        g2.setPaint(p);
        g2.fill(area);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawDomainGridlines(Graphics2D g2, Rectangle2D dataArea, List ticks) {
        if (this.getRenderer() == null) {
            return;
        }
        if (this.isDomainGridlinesVisible() && this.xAxisStepSize > 0.0) {
            ValueAxis axis;
            Stroke gridStroke = this.getDomainGridlineStroke();
            Paint gridPaint = this.getDomainGridlinePaint();
            if (gridStroke != null && gridPaint != null && (axis = this.getDomainAxis()) != null) {
                double lower = axis.getRange().getLowerBound();
                double upper = axis.getRange().getUpperBound();
                for (double x = lower; x <= upper; x += this.xAxisStepSize) {
                    Paint paint = gridPaint;
                    if ((x == lower || x == upper) && gridPaint instanceof Color) {
                        Color c = (Color)gridPaint;
                        paint = new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha() / 3);
                    }
                    try {
                        this.setDomainGridlinePaint(paint);
                        this.getRenderer().drawDomainGridLine(g2, (XYPlot)this, this.getDomainAxis(), dataArea, x);
                        continue;
                    }
                    finally {
                        this.setDomainGridlinePaint(gridPaint);
                    }
                }
            }
        }
    }

    protected void drawRangeGridlines(Graphics2D g2, Rectangle2D area, List ticks) {
        if (this.getRenderer() == null) {
            return;
        }
        if (this.isRangeGridlinesVisible() && this.yAxisStepSize > 0.0) {
            Stroke gridStroke = this.getRangeGridlineStroke();
            Paint gridPaint = this.getRangeGridlinePaint();
            ValueAxis axis = this.getRangeAxis();
            if (axis != null) {
                double lower = axis.getRange().getLowerBound();
                double upper = axis.getRange().getUpperBound();
                for (double y = lower; y <= upper; y += this.yAxisStepSize) {
                    Paint paint = gridPaint;
                    if ((y == lower || y == upper) && gridPaint instanceof Color) {
                        Color c = (Color)gridPaint;
                        paint = new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha() / 3);
                    }
                    this.getRenderer().drawRangeLine(g2, (XYPlot)this, this.getRangeAxis(), area, y, paint, gridStroke);
                }
            }
        }
    }
}

