/*
 * Decompiled with CFR 0.152.
 */
import jAudioFeatureExtractor.ACE.DataTypes.Batch;
import jAudioFeatureExtractor.ACE.XMLParsers.XMLDocumentParser;
import jAudioFeatureExtractor.CommandLineThread;
import jAudioFeatureExtractor.DataModel;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.LinkedList;

public class JAudioCommandLine {
    private static final String usage = "USAGE: " + System.getProperty("line.separator") + "JAudio -s <settings.xml> <destination xml file> <audiofiles>+" + System.getProperty("line.separator") + "JAudio -b <batchfile.xml>";

    public static void execute(String[] args) {
        if (args[0].equals("-b")) {
            File batch = new File(args[1]);
            if (!batch.exists()) {
                System.out.println("Batch file '" + args[1] + "' does not exist");
                System.exit(2);
            } else {
                Object[] o = new Object[]{};
                try {
                    o = (Object[])XMLDocumentParser.parseXMLDocument(args[1], "batchFile");
                }
                catch (Exception e) {
                    System.out.println("Error parsing the batch file");
                    System.out.println(e.getMessage());
                    System.exit(3);
                }
                int i = 0;
                while (i < o.length) {
                    Batch b = (Batch)o[i];
                    DataModel dm = new DataModel("features.xml", null);
                    try {
                        dm.featureKey = new FileOutputStream(new File(b.getDestinationFK()));
                        dm.featureValue = new FileOutputStream(new File(b.getDestinationFV()));
                        b.setDataModel(dm);
                        CommandLineThread clt = new CommandLineThread(b);
                        clt.start();
                        while (clt.isAlive()) {
                            if (System.in.available() > 0) {
                                clt.cancel();
                            }
                            clt.join(1000L);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in execution - skipping this batch (" + b.getName() + ")");
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
        } else if (args[0].equals("-s")) {
            File test;
            if (args.length < 4) {
                System.out.println(usage);
                System.exit(1);
            }
            if (!(test = new File(args[1])).exists()) {
                System.out.println("Settings file '" + args[1] + "' does not exist");
                System.exit(2);
            }
            int i = 3;
            while (i < args.length) {
                boolean good = true;
                File tmp = new File(args[i]);
                if (!tmp.exists()) {
                    System.out.println("ERROR: file " + args[i] + " does not exist.");
                    good = false;
                }
                if (!good) {
                    System.exit(3);
                }
                ++i;
            }
            try {
                JAudioCommandLine.executeSettings(args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println(usage);
            System.exit(1);
        }
    }

    public static void executeSettings(String[] args) throws Exception {
        Object[] data = null;
        try {
            data = (Object[])XMLDocumentParser.parseXMLDocument(args[1], "save_settings");
        }
        catch (Exception e) {
            System.out.println("Error encountered parsing the settings file");
            System.out.println(e.getMessage());
            System.exit(3);
        }
        int windowLength = 512;
        double offset = 0.0;
        try {
            windowLength = Integer.parseInt((String)data[0]);
        }
        catch (NumberFormatException e) {
            System.out.println("Error in settings file");
            System.out.println("Window length of settings must be an integer");
            System.exit(4);
        }
        try {
            offset = Double.parseDouble((String)data[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Error in settings file");
            System.out.println("Window offset of settings must be an double between 0 and 1");
            System.exit(4);
        }
        DataModel dm = new DataModel("features.xml", null);
        double samplingRate = (Double)data[2];
        boolean normalise = (Boolean)data[3];
        boolean saveWindows = (Boolean)data[4];
        boolean saveOverall = (Boolean)data[5];
        String outputName = (String)data[6];
        int outputType = outputName.equals("ACE") ? 0 : 1;
        FileOutputStream destinationFK = null;
        FileOutputStream destinationFV = null;
        if (outputType == 0) {
            destinationFK = new FileOutputStream(new File(String.valueOf(args[2]) + "FK.xml"));
            destinationFV = new FileOutputStream(new File(String.valueOf(args[2]) + "FV.xml"));
        } else {
            destinationFK = new FileOutputStream(new File("definitions.arff"));
            destinationFV = new FileOutputStream(new File(String.valueOf(args[2]) + ".arff"));
        }
        HashMap active = (HashMap)data[7];
        HashMap attribute = (HashMap)data[8];
        String[] aggNames = ((LinkedList)data[9]).toArray(new String[0]);
        String[][] aggFeatures = (String[][])((LinkedList)data[10]).toArray((T[])new String[0][]);
        String[][] aggParameters = (String[][])((LinkedList)data[11]).toArray((T[])new String[0][]);
        RecordingInfo[] recording_info = new RecordingInfo[args.length - 3];
        File[] names = new File[args.length - 3];
        int i = 0;
        while (i < names.length) {
            names[i] = new File(args[i + 3]);
            ++i;
        }
        i = 0;
        while (i < names.length) {
            recording_info[i] = new RecordingInfo(names[i].getName(), names[i].getPath(), null, false);
            ++i;
        }
        try {
            dm.featureKey = destinationFK;
            dm.featureValue = destinationFV;
            Batch b = new Batch();
            b.setDataModel(dm);
            b.setWindowSize(windowLength);
            b.setWindowOverlap(offset);
            b.setSamplingRate(samplingRate);
            b.setNormalise(normalise);
            b.setPerWindow(saveWindows);
            b.setOverall(saveOverall);
            b.setRecording(recording_info);
            b.setOutputType(outputType);
            b.setFeatures(active, attribute);
            b.setAggregators(aggNames, aggFeatures, aggParameters);
            CommandLineThread clt = new CommandLineThread(b);
            clt.start();
            while (clt.isAlive()) {
                if (System.in.available() > 0) {
                    clt.cancel();
                }
                clt.join(1000L);
            }
        }
        catch (Exception e) {
            System.out.println("Error extracting features - aborting");
            System.out.println(e.getMessage());
            System.exit(5);
        }
    }
}

