/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.Timer;
import cern.colt.map.AbstractIntIntMap;
import cern.colt.map.OpenIntIntHashMap;
import cern.colt.map.PrimeFinder;
import cern.colt.map.QuickOpenIntIntHashMap;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;

public class Benchmark {
    protected Benchmark() {
    }

    public static void benchmark(int runs, int size, String kind) {
        System.out.println("initializing...");
        QuickOpenIntIntHashMap map = new QuickOpenIntIntHashMap();
        int i22 = 0;
        while (i22 < size) {
            map.put(i22, i22);
            ++i22;
        }
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i22) {
            // empty catch block
        }
        System.out.println("Now benchmarking...");
        int s = 0;
        Timer timer0 = new Timer();
        Timer timer1 = new Timer();
        Timer timer2 = new Timer();
        int run = runs;
        while (--run >= 0) {
            int i;
            if (kind.equals("add")) {
                map.clear();
                timer0.start();
                i = size;
                while (--i >= 0) {
                    map.put(i, i);
                }
                timer0.stop();
            }
            if (kind.equals("get")) {
                timer0.start();
                i = size;
                while (--i >= 0) {
                    s += map.get(i);
                }
                timer0.stop();
                continue;
            }
            timer1.start();
            map.rehash(PrimeFinder.nextPrime(size * 2));
            timer1.stop();
            timer2.start();
            map.rehash(PrimeFinder.nextPrime((int)((double)size * 1.5)));
            timer2.stop();
        }
        System.out.println("adding: " + timer0);
        System.out.println("growing: " + timer1);
        System.out.println("shrinking: " + timer2);
        System.out.println("total: " + timer1.plus(timer2));
        System.out.print(s);
    }

    public static void main(String[] args) {
        int runs = Integer.parseInt(args[0]);
        int size = Integer.parseInt(args[1]);
        String kind = args[2];
        Benchmark.benchmark(runs, size, kind);
    }

    public static void test2(int length) {
        Uniform uniform = new Uniform(new MersenneTwister());
        int[] keys = new int[length];
        int to = 10000000;
        int i = 0;
        while (i < length) {
            keys[i] = uniform.nextIntFromTo(0, to);
            ++i;
        }
        int[] values = (int[])keys.clone();
        int size = keys.length;
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        int i2 = 0;
        while (i2 < keys.length) {
            ((AbstractIntIntMap)map).put(keys[i2], values[i2]);
            ++i2;
        }
        int sum = 0;
        int i3 = 0;
        while (i3 < keys.length) {
            sum += ((AbstractIntIntMap)map).get(keys[i3]);
            ++i3;
        }
        System.out.println(map);
        System.out.println(sum);
        System.out.println("\n\n");
    }
}

