/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.Timer;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.doublealgo.Transform;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;

class BenchmarkMatrix2D {
    protected BenchmarkMatrix2D() {
        throw new RuntimeException("Non instantiable");
    }

    public static void doubleBenchmark(int runs, int rows, int columns, String kind, boolean print, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int column;
        int row;
        System.out.println("benchmarking double matrix");
        Timer timer1 = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        Timer timer4 = new Timer();
        Timer emptyLoop = new Timer();
        Timer emptyLoop2 = new Timer();
        emptyLoop.start();
        int dummy = 0;
        int i = 0;
        while (i < runs) {
            int column2 = 0;
            while (column2 < columns) {
                int row2 = 0;
                while (row2 < rows) {
                    ++dummy;
                    ++row2;
                }
                ++column2;
            }
            ++i;
        }
        emptyLoop.stop();
        System.out.println(dummy);
        emptyLoop2.start();
        dummy = 3;
        double dummy2 = 0.0;
        int i2 = 0;
        while (i2 < runs) {
            boolean value = false;
            int column3 = 0;
            while (column3 < columns) {
                int row3 = 0;
                while (row3 < rows) {
                    dummy2 += (double)dummy;
                    ++row3;
                }
                ++column3;
            }
            ++i2;
        }
        emptyLoop2.stop();
        System.out.println(dummy2);
        long before = Runtime.getRuntime().freeMemory();
        long size = (long)rows * (long)columns * (long)runs;
        DoubleMatrix2D matrix = null;
        if (kind.equals("sparse")) {
            matrix = new SparseDoubleMatrix2D(rows, columns, initialCapacity, minLoadFactor, maxLoadFactor);
        } else if (kind.equals("dense")) {
            matrix = new DenseDoubleMatrix2D(rows, columns);
        } else {
            throw new RuntimeException("unknown kind");
        }
        System.out.println("\nNow filling...");
        int i222 = 0;
        while (i222 < runs) {
            matrix.assign(0.0);
            matrix.ensureCapacity(initialCapacity);
            if (kind.equals("sparse")) {
                ((SparseDoubleMatrix2D)matrix).ensureCapacity(initialCapacity);
            }
            timer1.start();
            int value = 0;
            int row4 = 0;
            while (row4 < rows) {
                int column4 = 0;
                while (column4 < columns) {
                    matrix.setQuick(row4, column4, value++);
                    ++column4;
                }
                ++row4;
            }
            timer1.stop();
            ++i222;
        }
        timer1.display();
        timer1.minus(emptyLoop).display();
        System.out.println(String.valueOf((float)size / timer1.minus(emptyLoop).seconds()) + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i222) {
            // empty catch block
        }
        long after = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (before - after) / 1024L);
        System.out.println("bytes needed per non-zero=" + (double)(before - after) / (double)matrix.cardinality());
        if (print) {
            System.out.println(matrix);
            if (kind.equals("sparse")) {
                System.out.println("map=" + ((SparseDoubleMatrix2D)matrix).elements);
            }
        }
        System.out.println("\nNow reading...");
        timer2.start();
        double element = 0.0;
        int i3 = 0;
        while (i3 < runs) {
            int row5 = 0;
            while (row5 < rows) {
                int column5 = 0;
                while (column5 < columns) {
                    element += matrix.getQuick(row5, column5);
                    ++column5;
                }
                ++row5;
            }
            ++i3;
        }
        timer2.stop().display();
        timer2.minus(emptyLoop2).display();
        System.out.println(String.valueOf((float)size / timer2.minus(emptyLoop2).seconds()) + " elements / sec");
        if (print) {
            System.out.println(matrix);
        }
        System.out.println(element);
        System.out.println("\nNow reading view...");
        DoubleMatrix2D view = matrix.viewPart(0, 0, rows, columns);
        timer4.start();
        element = 0.0;
        int i4 = 0;
        while (i4 < runs) {
            row = 0;
            while (row < rows) {
                column = 0;
                while (column < columns) {
                    element += view.getQuick(row, column);
                    ++column;
                }
                ++row;
            }
            ++i4;
        }
        timer4.stop().display();
        timer4.minus(emptyLoop2).display();
        System.out.println(String.valueOf((float)size / timer4.minus(emptyLoop2).seconds()) + " elements / sec");
        if (print) {
            System.out.println(view);
        }
        System.out.println(element);
        System.out.println("\nNow removing...");
        before = Runtime.getRuntime().freeMemory();
        i4 = 0;
        while (i4 < runs) {
            row = 0;
            while (row < rows) {
                column = 0;
                while (column < columns) {
                    matrix.setQuick(row, column, 1.0);
                    ++column;
                }
                ++row;
            }
            timer3.start();
            row = 0;
            while (row < rows) {
                column = 0;
                while (column < columns) {
                    matrix.setQuick(row, column, 0.0);
                    ++column;
                }
                ++row;
            }
            timer3.stop();
            ++i4;
        }
        timer3.display();
        timer3.minus(emptyLoop).display();
        System.out.println(String.valueOf((float)size / timer3.minus(emptyLoop).seconds()) + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        after = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (before - after) / 1024L);
        System.out.println("KB free=" + after / 1024L);
        if (print) {
            System.out.println(matrix);
        }
        System.out.println("bye bye.");
    }

    public static void doubleBenchmarkMult(int runs, int rows, int columns, String kind, boolean print, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        System.out.println("benchmarking double matrix");
        Timer timer1 = new Timer();
        Timer timer2 = new Timer();
        long size = (long)rows * (long)columns * (long)runs;
        DoubleMatrix2D matrix = null;
        if (kind.equals("sparse")) {
            matrix = new SparseDoubleMatrix2D(rows, columns, initialCapacity, minLoadFactor, maxLoadFactor);
        } else if (kind.equals("dense")) {
            matrix = new DenseDoubleMatrix2D(rows, columns);
        } else {
            throw new RuntimeException("unknown kind");
        }
        System.out.println("\nNow multiplying...");
        matrix.assign(1.0);
        int i = 0;
        while (i < runs) {
            timer1.start();
            Transform.mult(matrix, 3.0);
            timer1.stop();
            ++i;
        }
        timer1.display();
        System.out.println(String.valueOf((float)size / timer1.seconds()) + " elements / sec");
        if (print) {
            System.out.println(matrix);
        }
        System.out.println("\nNow multiplying2...");
        matrix.assign(1.0);
        i = 0;
        while (i < runs) {
            timer2.start();
            Transform.mult(matrix, 3.0);
            timer2.stop();
            ++i;
        }
        timer2.display();
        System.out.println(String.valueOf((float)size / timer2.seconds()) + " elements / sec");
        if (print) {
            System.out.println(matrix);
        }
        System.out.println("bye bye.");
    }

    public static void doubleBenchmarkPrimitive(int runs, int rows, int columns, boolean print) {
        int row;
        int column;
        Timer timer1 = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        Timer emptyLoop = new Timer();
        Timer emptyLoop2 = new Timer();
        emptyLoop.start();
        int dummy = 0;
        int i = 0;
        while (i < runs) {
            int column2 = 0;
            while (column2 < columns) {
                int row2 = 0;
                while (row2 < rows) {
                    ++dummy;
                    ++row2;
                }
                ++column2;
            }
            ++i;
        }
        emptyLoop.stop();
        System.out.println(dummy);
        emptyLoop2.start();
        dummy = 3;
        double dummy2 = 0.0;
        int i2 = 0;
        while (i2 < runs) {
            int column3 = 0;
            while (column3 < columns) {
                int row3 = 0;
                while (row3 < rows) {
                    dummy2 += (double)dummy;
                    ++row3;
                }
                ++column3;
            }
            ++i2;
        }
        emptyLoop2.stop();
        System.out.println(dummy2);
        long before = Runtime.getRuntime().freeMemory();
        long size = (long)rows * (long)columns * (long)runs;
        double[][] matrix = new double[rows][columns];
        System.out.println("\nNow filling...");
        int i222 = 0;
        while (i222 < runs) {
            timer1.start();
            int value = 0;
            int column4 = 0;
            while (column4 < columns) {
                int row4 = 0;
                while (row4 < rows) {
                    matrix[row4][column4] = value++;
                    ++row4;
                }
                ++column4;
            }
            timer1.stop();
            ++i222;
        }
        timer1.display();
        timer1.minus(emptyLoop).display();
        System.out.println(String.valueOf((float)size / timer1.minus(emptyLoop).seconds()) + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i222) {
            // empty catch block
        }
        long after = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (before - after) / 1024L);
        if (print) {
            DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, columns);
            m.assign(matrix);
            System.out.println(m);
        }
        System.out.println("\nNow reading...");
        timer2.start();
        double element = 0.0;
        int i3 = 0;
        while (i3 < runs) {
            column = 0;
            while (column < columns) {
                row = 0;
                while (row < rows) {
                    element += matrix[row][column];
                    ++row;
                }
                ++column;
            }
            ++i3;
        }
        timer2.stop().display();
        timer2.minus(emptyLoop2).display();
        System.out.println(String.valueOf((float)size / timer2.minus(emptyLoop2).seconds()) + " elements / sec");
        if (print) {
            DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, columns);
            m.assign(matrix);
            System.out.println(m);
        }
        System.out.println(element);
        System.out.println("\nNow removing...");
        before = Runtime.getRuntime().freeMemory();
        i32 = 0;
        while (i32 < runs) {
            timer3.start();
            column = 0;
            while (column < columns) {
                row = 0;
                while (row < rows) {
                    matrix[row][column] = 0.0;
                    ++row;
                }
                ++column;
            }
            timer3.stop();
            ++i32;
        }
        timer3.display();
        timer3.minus(emptyLoop).display();
        System.out.println(String.valueOf((float)size / timer3.minus(emptyLoop).seconds()) + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i32) {
            // empty catch block
        }
        after = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (before - after) / 1024L);
        System.out.println("KB free=" + after / 1024L);
        if (print) {
            DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, columns);
            m.assign(matrix);
            System.out.println(m);
        }
        System.out.println("bye bye.");
    }

    public static void doubleBenchmarkPrimitiveOptimized(int runs, int rows, int columns, boolean print) {
        int column;
        double[] r;
        int row;
        Timer timer1 = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        Timer emptyLoop = new Timer();
        Timer emptyLoop2 = new Timer();
        emptyLoop.start();
        int dummy = 0;
        int i = 0;
        while (i < runs) {
            int column2 = 0;
            while (column2 < columns) {
                int row2 = 0;
                while (row2 < rows) {
                    ++dummy;
                    ++row2;
                }
                ++column2;
            }
            ++i;
        }
        emptyLoop.stop();
        System.out.println(dummy);
        emptyLoop2.start();
        dummy = 3;
        double dummy2 = 0.0;
        int i2 = 0;
        while (i2 < runs) {
            int column3 = 0;
            while (column3 < columns) {
                int row3 = 0;
                while (row3 < rows) {
                    dummy2 += (double)dummy;
                    ++row3;
                }
                ++column3;
            }
            ++i2;
        }
        emptyLoop2.stop();
        System.out.println(dummy2);
        long before = Runtime.getRuntime().freeMemory();
        long size = (long)rows * (long)columns * (long)runs;
        double[][] matrix = new double[rows][columns];
        System.out.println("\nNow filling...");
        int i222 = 0;
        while (i222 < runs) {
            timer1.start();
            int value = 0;
            int row4 = 0;
            while (row4 < rows) {
                double[] r2 = matrix[row4];
                int column4 = 0;
                while (column4 < columns) {
                    r2[column4] = value++;
                    ++column4;
                }
                ++row4;
            }
            timer1.stop();
            ++i222;
        }
        timer1.display();
        timer1.minus(emptyLoop).display();
        System.out.println(String.valueOf((float)size / timer1.minus(emptyLoop).seconds()) + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i222) {
            // empty catch block
        }
        long after = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (before - after) / 1024L);
        if (print) {
            DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, columns);
            m.assign(matrix);
            System.out.println(m);
        }
        System.out.println("\nNow reading...");
        timer2.start();
        double element = 0.0;
        int i3 = 0;
        while (i3 < runs) {
            row = 0;
            while (row < rows) {
                r = matrix[row];
                column = 0;
                while (column < columns) {
                    element += r[column];
                    ++column;
                }
                ++row;
            }
            ++i3;
        }
        timer2.stop().display();
        timer2.minus(emptyLoop2).display();
        System.out.println(String.valueOf((float)size / timer2.minus(emptyLoop2).seconds()) + " elements / sec");
        if (print) {
            DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, columns);
            m.assign(matrix);
            System.out.println(m);
        }
        System.out.println(element);
        System.out.println("\nNow removing...");
        before = Runtime.getRuntime().freeMemory();
        i32 = 0;
        while (i32 < runs) {
            timer3.start();
            row = 0;
            while (row < rows) {
                r = matrix[row];
                column = 0;
                while (column < columns) {
                    r[column] = 0.0;
                    ++column;
                }
                ++row;
            }
            timer3.stop();
            ++i32;
        }
        timer3.display();
        timer3.minus(emptyLoop).display();
        System.out.println(String.valueOf((float)size / timer3.minus(emptyLoop).seconds()) + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i32) {
            // empty catch block
        }
        after = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (before - after) / 1024L);
        System.out.println("KB free=" + after / 1024L);
        if (print) {
            DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, columns);
            m.assign(matrix);
            System.out.println(m);
        }
        System.out.println("bye bye.");
    }

    public static void intBenchmark(int runs, int rows, int columns, String kind, boolean print, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        throw new InternalError();
    }

    public static void intBenchmarkPrimitive(int runs, int rows, int columns, boolean print) {
        throw new InternalError();
    }

    public static void intBenchmarkPrimitiveOptimized(int runs, int rows, int columns, boolean print) {
        throw new InternalError();
    }

    public static void main(String[] args) {
        int runs = Integer.parseInt(args[0]);
        int rows = Integer.parseInt(args[1]);
        int columns = Integer.parseInt(args[2]);
        String kind = args[3];
        int initialCapacity = Integer.parseInt(args[4]);
        double minLoadFactor = new Double(args[5]);
        double maxLoadFactor = new Double(args[6]);
        boolean print = args[7].equals("print");
        String type = args[8];
        String command = args[9];
        if (type.equals("int")) {
            if (kind.equals("primitive")) {
                BenchmarkMatrix2D.intBenchmarkPrimitive(runs, rows, columns, print);
            } else if (kind.equals("primitiveOpt")) {
                BenchmarkMatrix2D.intBenchmarkPrimitiveOptimized(runs, rows, columns, print);
            } else {
                BenchmarkMatrix2D.intBenchmark(runs, rows, columns, kind, print, initialCapacity, minLoadFactor, maxLoadFactor);
            }
        } else if (type.equals("double")) {
            if (kind.equals("primitive")) {
                BenchmarkMatrix2D.doubleBenchmarkPrimitive(runs, rows, columns, print);
            } else if (kind.equals("primitiveOpt")) {
                BenchmarkMatrix2D.doubleBenchmarkPrimitiveOptimized(runs, rows, columns, print);
            } else if (command.equals("mult")) {
                BenchmarkMatrix2D.doubleBenchmarkMult(runs, rows, columns, kind, print, initialCapacity, minLoadFactor, maxLoadFactor);
            } else {
                BenchmarkMatrix2D.doubleBenchmark(runs, rows, columns, kind, print, initialCapacity, minLoadFactor, maxLoadFactor);
            }
        }
    }
}

