/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.GenericPermuting;
import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.IntComparator;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.colt.matrix.linalg.Diagonal;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import cern.colt.matrix.linalg.LUDecomposition;
import cern.colt.matrix.linalg.Property;
import cern.colt.matrix.linalg.QRDecomposition;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import cern.jet.math.Functions;

public class Algebra
extends PersistentObject {
    public static final Algebra DEFAULT = new Algebra();
    public static final Algebra ZERO;
    protected Property property;

    static {
        Algebra.DEFAULT.property = Property.DEFAULT;
        ZERO = new Algebra();
        Algebra.ZERO.property = Property.ZERO;
    }

    public Algebra() {
        this(Property.DEFAULT.tolerance());
    }

    public Algebra(double tolerance) {
        this.setProperty(new Property(tolerance));
    }

    private CholeskyDecomposition chol(DoubleMatrix2D matrix) {
        return new CholeskyDecomposition(matrix);
    }

    @Override
    public Object clone() {
        return new Algebra(this.property.tolerance());
    }

    public double cond(DoubleMatrix2D A) {
        return this.svd(A).cond();
    }

    public double det(DoubleMatrix2D A) {
        return this.lu(A).det();
    }

    private EigenvalueDecomposition eig(DoubleMatrix2D matrix) {
        return new EigenvalueDecomposition(matrix);
    }

    protected static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    protected static DoubleDoubleFunction hypotFunction() {
        return new DoubleDoubleFunction(){

            @Override
            public final double apply(double a, double b) {
                return Algebra.hypot(a, b);
            }
        };
    }

    public DoubleMatrix2D inverse(DoubleMatrix2D A) {
        if (this.property.isSquare(A) && this.property.isDiagonal(A)) {
            DoubleMatrix2D inv = A.copy();
            boolean isNonSingular = Diagonal.inverse(inv);
            if (!isNonSingular) {
                throw new IllegalArgumentException("A is singular.");
            }
            return inv;
        }
        return this.solve(A, DoubleFactory2D.dense.identity(A.rows()));
    }

    private LUDecomposition lu(DoubleMatrix2D matrix) {
        return new LUDecomposition(matrix);
    }

    public double mult(DoubleMatrix1D x, DoubleMatrix1D y) {
        return x.zDotProduct(y);
    }

    public DoubleMatrix1D mult(DoubleMatrix2D A, DoubleMatrix1D y) {
        return A.zMult(y, null);
    }

    public DoubleMatrix2D mult(DoubleMatrix2D A, DoubleMatrix2D B) {
        return A.zMult(B, null);
    }

    public DoubleMatrix2D multOuter(DoubleMatrix1D x, DoubleMatrix1D y, DoubleMatrix2D A) {
        int rows = x.size();
        int columns = y.size();
        if (A == null) {
            A = x.like2D(rows, columns);
        }
        if (A.rows() != rows || A.columns() != columns) {
            throw new IllegalArgumentException();
        }
        int row = rows;
        while (--row >= 0) {
            A.viewRow(row).assign(y);
        }
        int column = columns;
        while (--column >= 0) {
            A.viewColumn(column).assign(x, Functions.mult);
        }
        return A;
    }

    public double norm1(DoubleMatrix1D x) {
        if (x.size() == 0) {
            return 0.0;
        }
        return x.aggregate(Functions.plus, Functions.abs);
    }

    public double norm1(DoubleMatrix2D A) {
        double max = 0.0;
        int column = A.columns();
        while (--column >= 0) {
            max = Math.max(max, this.norm1(A.viewColumn(column)));
        }
        return max;
    }

    public double norm2(DoubleMatrix1D x) {
        return this.mult(x, x);
    }

    public double norm2(DoubleMatrix2D A) {
        return this.svd(A).norm2();
    }

    public double normF(DoubleMatrix2D A) {
        if (A.size() == 0) {
            return 0.0;
        }
        return A.aggregate(Algebra.hypotFunction(), Functions.identity);
    }

    public double normInfinity(DoubleMatrix1D x) {
        if (x.size() == 0) {
            return 0.0;
        }
        return x.aggregate(Functions.max, Functions.abs);
    }

    public double normInfinity(DoubleMatrix2D A) {
        double max = 0.0;
        int row = A.rows();
        while (--row >= 0) {
            max = Math.max(max, this.norm1(A.viewRow(row)));
        }
        return max;
    }

    public DoubleMatrix1D permute(DoubleMatrix1D A, int[] indexes, double[] work) {
        int size = A.size();
        if (indexes.length != size) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        if (work == null || size > work.length) {
            work = A.toArray();
        } else {
            A.toArray(work);
        }
        int i = size;
        while (--i >= 0) {
            A.setQuick(i, work[indexes[i]]);
        }
        return A;
    }

    public DoubleMatrix2D permute(DoubleMatrix2D A, int[] rowIndexes, int[] columnIndexes) {
        return A.viewSelection(rowIndexes, columnIndexes);
    }

    public DoubleMatrix2D permuteColumns(DoubleMatrix2D A, int[] indexes, int[] work) {
        return this.permuteRows(A.viewDice(), indexes, work);
    }

    public DoubleMatrix2D permuteRows(final DoubleMatrix2D A, int[] indexes, int[] work) {
        int size = A.rows();
        if (indexes.length != size) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        int columns = A.columns();
        if (columns < size / 10) {
            double[] doubleWork = new double[size];
            int j = A.columns();
            while (--j >= 0) {
                this.permute(A.viewColumn(j), indexes, doubleWork);
            }
            return A;
        }
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                A.viewRow(a).swap(A.viewRow(b));
            }
        };
        GenericPermuting.permute(indexes, swapper, work, null);
        return A;
    }

    public DoubleMatrix2D pow(DoubleMatrix2D A, int p) {
        DoubleMatrix2D B = A.copy();
        int i = 0;
        while (i < p - 1) {
            B = this.mult(B, A);
            ++i;
        }
        return B;
    }

    public Property property() {
        return this.property;
    }

    private QRDecomposition qr(DoubleMatrix2D matrix) {
        return new QRDecomposition(matrix);
    }

    public int rank(DoubleMatrix2D A) {
        return this.svd(A).rank();
    }

    public void setProperty(Property property) {
        if (this == DEFAULT && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = property;
    }

    public DoubleMatrix2D solve(DoubleMatrix2D A, DoubleMatrix2D B) {
        return A.rows() == A.columns() ? this.lu(A).solve(B) : this.qr(A).solve(B);
    }

    public DoubleMatrix2D solveTranspose(DoubleMatrix2D A, DoubleMatrix2D B) {
        return this.solve(this.transpose(A), this.transpose(B));
    }

    private DoubleMatrix2D subMatrix(DoubleMatrix2D A, int[] rowIndexes, int columnFrom, int columnTo) {
        int width = columnTo - columnFrom + 1;
        int rows = A.rows();
        A = A.viewPart(0, columnFrom, rows, width);
        DoubleMatrix2D sub = A.like(rowIndexes.length, width);
        int r = rowIndexes.length;
        while (--r >= 0) {
            int row = rowIndexes[r];
            if (row < 0 || row >= rows) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            sub.viewRow(r).assign(A.viewRow(row));
        }
        return sub;
    }

    private DoubleMatrix2D subMatrix(DoubleMatrix2D A, int rowFrom, int rowTo, int[] columnIndexes) {
        if (rowTo - rowFrom >= A.rows()) {
            throw new IndexOutOfBoundsException("Too many rows");
        }
        int height = rowTo - rowFrom + 1;
        int columns = A.columns();
        A = A.viewPart(rowFrom, 0, height, columns);
        DoubleMatrix2D sub = A.like(height, columnIndexes.length);
        int c = columnIndexes.length;
        while (--c >= 0) {
            int column = columnIndexes[c];
            if (column < 0 || column >= columns) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            sub.viewColumn(c).assign(A.viewColumn(column));
        }
        return sub;
    }

    public DoubleMatrix2D subMatrix(DoubleMatrix2D A, int fromRow, int toRow, int fromColumn, int toColumn) {
        return A.viewPart(fromRow, fromColumn, toRow - fromRow + 1, toColumn - fromColumn + 1);
    }

    private SingularValueDecomposition svd(DoubleMatrix2D matrix) {
        return new SingularValueDecomposition(matrix);
    }

    public String toString(DoubleMatrix2D matrix) {
        final ObjectArrayList names = new ObjectArrayList();
        final ObjectArrayList values = new ObjectArrayList();
        String unknown = "Illegal operation or error: ";
        names.add("cond");
        try {
            values.add(String.valueOf(this.cond(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("det");
        try {
            values.add(String.valueOf(this.det(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("norm1");
        try {
            values.add(String.valueOf(this.norm1(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("norm2");
        try {
            values.add(String.valueOf(this.norm2(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("normF");
        try {
            values.add(String.valueOf(this.normF(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("normInfinity");
        try {
            values.add(String.valueOf(this.normInfinity(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("rank");
        try {
            values.add(String.valueOf(this.rank(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("trace");
        try {
            values.add(String.valueOf(this.trace(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return Property.get(names, a).compareTo(Property.get(names, b));
            }
        };
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                Object tmp = names.get(a);
                names.set(a, names.get(b));
                names.set(b, tmp);
                tmp = values.get(a);
                values.set(a, values.get(b));
                values.set(b, tmp);
            }
        };
        GenericSorting.quickSort(0, names.size(), comp, swapper);
        int maxLength = 0;
        int i = 0;
        while (i < names.size()) {
            int length = ((String)names.get(i)).length();
            maxLength = Math.max(length, maxLength);
            ++i;
        }
        StringBuffer buf = new StringBuffer();
        int i2 = 0;
        while (i2 < names.size()) {
            String name = (String)names.get(i2);
            buf.append(name);
            buf.append(Property.blanks(maxLength - name.length()));
            buf.append(" : ");
            buf.append(values.get(i2));
            if (i2 < names.size() - 1) {
                buf.append('\n');
            }
            ++i2;
        }
        return buf.toString();
    }

    public String toVerboseString(DoubleMatrix2D matrix) {
        String constructionException = "Illegal operation or error upon construction of ";
        StringBuffer buf = new StringBuffer();
        buf.append("A = ");
        buf.append(matrix);
        buf.append("\n\n" + this.toString(matrix));
        buf.append("\n\n" + Property.DEFAULT.toString(matrix));
        LUDecomposition lu = null;
        try {
            lu = new LUDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " LUDecomposition: " + exc.getMessage());
        }
        if (lu != null) {
            buf.append("\n\n" + lu.toString());
        }
        QRDecomposition qr = null;
        try {
            qr = new QRDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " QRDecomposition: " + exc.getMessage());
        }
        if (qr != null) {
            buf.append("\n\n" + qr.toString());
        }
        CholeskyDecomposition chol = null;
        try {
            chol = new CholeskyDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " CholeskyDecomposition: " + exc.getMessage());
        }
        if (chol != null) {
            buf.append("\n\n" + chol.toString());
        }
        EigenvalueDecomposition eig = null;
        try {
            eig = new EigenvalueDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " EigenvalueDecomposition: " + exc.getMessage());
        }
        if (eig != null) {
            buf.append("\n\n" + eig.toString());
        }
        SingularValueDecomposition svd = null;
        try {
            svd = new SingularValueDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " SingularValueDecomposition: " + exc.getMessage());
        }
        if (svd != null) {
            buf.append("\n\n" + svd.toString());
        }
        return buf.toString();
    }

    public double trace(DoubleMatrix2D A) {
        double sum = 0.0;
        int i = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            sum += A.getQuick(i, i);
        }
        return sum;
    }

    public DoubleMatrix2D transpose(DoubleMatrix2D A) {
        return A.viewDice();
    }

    protected DoubleMatrix2D trapezoidalLower(DoubleMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int r = rows;
        while (--r >= 0) {
            int c = columns;
            while (--c >= 0) {
                if (r >= c) continue;
                A.setQuick(r, c, 0.0);
            }
        }
        return A;
    }

    private DoubleMatrix2D xmultOuter(DoubleMatrix1D x, DoubleMatrix1D y) {
        DoubleMatrix2D A = x.like2D(x.size(), y.size());
        this.multOuter(x, y, A);
        return A;
    }

    private DoubleMatrix2D xpowSlow(DoubleMatrix2D A, int k) {
        DoubleMatrix2D result = A.copy();
        int i = 0;
        while (i < k - 1) {
            result = this.mult(result, A);
            ++i;
        }
        return result;
    }
}

