/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import hep.aida.bin.DynamicBin1D;
import hep.aida.bin.QuantileBin1D;
import java.text.DecimalFormat;
import java.util.Date;

public class Quantile1Test {
    public static void main(String[] argv) {
        int numExamples = 0;
        try {
            numExamples = Integer.parseInt(argv[0]);
        }
        catch (Exception e) {
            System.err.println("Unable to parse input line count argument");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.out.println("Got numExamples=" + numExamples);
        long N = 0L;
        try {
            N = argv[1].equals("L") ? Long.MAX_VALUE : (argv[1].equals("I") ? Integer.MAX_VALUE : Long.parseLong(argv[1]));
        }
        catch (Exception e) {
            System.err.println("Error parsing flag for N");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.out.println("Got N=" + N);
        DRand rand = new DRand(new Date());
        QuantileBin1D qAccum = new QuantileBin1D(false, N, 1.0E-4, 0.001, 200, rand, false, false, 2);
        DynamicBin1D dbin = new DynamicBin1D();
        Uniform dataRand = new Uniform(new DRand(7757));
        int i = 1;
        while (i <= numExamples) {
            double gauss = dataRand.nextDouble();
            qAccum.add(gauss);
            dbin.add(gauss);
            ++i;
        }
        DecimalFormat fmt = new DecimalFormat("0.00");
        System.out.println();
        int step = 10;
        int i2 = 1;
        while (i2 < 100) {
            double percent = (double)i2 * 0.01;
            double quantile = qAccum.quantile(percent);
            System.out.println(String.valueOf(fmt.format(percent)) + "  " + quantile + ",  " + dbin.quantile(percent) + ",  " + (dbin.quantile(percent) - quantile));
            i2 += step;
        }
    }
}

