/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.bin;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import hep.aida.bin.AbstractBin1D;
import hep.aida.bin.StaticBin1D;

public class MightyStaticBin1D
extends StaticBin1D {
    protected boolean hasSumOfLogarithms = false;
    protected double sumOfLogarithms = 0.0;
    protected boolean hasSumOfInversions = false;
    protected double sumOfInversions = 0.0;
    protected double[] sumOfPowers = null;

    public MightyStaticBin1D() {
        this(false, false, 4);
    }

    public MightyStaticBin1D(boolean hasSumOfLogarithms, boolean hasSumOfInversions, int maxOrderForSumOfPowers) {
        this.setMaxOrderForSumOfPowers(maxOrderForSumOfPowers);
        this.hasSumOfLogarithms = hasSumOfLogarithms;
        this.hasSumOfInversions = hasSumOfInversions;
        this.clear();
    }

    @Override
    public synchronized void addAllOfFromTo(DoubleArrayList list, int from, int to) {
        super.addAllOfFromTo(list, from, to);
        if (this.sumOfPowers != null) {
            Descriptive.incrementalUpdateSumsOfPowers(list, from, to, 3, this.getMaxOrderForSumOfPowers(), this.sumOfPowers);
        }
        if (this.hasSumOfInversions) {
            this.sumOfInversions += Descriptive.sumOfInversions(list, from, to);
        }
        if (this.hasSumOfLogarithms) {
            this.sumOfLogarithms += Descriptive.sumOfLogarithms(list, from, to);
        }
    }

    @Override
    protected void clearAllMeasures() {
        super.clearAllMeasures();
        this.sumOfLogarithms = 0.0;
        this.sumOfInversions = 0.0;
        if (this.sumOfPowers != null) {
            int i = this.sumOfPowers.length;
            while (--i >= 0) {
                this.sumOfPowers[i] = 0.0;
            }
        }
    }

    @Override
    public synchronized Object clone() {
        MightyStaticBin1D clone = (MightyStaticBin1D)super.clone();
        if (this.sumOfPowers != null) {
            clone.sumOfPowers = (double[])clone.sumOfPowers.clone();
        }
        return clone;
    }

    @Override
    public String compareWith(AbstractBin1D other) {
        StringBuffer buf = new StringBuffer(super.compareWith(other));
        if (other instanceof MightyStaticBin1D) {
            MightyStaticBin1D m = (MightyStaticBin1D)other;
            if (this.hasSumOfLogarithms() && m.hasSumOfLogarithms()) {
                buf.append("geometric mean: " + this.relError(this.geometricMean(), m.geometricMean()) + " %\n");
            }
            if (this.hasSumOfInversions() && m.hasSumOfInversions()) {
                buf.append("harmonic mean: " + this.relError(this.harmonicMean(), m.harmonicMean()) + " %\n");
            }
            if (this.hasSumOfPowers(3) && m.hasSumOfPowers(3)) {
                buf.append("skew: " + this.relError(this.skew(), m.skew()) + " %\n");
            }
            if (this.hasSumOfPowers(4) && m.hasSumOfPowers(4)) {
                buf.append("kurtosis: " + this.relError(this.kurtosis(), m.kurtosis()) + " %\n");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public synchronized double geometricMean() {
        return Descriptive.geometricMean(this.size(), this.sumOfLogarithms());
    }

    public synchronized int getMaxOrderForSumOfPowers() {
        if (this.sumOfPowers == null) {
            return 2;
        }
        return 2 + this.sumOfPowers.length;
    }

    public synchronized int getMinOrderForSumOfPowers() {
        int minOrder = 0;
        if (this.hasSumOfInversions()) {
            minOrder = -1;
        }
        return minOrder;
    }

    public synchronized double harmonicMean() {
        return Descriptive.harmonicMean(this.size(), this.sumOfInversions());
    }

    public boolean hasSumOfInversions() {
        return this.hasSumOfInversions;
    }

    public boolean hasSumOfLogarithms() {
        return this.hasSumOfLogarithms;
    }

    public boolean hasSumOfPowers(int k) {
        return this.getMinOrderForSumOfPowers() <= k && k <= this.getMaxOrderForSumOfPowers();
    }

    public synchronized double kurtosis() {
        return Descriptive.kurtosis(this.moment(4, this.mean()), this.standardDeviation());
    }

    public synchronized double moment(int k, double c) {
        if (k < 0) {
            throw new IllegalArgumentException("k must be >= 0");
        }
        if (!this.hasSumOfPowers(k)) {
            return Double.NaN;
        }
        int maxOrder = Math.min(k, this.getMaxOrderForSumOfPowers());
        DoubleArrayList sumOfPows = new DoubleArrayList(maxOrder + 1);
        sumOfPows.add(this.size());
        sumOfPows.add(this.sum());
        sumOfPows.add(this.sumOfSquares());
        int i = 3;
        while (i <= maxOrder) {
            sumOfPows.add(this.sumOfPowers(i));
            ++i;
        }
        return Descriptive.moment(k, c, this.size(), sumOfPows.elements());
    }

    public double product() {
        return Descriptive.product(this.size(), this.sumOfLogarithms());
    }

    protected void setMaxOrderForSumOfPowers(int max_k) {
        this.sumOfPowers = (double[])(max_k <= 2 ? null : new double[max_k - 2]);
    }

    public synchronized double skew() {
        return Descriptive.skew(this.moment(3, this.mean()), this.standardDeviation());
    }

    public double sumOfInversions() {
        if (!this.hasSumOfInversions) {
            return Double.NaN;
        }
        return this.sumOfInversions;
    }

    public synchronized double sumOfLogarithms() {
        if (!this.hasSumOfLogarithms) {
            return Double.NaN;
        }
        return this.sumOfLogarithms;
    }

    public synchronized double sumOfPowers(int k) {
        if (!this.hasSumOfPowers(k)) {
            return Double.NaN;
        }
        if (k == -1) {
            return this.sumOfInversions();
        }
        if (k == 0) {
            return this.size();
        }
        if (k == 1) {
            return this.sum();
        }
        if (k == 2) {
            return this.sumOfSquares();
        }
        return this.sumOfPowers[k - 3];
    }

    @Override
    public synchronized String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        if (this.hasSumOfLogarithms()) {
            buf.append("Geometric mean: " + this.geometricMean());
            buf.append("\nProduct: " + this.product() + "\n");
        }
        if (this.hasSumOfInversions()) {
            buf.append("Harmonic mean: " + this.harmonicMean());
            buf.append("\nSum of inversions: " + this.sumOfInversions() + "\n");
        }
        int maxOrder = this.getMaxOrderForSumOfPowers();
        int maxPrintOrder = Math.min(6, maxOrder);
        if (maxOrder > 2) {
            if (maxOrder >= 3) {
                buf.append("Skew: " + this.skew() + "\n");
            }
            if (maxOrder >= 4) {
                buf.append("Kurtosis: " + this.kurtosis() + "\n");
            }
            int i = 3;
            while (i <= maxPrintOrder) {
                buf.append("Sum of powers(" + i + "): " + this.sumOfPowers(i) + "\n");
                ++i;
            }
            int k = 0;
            while (k <= maxPrintOrder) {
                buf.append("Moment(" + k + ",0): " + this.moment(k, 0.0) + "\n");
                ++k;
            }
            k = 0;
            while (k <= maxPrintOrder) {
                buf.append("Moment(" + k + ",mean()): " + this.moment(k, this.mean()) + "\n");
                ++k;
            }
        }
        return buf.toString();
    }

    protected void xcheckOrder(int k) {
    }

    protected boolean xequals(Object object) {
        if (!(object instanceof MightyStaticBin1D)) {
            return false;
        }
        MightyStaticBin1D other = (MightyStaticBin1D)object;
        return super.equals(other) && this.sumOfInversions() == other.sumOfInversions() && this.sumOfLogarithms() == other.sumOfLogarithms();
    }

    protected boolean xhasSumOfPowers(int fromK, int toK) {
        if (fromK > toK) {
            throw new IllegalArgumentException("fromK must be less or equal to toK");
        }
        return this.getMinOrderForSumOfPowers() <= fromK && toK <= this.getMaxOrderForSumOfPowers();
    }

    protected synchronized boolean xisLegalOrder(int k) {
        return this.getMinOrderForSumOfPowers() <= k && k <= this.getMaxOrderForSumOfPowers();
    }
}

