/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.ref.Histogram;

abstract class AbstractHistogram1D
extends Histogram
implements IHistogram1D {
    protected IAxis xAxis;

    AbstractHistogram1D(String title) {
        super(title);
    }

    @Override
    public int allEntries() {
        return this.entries() + this.extraEntries();
    }

    @Override
    public int dimensions() {
        return 1;
    }

    @Override
    public int entries() {
        int entries = 0;
        int i = this.xAxis.bins();
        while (--i >= 0) {
            entries += this.binEntries(i);
        }
        return entries;
    }

    @Override
    public int extraEntries() {
        return this.binEntries(-2) + this.binEntries(-1);
    }

    int map(int index) {
        int bins = this.xAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    @Override
    public int[] minMaxBins() {
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        int minBinX = -1;
        int maxBinX = -1;
        int i = this.xAxis.bins();
        while (--i >= 0) {
            double value = this.binHeight(i);
            if (value < minValue) {
                minValue = value;
                minBinX = i;
            }
            if (!(value > maxValue)) continue;
            maxValue = value;
            maxBinX = i;
        }
        int[] result = new int[]{minBinX, maxBinX};
        return result;
    }

    @Override
    public double sumAllBinHeights() {
        return this.sumBinHeights() + this.sumExtraBinHeights();
    }

    @Override
    public double sumBinHeights() {
        double sum = 0.0;
        int i = this.xAxis.bins();
        while (--i >= 0) {
            sum += this.binHeight(i);
        }
        return sum;
    }

    @Override
    public double sumExtraBinHeights() {
        return this.binHeight(-2) + this.binHeight(-1);
    }

    @Override
    public IAxis xAxis() {
        return this.xAxis;
    }
}

