/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.ref.AbstractHistogram2D;
import hep.aida.ref.FixedAxis;
import hep.aida.ref.Histogram1D;
import hep.aida.ref.VariableAxis;

public class Histogram2D
extends AbstractHistogram2D
implements IHistogram2D {
    private double[][] heights;
    private double[][] errors;
    private int[][] entries;
    private int nEntry;
    private double sumWeight;
    private double sumWeightSquared;
    private double meanX;
    private double rmsX;
    private double meanY;
    private double rmsY;

    public Histogram2D(String title, double[] xEdges, double[] yEdges) {
        this(title, new VariableAxis(xEdges), new VariableAxis(yEdges));
    }

    public Histogram2D(String title, int xBins, double xMin, double xMax, int yBins, double yMin, double yMax) {
        this(title, new FixedAxis(xBins, xMin, xMax), new FixedAxis(yBins, yMin, yMax));
    }

    public Histogram2D(String title, IAxis xAxis, IAxis yAxis) {
        super(title);
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        int xBins = xAxis.bins();
        int yBins = yAxis.bins();
        this.entries = new int[xBins + 2][yBins + 2];
        this.heights = new double[xBins + 2][yBins + 2];
        this.errors = new double[xBins + 2][yBins + 2];
    }

    @Override
    public int allEntries() {
        return this.nEntry;
    }

    @Override
    public int binEntries(int indexX, int indexY) {
        return this.entries[this.mapX(indexX)][this.mapY(indexY)];
    }

    @Override
    public double binError(int indexX, int indexY) {
        return Math.sqrt(this.errors[this.mapX(indexX)][this.mapY(indexY)]);
    }

    @Override
    public double binHeight(int indexX, int indexY) {
        return this.heights[this.mapX(indexX)][this.mapY(indexY)];
    }

    @Override
    public double equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    @Override
    public void fill(double x, double y) {
        int xBin = this.mapX(this.xAxis.coordToIndex(x));
        int yBin = this.mapY(this.yAxis.coordToIndex(y));
        int[] nArray = this.entries[xBin];
        int n = yBin;
        nArray[n] = nArray[n] + 1;
        double[] dArray = this.heights[xBin];
        int n2 = yBin;
        dArray[n2] = dArray[n2] + 1.0;
        double[] dArray2 = this.errors[xBin];
        int n3 = yBin;
        dArray2[n3] = dArray2[n3] + 1.0;
        ++this.nEntry;
        this.sumWeight += 1.0;
        this.sumWeightSquared += 1.0;
        this.meanX += x;
        this.rmsX += x;
        this.meanY += y;
        this.rmsY += y;
    }

    @Override
    public void fill(double x, double y, double weight) {
        int xBin = this.mapX(this.xAxis.coordToIndex(x));
        int yBin = this.mapY(this.yAxis.coordToIndex(y));
        int[] nArray = this.entries[xBin];
        int n = yBin;
        nArray[n] = nArray[n] + 1;
        double[] dArray = this.heights[xBin];
        int n2 = yBin;
        dArray[n2] = dArray[n2] + weight;
        double[] dArray2 = this.errors[xBin];
        int n3 = yBin;
        dArray2[n3] = dArray2[n3] + weight * weight;
        ++this.nEntry;
        this.sumWeight += weight;
        this.sumWeightSquared += weight * weight;
        this.meanX += x * weight;
        this.rmsX += x * weight * weight;
        this.meanY += y * weight;
        this.rmsY += y * weight * weight;
    }

    @Override
    protected IHistogram1D internalSliceX(String title, int indexY1, int indexY2) {
        if (indexY2 < indexY1) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int sliceBins = this.xAxis.bins() + 2;
        int[] sliceEntries = new int[sliceBins];
        double[] sliceHeights = new double[sliceBins];
        double[] sliceErrors = new double[sliceBins];
        int i = 0;
        while (i < sliceBins) {
            int j = indexY1;
            while (j <= indexY2) {
                int n = i;
                sliceEntries[n] = sliceEntries[n] + this.entries[i][j];
                int n2 = i;
                sliceHeights[n2] = sliceHeights[n2] + this.heights[i][j];
                int n3 = i;
                sliceErrors[n3] = sliceErrors[n3] + this.errors[i][j];
                ++j;
            }
            ++i;
        }
        Histogram1D result = new Histogram1D(title, this.xAxis);
        result.setContents(sliceEntries, sliceHeights, sliceErrors);
        return result;
    }

    @Override
    protected IHistogram1D internalSliceY(String title, int indexX1, int indexX2) {
        if (indexX2 < indexX1) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int sliceBins = this.yAxis.bins() + 2;
        int[] sliceEntries = new int[sliceBins];
        double[] sliceHeights = new double[sliceBins];
        double[] sliceErrors = new double[sliceBins];
        int i = indexX1;
        while (i <= indexX2) {
            int j = 0;
            while (j < sliceBins) {
                int n = j;
                sliceEntries[n] = sliceEntries[n] + this.entries[i][j];
                int n2 = j;
                sliceHeights[n2] = sliceHeights[n2] + this.heights[i][j];
                int n3 = j;
                sliceErrors[n3] = sliceErrors[n3] + this.errors[i][j];
                ++j;
            }
            ++i;
        }
        Histogram1D result = new Histogram1D(title, this.yAxis);
        result.setContents(sliceEntries, sliceHeights, sliceErrors);
        return result;
    }

    @Override
    public double meanX() {
        return this.meanX / this.sumWeight;
    }

    @Override
    public double meanY() {
        return this.meanY / this.sumWeight;
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.entries.length) {
            int j = 0;
            while (j < this.entries[0].length) {
                this.entries[i][j] = 0;
                this.heights[i][j] = 0.0;
                this.errors[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        this.nEntry = 0;
        this.sumWeight = 0.0;
        this.sumWeightSquared = 0.0;
        this.meanX = 0.0;
        this.rmsX = 0.0;
        this.meanY = 0.0;
        this.rmsY = 0.0;
    }

    @Override
    public double rmsX() {
        return Math.sqrt(this.rmsX / this.sumWeight - this.meanX * this.meanX / this.sumWeight / this.sumWeight);
    }

    @Override
    public double rmsY() {
        return Math.sqrt(this.rmsY / this.sumWeight - this.meanY * this.meanY / this.sumWeight / this.sumWeight);
    }

    void setContents(int[][] entries, double[][] heights, double[][] errors) {
        this.entries = entries;
        this.heights = heights;
        this.errors = errors;
        int i = 0;
        while (i < entries.length) {
            int j = 0;
            while (j < entries[0].length) {
                this.nEntry += entries[i][j];
                this.sumWeight += heights[i][j];
                ++j;
            }
            ++i;
        }
        this.sumWeightSquared = Double.NaN;
        this.meanX = Double.NaN;
        this.rmsX = Double.NaN;
        this.meanY = Double.NaN;
        this.rmsY = Double.NaN;
    }

    @Override
    public double sumAllBinHeights() {
        return this.sumWeight;
    }
}

