/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.DataTypes;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.ACE.XMLParsers.XMLDocumentParser;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;

public class DataSet
implements Serializable {
    public String identifier = null;
    public DataSet[] sub_sets = null;
    public double start = Double.NaN;
    public double stop = Double.NaN;
    public double[][] feature_values = null;
    public String[] feature_names = null;
    public DataSet parent = null;
    private static final long serialVersionUID = 3L;

    public void orderAndCompactFeatures(FeatureDefinition[] definitions, boolean is_top_level) throws Exception {
        double[][] new_feature_values = new double[definitions.length][];
        if (this.feature_names == null || this.feature_values == null) {
            int feat = 0;
            while (feat < new_feature_values.length) {
                new_feature_values[feat] = null;
                ++feat;
            }
        } else {
            int def = 0;
            while (def < new_feature_values.length) {
                new_feature_values[def] = null;
                int feat = 0;
                while (feat < this.feature_names.length) {
                    if (definitions[def].name.equals(this.feature_names[feat])) {
                        if (!is_top_level && !definitions[def].is_sequential) {
                            throw new Exception("Feature " + this.feature_names[feat] + " is present in a sub-set of\n" + "a DataSet, but is marked as non-sequential in its definition.");
                        }
                        if (this.feature_values[feat].length != definitions[def].dimensions) {
                            throw new Exception("Feature " + this.feature_names[feat] + " has " + this.feature_values[feat].length + " values, but should have " + definitions[def].dimensions + "\n" + "according to its definition.");
                        }
                        new_feature_values[def] = this.feature_values[feat];
                        feat = this.feature_values.length;
                    }
                    ++feat;
                }
                ++def;
            }
        }
        this.feature_names = null;
        this.feature_values = new_feature_values;
        if (this.sub_sets != null) {
            int set = 0;
            while (set < this.sub_sets.length) {
                this.sub_sets[set].orderAndCompactFeatures(definitions, false);
                ++set;
            }
        }
    }

    public String[][] getFeatureValuesOfTopLevel(FeatureDefinition[] definitions) {
        if (this.feature_values == null) {
            return null;
        }
        String[][] feature_values_str = new String[this.feature_values.length][];
        int i = 0;
        while (i < this.feature_values.length) {
            int j;
            if (this.feature_values[i] == null) {
                feature_values_str[i] = new String[definitions[i].dimensions];
                j = 0;
                while (j < feature_values_str[i].length) {
                    feature_values_str[i][j] = "?";
                    ++j;
                }
            } else {
                feature_values_str[i] = new String[this.feature_values[i].length];
                j = 0;
                while (j < this.feature_values[i].length) {
                    feature_values_str[i][j] = String.valueOf(this.feature_values[i][j]);
                    ++j;
                }
            }
            ++i;
        }
        return feature_values_str;
    }

    public String[][][] getFeatureValuesOfSubSections(FeatureDefinition[] definitions) {
        if (this.sub_sets == null) {
            return null;
        }
        String[][][] feature_values_str = new String[this.sub_sets.length][][];
        int i = 0;
        while (i < this.sub_sets.length) {
            feature_values_str[i] = this.sub_sets[i].getFeatureValuesOfTopLevel(definitions);
            ++i;
        }
        return feature_values_str;
    }

    public String getDataSetDescription(int depth) {
        String indent = new String("");
        int i = 0;
        while (i < depth) {
            indent = String.valueOf(indent) + "   ";
            ++i;
        }
        String id_string = new String("");
        if (this.identifier != null) {
            id_string = String.valueOf(indent) + "DATASET " + this.identifier + ": ";
            id_string = this.sub_sets != null ? String.valueOf(id_string) + this.sub_sets.length + " sub-sets " : String.valueOf(id_string) + "0 sub-sets ";
            id_string = this.feature_values != null ? String.valueOf(id_string) + this.feature_values.length + " features\n\n" : String.valueOf(id_string) + "0 features\n\n";
        } else {
            id_string = String.valueOf(indent) + "SUB-SET -> Start: " + this.start + "   Stop: " + this.stop + "\n";
        }
        String feature_string = new String("");
        if (this.feature_values != null) {
            int feat = 0;
            while (feat < this.feature_values.length) {
                String this_feature = String.valueOf(indent) + indent;
                if (this.feature_names != null) {
                    this_feature = String.valueOf(this_feature) + this.feature_names[feat] + ": ";
                }
                if (this.feature_values[feat] == null) {
                    this_feature = String.valueOf(this_feature) + "?";
                } else {
                    int val = 0;
                    while (val < this.feature_values[feat].length) {
                        this_feature = String.valueOf(this_feature) + this.feature_values[feat][val] + " ";
                        ++val;
                    }
                }
                this_feature = String.valueOf(this_feature) + "\n";
                feature_string = String.valueOf(feature_string) + this_feature;
                ++feat;
            }
            feature_string = String.valueOf(feature_string) + "\n";
        }
        String sub_set_string = new String("");
        if (this.sub_sets != null) {
            int set = 0;
            while (set < this.sub_sets.length) {
                sub_set_string = String.valueOf(sub_set_string) + this.sub_sets[set].getDataSetDescription(depth + 1);
                ++set;
            }
        }
        return String.valueOf(id_string) + feature_string + sub_set_string;
    }

    public static String getDataSetDescriptions(DataSet[] dataset) {
        String combined_descriptions = new String();
        int i = 0;
        while (i < dataset.length) {
            combined_descriptions = String.valueOf(combined_descriptions) + dataset[i].getDataSetDescription(0);
            ++i;
        }
        return combined_descriptions;
    }

    public static DataSet[] parseDataSetFile(String data_set_file_path) throws Exception {
        Object[] results = (Object[])XMLDocumentParser.parseXMLDocument(data_set_file_path, "feature_vector_file");
        DataSet[] parse_results = new DataSet[results.length];
        int i = 0;
        while (i < parse_results.length) {
            parse_results[i] = (DataSet)results[i];
            ++i;
        }
        return parse_results;
    }

    public static DataSet[] parseDataSetFile(String data_set_file_path, FeatureDefinition[] definitions) throws Exception {
        Object[] results = (Object[])XMLDocumentParser.parseXMLDocument(data_set_file_path, "feature_vector_file");
        DataSet[] parse_results = new DataSet[results.length];
        int i = 0;
        while (i < parse_results.length) {
            parse_results[i] = (DataSet)results[i];
            ++i;
        }
        i = 0;
        while (i < parse_results.length) {
            parse_results[i].orderAndCompactFeatures(definitions, true);
            ++i;
        }
        return parse_results;
    }

    public static DataSet[] parseDataSetFiles(String[] data_set_file_paths, FeatureDefinition[] definitions) throws Exception {
        DataSet[][] segmented_data_sets = new DataSet[data_set_file_paths.length][];
        int number_data_sets = 0;
        int file = 0;
        while (file < segmented_data_sets.length) {
            Object[] results = (Object[])XMLDocumentParser.parseXMLDocument(data_set_file_paths[file], "feature_vector_file");
            DataSet[] parse_results = new DataSet[results.length];
            int i = 0;
            while (i < parse_results.length) {
                parse_results[i] = (DataSet)results[i];
                ++i;
            }
            if (definitions != null) {
                i = 0;
                while (i < parse_results.length) {
                    parse_results[i].orderAndCompactFeatures(definitions, true);
                    ++i;
                }
            }
            segmented_data_sets[file] = parse_results;
            number_data_sets += parse_results.length;
            ++file;
        }
        DataSet[] combined_data_sets = new DataSet[number_data_sets];
        int current_set = 0;
        int file2 = 0;
        while (file2 < segmented_data_sets.length) {
            int set = 0;
            while (set < segmented_data_sets[file2].length) {
                combined_data_sets[current_set] = segmented_data_sets[file2][set];
                ++current_set;
                ++set;
            }
            ++file2;
        }
        return combined_data_sets;
    }

    public static void saveDataSets(DataSet[] data_sets, FeatureDefinition[] definitions, File to_save_to, String comments) throws Exception {
        if (definitions == null) {
            int set = 0;
            while (set < data_sets.length) {
                if (data_sets[set].feature_names == null) {
                    throw new Exception("Could not save because no feature definitions\nwere provided and DataSet " + data_sets[set].identifier + "\n" + "does not hold the names of its features.");
                }
                ++set;
            }
        }
        try {
            FileOutputStream to = new FileOutputStream(to_save_to);
            DataOutputStream writer = new DataOutputStream(to);
            String pre_tree_part = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE feature_vector_file [\n   <!ELEMENT feature_vector_file (comments, data_set+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT data_set (data_set_id, section*, feature*)>\n   <!ELEMENT data_set_id (#PCDATA)>\n   <!ELEMENT section (feature+)>\n   <!ATTLIST section start CDATA \"\"\n                     stop CDATA \"\">\n   <!ELEMENT feature (name, v+)>\n   <!ELEMENT name (#PCDATA)>\n   <!ELEMENT v (#PCDATA)>\n]>\n\n<feature_vector_file>\n\n   <comments>" + comments + "</comments>\n\n");
            writer.writeBytes(pre_tree_part);
            int set = 0;
            while (set < data_sets.length) {
                writer.writeBytes("   <data_set>\n");
                writer.writeBytes("      <data_set_id>" + data_sets[set].identifier + "</data_set_id>\n");
                if (data_sets[set].sub_sets != null) {
                    int sec = 0;
                    while (sec < data_sets[set].sub_sets.length) {
                        DataSet section_set = data_sets[set].sub_sets[sec];
                        writer.writeBytes("      <section start=\"" + section_set.start + "\" stop=\"" + section_set.stop + "\">\n");
                        int feat = 0;
                        while (feat < section_set.feature_values.length) {
                            double[] values = section_set.feature_values[feat];
                            if (values != null) {
                                writer.writeBytes("         <feature>\n");
                                if (section_set.feature_names != null) {
                                    writer.writeBytes("            <name>" + section_set.feature_names[feat] + "</name>\n");
                                } else {
                                    writer.writeBytes("            <name>" + definitions[feat].name + "</name>\n");
                                }
                                int val = 0;
                                while (val < values.length) {
                                    writer.writeBytes("            <v>" + values[val] + "</v>\n");
                                    ++val;
                                }
                                writer.writeBytes("         </feature>\n");
                            }
                            ++feat;
                        }
                        writer.writeBytes("      </section>\n");
                        ++sec;
                    }
                }
                if (data_sets[set].feature_values != null) {
                    int feat = 0;
                    while (feat < data_sets[set].feature_values.length) {
                        double[] values = data_sets[set].feature_values[feat];
                        if (values != null) {
                            writer.writeBytes("      <feature>\n");
                            if (data_sets[set].feature_names != null) {
                                writer.writeBytes("         <name>" + data_sets[set].feature_names[feat] + "</name>\n");
                            } else {
                                writer.writeBytes("         <name>" + definitions[feat].name + "</name>\n");
                            }
                            int val = 0;
                            while (val < values.length) {
                                writer.writeBytes("         <val>" + values[val] + "</val>\n");
                                ++val;
                            }
                            writer.writeBytes("      </feature>\n");
                        }
                        ++feat;
                    }
                }
                writer.writeBytes("   </data_set>\n\n");
                ++set;
            }
            writer.writeBytes("</feature_vector_file>");
            writer.close();
        }
        catch (Exception e) {
            throw new Exception("Unable to write file " + to_save_to.getName() + ".");
        }
    }
}

