/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.XMLParsers;

import jAudioFeatureExtractor.ACE.XMLParsers.ParseFileHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ParseSaveSettings
extends ParseFileHandler {
    private HashMap<String, Boolean> checkedMap_;
    private HashMap<String, String[]> attributeMap_;
    private LinkedList<String> aggregatorNames;
    private LinkedList<String[]> aggregatorFeatures;
    private LinkedList<String[]> aggregatorParameters;
    private LinkedList<String> tmpAggregatorFeature_;
    private LinkedList<String> tmpAggregatorParameters_;
    private LinkedList<String> tmpAttributes_;
    private String name;
    private String windowLength;
    private String windowOverlap;
    private double sampleRate;
    private boolean savePerWindow;
    private boolean saveOverall;
    private boolean normalise;
    private int tagType = -1;
    private boolean inFeature = false;
    private int count = 0;
    private String outputType = "";
    Pattern t = Pattern.compile(".*true.*");
    Pattern f = Pattern.compile(".*false.*");
    Matcher tm;
    Matcher fm;

    @Override
    public void startDocument() throws SAXException {
        this.checkedMap_ = new HashMap();
        this.tmpAttributes_ = new LinkedList();
        this.attributeMap_ = new HashMap();
        this.aggregatorNames = new LinkedList();
        this.aggregatorFeatures = new LinkedList();
        this.aggregatorParameters = new LinkedList();
        this.tmpAggregatorFeature_ = new LinkedList();
        this.tmpAggregatorParameters_ = new LinkedList();
        this.count = 0;
        this.tagType = -1;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String tmp = new String(ch, start, length);
        tmp = tmp.substring(start, start + length);
        switch (this.tagType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.windowLength = tmp;
                break;
            }
            case 3: {
                this.windowOverlap = tmp;
                break;
            }
            case 4: {
                try {
                    this.sampleRate = Double.parseDouble(tmp);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SAXException("sampleRate must be a double");
                }
            }
            case 5: {
                this.tm = this.t.matcher(tmp);
                this.fm = this.f.matcher(tmp);
                if (this.tm.matches()) {
                    this.savePerWindow = true;
                    break;
                }
                if (this.fm.matches()) {
                    this.savePerWindow = false;
                    break;
                }
                throw new SAXException("Valid states are true or false, not " + tmp);
            }
            case 6: {
                this.tm = this.t.matcher(tmp);
                this.fm = this.f.matcher(tmp);
                if (this.tm.matches()) {
                    this.saveOverall = true;
                    break;
                }
                if (this.fm.matches()) {
                    this.saveOverall = false;
                    break;
                }
                throw new SAXException("Valid states are true or false, not " + tmp);
            }
            case 7: {
                this.tm = this.t.matcher(tmp);
                this.fm = this.f.matcher(tmp);
                if (this.tm.matches()) {
                    this.normalise = true;
                    break;
                }
                if (this.fm.matches()) {
                    this.normalise = false;
                    break;
                }
                throw new SAXException("Valid states are true or false, not " + tmp);
            }
            case 8: {
                this.outputType = tmp;
                break;
            }
            case 9: {
                this.tm = this.t.matcher(tmp);
                this.fm = this.f.matcher(tmp);
                if (this.tm.matches()) {
                    this.checkedMap_.put(this.name, true);
                    break;
                }
                if (this.fm.matches()) {
                    this.checkedMap_.put(this.name, false);
                    break;
                }
                throw new SAXException("Valid states are true or false, not " + tmp);
            }
            case 10: {
                this.tmpAttributes_.add(tmp);
                break;
            }
            case 11: {
                this.name = tmp;
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                this.aggregatorNames.add(tmp);
                break;
            }
            case 14: {
                this.tmpAggregatorFeature_.add(tmp);
                break;
            }
            case 15: {
                this.tmpAggregatorParameters_.add(tmp);
                break;
            }
            default: {
                throw new SAXException("Unknwon Tag Type " + this.tagType + "in characters");
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.parsed_file_contents = new Object[12];
        int i = 0;
        this.parsed_file_contents[i++] = this.windowLength;
        this.parsed_file_contents[i++] = this.windowOverlap;
        this.parsed_file_contents[i++] = new Double(this.sampleRate);
        this.parsed_file_contents[i++] = new Boolean(this.normalise);
        this.parsed_file_contents[i++] = new Boolean(this.savePerWindow);
        this.parsed_file_contents[i++] = new Boolean(this.saveOverall);
        this.parsed_file_contents[i++] = this.outputType;
        this.parsed_file_contents[i++] = this.checkedMap_;
        this.parsed_file_contents[i++] = this.attributeMap_;
        this.parsed_file_contents[i++] = this.aggregatorNames;
        this.parsed_file_contents[i++] = this.aggregatorFeatures;
        this.parsed_file_contents[i] = this.aggregatorParameters;
        this.count = -1;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("name") || qName.equals("name")) {
            this.tagType = 1;
        } else if (localName.equals("active") || qName.equals("active")) {
            this.tagType = 1;
        } else if (localName.equals("attribute") || qName.equals("attribute")) {
            this.tagType = 1;
        } else if (localName.equals("feature") || qName.equals("feature")) {
            this.attributeMap_.put(this.name, this.tmpAttributes_.toArray(new String[0]));
            this.tmpAttributes_.clear();
            this.tagType = 0;
        } else if (localName.equals("aggregatorName") || qName.equals("aggregatorName")) {
            this.tagType = 12;
        } else if (localName.equals("aggregatorFeature") || qName.equals("aggregatorFeature")) {
            this.tagType = 12;
        } else if (localName.equals("aggregatorAttribute") || qName.equals("aggregatorAttribute")) {
            this.tagType = 12;
        } else if (localName.equals("aggregator") || qName.equals("aggregator")) {
            this.aggregatorFeatures.add(this.tmpAggregatorFeature_.toArray(new String[0]));
            this.aggregatorParameters.add(this.tmpAggregatorParameters_.toArray(new String[0]));
            this.tmpAggregatorFeature_.clear();
            this.tmpAggregatorParameters_.clear();
            this.tagType = 0;
        } else {
            this.tagType = 0;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.count == 0 && !localName.equals("save_settings") && !qName.equals("name")) {
            throw new SAXException("\n\nIt is in reality of the type [" + localName + "].");
        }
        ++this.count;
        if (localName.equals("feature") || qName.equals("feature")) {
            this.tagType = 1;
        } else if (localName.equals("windowSize") || qName.equals("windowSize")) {
            this.tagType = 2;
        } else if (localName.equals("windowOverlap") || qName.equals("windowOverlap")) {
            this.tagType = 3;
        } else if (localName.equals("samplingRate") || qName.equals("samplingRate")) {
            this.tagType = 4;
        } else if (localName.equals("perWindowStats") || qName.equals("perWindowStats")) {
            this.tagType = 5;
        } else if (localName.equals("overallStats") || qName.equals("overallStats")) {
            this.tagType = 6;
        } else if (localName.equals("normalise") || qName.equals("normalise")) {
            this.tagType = 7;
        } else if (localName.equals("outputType") || qName.equals("outputType")) {
            this.tagType = 8;
        } else if (localName.equals("active") || qName.equals("active")) {
            this.tagType = 9;
        } else if (localName.equals("attribute") || qName.equals("attribute")) {
            this.tagType = 10;
        } else if (localName.equals("name") || qName.equals("name")) {
            this.tagType = 11;
        } else if (localName.equals("aggregator") || qName.equals("aggregator")) {
            this.tagType = 12;
        } else if (localName.equals("aggregatorName") || qName.equals("aggregatorName")) {
            this.tagType = 13;
        } else if (localName.equals("aggregatorFeature") || qName.equals("aggregatorFeature")) {
            this.tagType = 14;
        } else if (localName.equals("aggregatorAttribute") || qName.equals("aggregatorAttribute")) {
            this.tagType = 15;
        }
    }
}

