/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.AggregatorDefinition;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import java.io.DataOutputStream;

public abstract class Aggregator {
    double[] result = null;
    AggregatorDefinition metadata;
    FeatureDefinition definition;
    public static final String LINE_SEP = System.getProperty("line.separator");

    public String[] getFeaturesToApply() {
        return null;
    }

    public String[] getParamaters() {
        return null;
    }

    public Object clone() {
        return null;
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.definition;
    }

    public AggregatorDefinition getAggregatorDefinition() {
        return this.metadata;
    }

    public void init(int[] featureIndecis) throws Exception {
    }

    public void setSource(FeatureExtractor feature) {
    }

    public void aggregate(double[][][] values) throws Exception {
    }

    public void outputACEFeatureKeyEntries(DataOutputStream output) throws Exception {
        output.writeBytes("\t<feature>" + LINE_SEP);
        output.writeBytes("\t\t<name>" + this.definition.name + "</name>" + LINE_SEP);
        output.writeBytes("\t\t<description>" + this.definition.description + "</description>" + LINE_SEP);
        output.writeBytes("\t\t<is_sequential>" + this.definition.is_sequential + "</is_sequential>" + LINE_SEP);
        output.writeBytes("\t\t<parallel_dimensions>" + this.definition.dimensions + "</parallel_dimensions>" + LINE_SEP);
        output.writeBytes("\t</feature>" + LINE_SEP);
    }

    public void outputACEValueEntries(DataOutputStream output) throws Exception {
        output.writeBytes("\t\t<feature>" + LINE_SEP);
        output.writeBytes("\t\t\t<name>" + this.definition.name + "</name>" + LINE_SEP);
        int i = 0;
        while (i < this.result.length) {
            output.writeBytes("\t\t\t<v>" + StringMethods.getDoubleInScientificNotation(this.result[i], 4) + "</v>" + LINE_SEP);
            ++i;
        }
        output.writeBytes("\t\t</feature>" + LINE_SEP);
    }

    public void outputARFFHeaderEntries(DataOutputStream output) throws Exception {
        int i = 0;
        while (i < this.definition.dimensions) {
            output.writeBytes("@ATTRIBUTE \"" + this.definition.name + i + "\" NUMERIC" + LINE_SEP);
            ++i;
        }
    }

    public void outputARFFValueEntries(DataOutputStream output) throws Exception {
        output.writeBytes(StringMethods.getDoubleInScientificNotation(this.result[0], 4));
        int i = 1;
        while (i < this.definition.dimensions) {
            output.writeBytes("," + StringMethods.getDoubleInScientificNotation(this.result[i], 4));
            ++i;
        }
    }

    public void setParameters(String[] featureNames, String[] params) throws Exception {
    }

    protected int calculateOffset(double[][][] values, int[] featureList) {
        int ret = 0;
        int i = 0;
        while (i < featureList.length) {
            int offset = 0;
            while (values[offset][featureList[i]] == null) {
                ++offset;
            }
            if (offset > ret) {
                ret = offset;
            }
            ++i;
        }
        return ret;
    }

    protected int[][] collapseFeatures(double[][][] values, int[] indecis) {
        int count = 0;
        int i = 0;
        while (i < indecis.length) {
            if (values[values.length - 1][indecis[i]] != null) {
                count += values[values.length - 1][indecis[i]].length;
            }
            ++i;
        }
        int[][] ret = new int[count][2];
        count = 0;
        int i2 = 0;
        while (i2 < indecis.length) {
            if (values[values.length - 1][indecis[i2]] != null) {
                int j = 0;
                while (j < values[values.length - 1][indecis[i2]].length) {
                    ret[count][0] = indecis[i2];
                    ret[count][1] = j++;
                    ++count;
                }
            }
            ++i2;
        }
        return ret;
    }

    public double[] getResults() {
        return this.result;
    }
}

