/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.AggregatorDefinition;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.GeneralTools.Statistics;
import java.util.Arrays;
import org.oc.ocvolume.dsp.featureExtraction;
import org.oc.ocvolume.dsp.fft;

public class MFCC
extends Aggregator {
    featureExtraction fe = new featureExtraction();
    int index = -1;

    public MFCC() {
        this.metadata = new AggregatorDefinition("MFCC", "Treats the window-by-window data as a 16kHz signal", true, null);
    }

    @Override
    public void aggregate(double[][][] values) {
        this.fe.numCepstra = 4;
        int valuesOffset = 0;
        while (valuesOffset < values.length && values[valuesOffset][this.index] == null) {
            ++valuesOffset;
        }
        if (valuesOffset >= values.length) {
            this.result = new double[this.definition.dimensions * 4];
            int i = 0;
            while (i < this.result.length) {
                this.result[i] = 0.0;
                ++i;
            }
        } else {
            this.result = new double[values[values.length - 1][this.index].length * 4];
            this.definition.dimensions = this.result.length;
            int size = Statistics.ensureIsPowerOfN(values.length - valuesOffset, 2);
            double[] fftArray = new double[size];
            Arrays.fill(fftArray, 0.0);
            int i = 0;
            while (i < values[values.length - 1][this.index].length) {
                Arrays.fill(fftArray, 0.0);
                int fftArrayIndex = 0;
                while (fftArrayIndex + valuesOffset < values.length) {
                    fftArray[fftArrayIndex] = values[fftArrayIndex + valuesOffset][this.index][i];
                    ++fftArrayIndex;
                }
                fft data = new fft();
                double[] magSpectrum = new double[fftArray.length];
                fft.computeFFT(fftArray);
                int j = 0;
                while (j < fftArray.length) {
                    magSpectrum[j] = Math.pow(fft.real[j] * fft.real[j] + fft.imag[j] * fft.imag[j], 0.5);
                    ++j;
                }
                int[] cbin = this.fe.fftBinIndices(16000.0, magSpectrum.length);
                double[] fbank = this.fe.melFilter(magSpectrum, cbin);
                double[] f = this.fe.nonLinearTransformation(fbank);
                double[] cepc = this.fe.cepCoefficients(f);
                int j2 = 0;
                while (j2 < cepc.length) {
                    this.result[i * 4 + j2] = cepc[j2];
                    ++j2;
                }
                ++i;
            }
        }
    }

    @Override
    public Object clone() {
        return new MFCC();
    }

    @Override
    public String[] getFeaturesToApply() {
        return null;
    }

    @Override
    public void init(int[] featureIndecis) throws Exception {
        this.index = featureIndecis[0];
    }

    @Override
    public void setSource(FeatureExtractor feature) {
        FeatureDefinition source = feature.getFeatureDefinition();
        this.definition = new FeatureDefinition("MFCC: " + source.name, String.valueOf(source.description) + System.getProperty("line.separator") + "MFCC of each dimension of this feature", source.is_sequential, source.dimensions * 4);
    }
}

